import*as e from"../../ui/legacy/legacy.js";import*as t from"../../core/i18n/i18n.js";import*as r from"../../core/platform/platform.js";import*as s from"../../core/sdk/sdk.js";import*as i from"../../ui/visual_logging/visual_logging.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as o from"../../core/host/host.js";import*as l from"../../models/text_utils/text_utils.js";import{render as a,html as n,nothing as d}from"../../ui/lit/lit.js";var u={cssText:`.data-grid{border:none}::part(url-outer){width:100%;display:inline-flex;justify-content:flex-start}::part(filter-highlight){font-weight:bold}::part(url-prefix){overflow-x:hidden;text-overflow:ellipsis}::part(url-suffix){flex:none}\n/*# sourceURL=${import.meta.resolve("./developerResourcesListView.css")} */\n`};const c={status:"Status",url:"URL",initiator:"Initiator",totalBytes:"Total Bytes",duration:"Duration",error:"Error",developerResources:"Developer resources",copyUrl:"Copy URL",copyInitiatorUrl:"Copy initiator URL",pending:"pending",success:"success",failure:"failure",sBytes:"{n, plural, =1 {# byte} other {# bytes}}"},h=t.i18n.registerUIStrings("panels/developer_resources/DeveloperResourcesListView.ts",c),p=t.i18n.getLocalizedString.bind(void 0,h),{withThousandsSeparator:g}=r.NumberUtilities;class m extends e.Widget.VBox{#e=[];#t=null;#r;#s=[];constructor(r=(r,s,i)=>{a(n`
            <devtools-data-grid
              name=${p(c.developerResources)}
              striped
              .filters=${r.filters}
               @contextmenu=${r.onContextMenu}
              class="flex-auto"
            >
              <table>
                <tr>
                  <th id="status" sortable fixed width="60px">
                    ${p(c.status)}
                  </th>
                  <th id="url" sortable width="250px">
                    ${p(c.url)}
                  </th>
                  <th id="initiator" sortable width="80px">
                    ${p(c.initiator)}
                  </th>
                  <th id="size" sortable fixed width="80px" align="right">
                    ${p(c.totalBytes)}
                  </th>
                  <th id="duration" sortable fixed width="80px" align="right">
                    ${p(c.duration)}
                  </th>
                  <th id="error-message" sortable width="200px">
                    ${p(c.error)}
                  </th>
                </tr>
                ${r.items.map((s=>n`
                  <tr selected=${s===this.#t||d}
                      data-url=${s.url??d}
                      data-initiator-url=${s.initiator.initiatorUrl??d}>
                    <td>${!0===s.success?p(c.success):!1===s.success?p(c.failure):p(c.pending)}</td>
                    <td title=${s.url} aria-label=${s.url}>${(()=>{const t=function(t){const r=document.createElement("div");e.ARIAUtils.setHidden(r,!0),r.setAttribute("part","url-outer");const s=r.createChild("div");s.setAttribute("part","url-prefix");const i=r.createChild("div");i.setAttribute("part","url-suffix");const o=/^(.*)(\/[^/]*)$/.exec(t);return s.textContent=o?o[1]:t,i.textContent=o?o[2]:"",r}(s.url);return r.highlight(t,s.url,"url"),t})()}</td>
                    <td title=${s.initiator.initiatorUrl||""}
                        aria-label=${s.initiator.initiatorUrl||""}
                        @mouseenter=${()=>r.onInitiatorMouseEnter(s.initiator.frameId)}
                        @mouseleave=${r.onInitiatorMouseLeave}
                    >${s.initiator.initiatorUrl||""}</td>
                    <td aria-label=${null!==s.size?p(c.sBytes,{n:s.size}):d}
                        data-value=${s.size??d}>${null!==s.size?n`<span>${g(s.size)}</span>`:""}</td>
                    <td aria-label=${null!==s.duration?t.TimeUtilities.millisToString(s.duration):d}
                        data-value=${s.duration??d}>${null!==s.duration?n`<span>${t.TimeUtilities.millisToString(s.duration)}</span>`:""}</td>
                    <td class="error-message">${(()=>{const e=document.createElement("span");return s.errorMessage&&(e.textContent=s.errorMessage,r.highlight(e,s.errorMessage,"error-message")),e})()}</td>
                  </tr>`))}
              </table>
            </devtools-data-grid>`,i,{host:r})}){super(!0),this.#r=r,this.registerRequiredCSS(u)}select(e){this.#t=e,this.requestUpdate()}selectedItem(){return this.#t}#i(e,t){const r=t.dataset.url;r&&e.clipboardSection().appendItem(p(c.copyUrl),(()=>{o.InspectorFrontendHost.InspectorFrontendHostInstance.copyText(r)}),{jslogContext:"copy-url"});const s=t.dataset.initiatorUrl;s&&e.clipboardSection().appendItem(p(c.copyInitiatorUrl),(()=>{o.InspectorFrontendHost.InspectorFrontendHostInstance.copyText(s)}),{jslogContext:"copy-initiator-url"})}set items(e){this.#e=[...e],this.requestUpdate()}reset(){this.items=[],this.requestUpdate()}updateFilterAndHighlight(e){this.#s=e,this.requestUpdate()}getNumberOfVisibleItems(){return parseInt(this.contentElement.querySelector("devtools-data-grid")?.getAttribute("aria-rowcount")||"",10)??0}performUpdate(){const e={items:this.#e,filters:this.#s,highlight:this.#o.bind(this),onContextMenu:e=>{e.detail?.element&&this.#i(e.detail.menu,e.detail.element)},onInitiatorMouseEnter:e=>{const t=e?s.FrameManager.FrameManager.instance().getFrame(e):null;t&&t.highlight()},onInitiatorMouseLeave:()=>{s.OverlayModel.OverlayModel.hideDOMNodeHighlight()}};this.#r(e,{},this.contentElement)}#o(t,r,s){const i=this.#s.find((e=>e.key?.split(",")?.includes(s)));if(!i?.regex||t.querySelector(".filter-highlight"))return;const o=i.regex.exec(r);if(!o?.length)return;const a=new l.TextRange.SourceRange(o.index,o[0].length);e.UIUtils.highlightRangesWithStyleClass(t,[a],"filter-highlight");for(const e of t.querySelectorAll(".filter-highlight"))e.setAttribute("part","filter-highlight")}}var v={cssText:`:host{overflow:hidden}.developer-resource-view-toolbar-container{display:flex;border-bottom:1px solid var(--sys-color-divider);flex:0 0 auto}.developer-resource-view-toolbar{width:100%}.developer-resource-view-toolbar-summary{background-color:var(--sys-color-cdt-base-container);border-top:1px solid var(--sys-color-divider);padding-left:5px;flex:0 0 19px;display:flex;padding-right:5px}.developer-resource-view-toolbar-summary .developer-resource-view-message{padding-top:2px;padding-left:1ex;text-overflow:ellipsis;white-space:nowrap;overflow:hidden}.developer-resource-view-results{overflow-y:auto;display:flex;flex:auto}\n/*# sourceURL=${import.meta.resolve("./developerResourcesView.css")} */\n`};const f={filterByText:"Filter by URL and error",loadHttpsDeveloperResources:"Load `HTTP(S)` developer resources through the website you inspect, not through DevTools",enableLoadingThroughTarget:"Load through website",resourcesCurrentlyLoading:"{PH1} resources, {PH2} currently loading",resources:"{n, plural, =1 {# resource} other {# resources}}",numberOfResourceMatch:"{n, plural, =1 {# resource matches} other {# resources match}}",noResourceMatches:"No resource matches"},x=t.i18n.registerUIStrings("panels/developer_resources/DeveloperResourcesView.ts",f),w=t.i18n.getLocalizedString.bind(void 0,x);class b extends e.ThrottledWidget.ThrottledWidget{textFilterRegExp;filterInput;coverageResultsElement;listView;statusToolbarElement;statusMessageElement;loader;constructor(){super(!0),this.registerRequiredCSS(v),this.element.setAttribute("jslog",`${i.panel("developer-resources").track({resize:!0})}`);const t=this.contentElement.createChild("div","developer-resource-view-toolbar-container");t.setAttribute("jslog",`${i.toolbar()}`),t.role="toolbar";const r=t.createChild("devtools-toolbar","developer-resource-view-toolbar");r.role="presentation",this.textFilterRegExp=null,this.filterInput=new e.Toolbar.ToolbarFilter(w(f.filterByText),1),this.filterInput.addEventListener("TextChanged",this.onFilterChanged,this),r.appendToolbarItem(this.filterInput);const o=s.PageResourceLoader.getLoadThroughTargetSetting(),l=new e.Toolbar.ToolbarSettingCheckbox(o,w(f.loadHttpsDeveloperResources),w(f.enableLoadingThroughTarget));r.appendToolbarItem(l),this.coverageResultsElement=this.contentElement.createChild("div","developer-resource-view-results"),this.listView=new m,this.listView.show(this.coverageResultsElement),this.statusToolbarElement=this.contentElement.createChild("div","developer-resource-view-toolbar-summary"),this.statusMessageElement=this.statusToolbarElement.createChild("div","developer-resource-view-message"),this.loader=s.PageResourceLoader.PageResourceLoader.instance(),this.loader.addEventListener("Update",this.update,this),this.update()}async doUpdate(){const e=this.listView.selectedItem();this.listView.reset(),this.listView.items=this.loader.getScopedResourcesLoaded().values(),e&&this.listView.select(e),this.updateStats()}async select(e){await this.lastUpdatePromise,this.listView.select(e)}async selectedItem(){return await this.lastUpdatePromise,this.listView.selectedItem()}updateStats(){const{loading:e,resources:t}=this.loader.getScopedNumberOfResources();this.statusMessageElement.textContent=e>0?w(f.resourcesCurrentlyLoading,{PH1:t,PH2:e}):w(f.resources,{n:t})}onFilterChanged(){if(!this.listView)return;const t=this.filterInput.value();this.textFilterRegExp=t?r.StringUtilities.createPlainTextSearchRegex(t,"i"):null,this.textFilterRegExp?this.listView.updateFilterAndHighlight([{key:"url,error-message",regex:this.textFilterRegExp,negative:!1}]):this.listView.updateFilterAndHighlight([]),this.updateStats();const s=this.listView.getNumberOfVisibleItems();let i="";i=0===s?w(f.noResourceMatches):w(f.numberOfResourceMatch,{n:s}),e.ARIAUtils.alert(i)}}var y=Object.freeze({__proto__:null,DeveloperResourcesRevealer:class{async reveal(t){const r=s.PageResourceLoader.PageResourceLoader.instance().getResourcesLoaded().get(t.key);if(r){await e.ViewManager.ViewManager.instance().showView("developer-resources");const t=await e.ViewManager.ViewManager.instance().view("developer-resources").widget();return await t.select(r)}}},DeveloperResourcesView:b});export{y as DeveloperResourcesView};
