"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAtlasMiddleware = createAtlasMiddleware;
var http_1 = require("@expo/server/build/vendor/http");
var connect_1 = __importDefault(require("connect"));
var morgan_1 = __importDefault(require("morgan"));
var path_1 = __importDefault(require("path"));
var serve_static_1 = __importDefault(require("serve-static"));
var env_1 = require("./env");
var ATLAS_UI_PATH = path_1.default.resolve(__dirname, '../../../build/atlas-ui');
/**
 * Initialize Expo Atlas to gather statistics from Metro during development.
 * This function creates a connect middleware to serve the webui and the Atlas API.
 * It's designed to use any `AtlasSource` implementation and passes it to the webui.
 *
 * @example ```js
 *   import { createAtlasMiddleware, MetroGraphSource } from 'expo-atlas/middleware';
 *
 *   const source = new MetroGraphSource();
 *   const middleware = createAtlasMiddleware(source);
 *
 *   source.onSerializeGraph(...);
 *   app.use('/_expo/atlas', middleware);
 * ```
 */
function createAtlasMiddleware(source) {
    global.EXPO_ATLAS_SOURCE = source;
    var middleware = (0, connect_1.default)();
    if (env_1.env.EXPO_DEBUG) {
        middleware.use((0, morgan_1.default)('tiny'));
    }
    middleware.use((0, serve_static_1.default)(path_1.default.join(ATLAS_UI_PATH, 'client'), {
        maxAge: '1h',
        extensions: ['html'],
    }));
    middleware.use((0, http_1.createRequestHandler)({
        build: path_1.default.join(ATLAS_UI_PATH, 'server'),
    }));
    return middleware;
}
//# sourceMappingURL=middleware.js.map