"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AtlasFileSource = void 0;
exports.listAtlasEntries = listAtlasEntries;
exports.readAtlasEntry = readAtlasEntry;
exports.waitUntilAtlasFileReady = waitUntilAtlasFileReady;
exports.writeAtlasEntry = writeAtlasEntry;
exports.getAtlasPath = getAtlasPath;
exports.getAtlasMetdata = getAtlasMetdata;
exports.validateAtlasFile = validateAtlasFile;
exports.createAtlasFile = createAtlasFile;
exports.ensureAtlasFileExist = ensureAtlasFileExist;
var assert_1 = __importDefault(require("assert"));
var fs_1 = __importDefault(require("fs"));
var path_1 = __importDefault(require("path"));
var package_json_1 = require("../../package.json");
var env_1 = require("../utils/env");
var errors_1 = require("../utils/errors");
var jsonl_1 = require("../utils/jsonl");
var AtlasFileSource = /** @class */ (function () {
    function AtlasFileSource(filePath) {
        this.filePath = filePath;
        //
    }
    AtlasFileSource.prototype.listBundles = function () {
        return listAtlasEntries(this.filePath);
    };
    AtlasFileSource.prototype.getBundle = function (id) {
        var numeric = parseInt(id, 10);
        (0, assert_1.default)(!Number.isNaN(numeric) && numeric > 1, "Invalid entry ID: ".concat(id));
        return readAtlasEntry(this.filePath, Number(id));
    };
    AtlasFileSource.prototype.hasHmrSupport = function () {
        return false;
    };
    AtlasFileSource.prototype.getBundleHmr = function () {
        return null;
    };
    return AtlasFileSource;
}());
exports.AtlasFileSource = AtlasFileSource;
/**
 * List all entries without parsing the data.
 * This only reads the bundle name, and adds a line number as ID.
 *
 * @note Ensure the (de)serialization is in sync with both {@link readAtlasEntry} and {@link writeAtlasEntry}.
 */
function listAtlasEntries(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        var bundlePattern, entries;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    bundlePattern = /^\["([^"]+)","([^"]+)","([^"]+)","([^"]+)","([^"]+)"/;
                    entries = [];
                    return [4 /*yield*/, (0, jsonl_1.forEachJsonLines)(filePath, function (contents, line) {
                            var _a;
                            // Skip the metadata line
                            if (line === 1)
                                return;
                            var _b = (_a = contents.match(bundlePattern)) !== null && _a !== void 0 ? _a : [], _ = _b[0], platform = _b[1], projectRoot = _b[2], sharedRoot = _b[3], entryPoint = _b[4], environment = _b[5];
                            if (platform && projectRoot && sharedRoot && entryPoint && environment) {
                                entries.push({
                                    id: String(line),
                                    platform: platform,
                                    environment: environment,
                                    projectRoot: projectRoot,
                                    sharedRoot: sharedRoot,
                                    entryPoint: entryPoint,
                                });
                            }
                        })];
                case 1:
                    _a.sent();
                    return [2 /*return*/, entries];
            }
        });
    });
}
/**
 * Get the entry by id or line number, and parse the data.
 *
 * @note Ensure the (de)serialization is in sync with both {@link listAtlasEntries} and {@link writeAtlasEntry}.
 */
function readAtlasEntry(filePath, id) {
    return __awaiter(this, void 0, void 0, function () {
        var atlasEntry;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, jsonl_1.parseJsonLine)(filePath, id)];
                case 1:
                    atlasEntry = _a.sent();
                    return [2 /*return*/, {
                            id: String(id),
                            // These values are all strings
                            platform: atlasEntry[0],
                            projectRoot: atlasEntry[1],
                            sharedRoot: atlasEntry[2],
                            entryPoint: atlasEntry[3],
                            environment: atlasEntry[4],
                            // These values are more complex
                            runtimeModules: atlasEntry[5],
                            modules: new Map(atlasEntry[6].map(function (module) { return [module.absolutePath, module]; })),
                            transformOptions: atlasEntry[7],
                            serializeOptions: atlasEntry[8],
                        }];
            }
        });
    });
}
/** Simple promise to avoid mixing appended data */
var writeQueue = Promise.resolve();
/**
 * Wait until the Atlas file has all data written.
 * Note, this is a workaround whenever `process.exit` is required, avoid if possible.
 * @internal
 */
function waitUntilAtlasFileReady() {
    return writeQueue;
}
/**
 * Add a new entry to the Atlas file.
 * This function also ensures the Atlas file is ready to be written to, due to complications with Expo CLI.
 * Eventually, the entry is appended on a new line, so we can load them selectively.
 *
 * @note Ensure the (de)serialization is in sync with both {@link listAtlasEntries} and {@link readAtlasEntry}.
 */
function writeAtlasEntry(filePath, entry) {
    var line = [
        // These values must all be strings, and are available in PartialAtlasBundle type when listing bundles
        entry.platform,
        entry.projectRoot,
        entry.sharedRoot,
        entry.entryPoint,
        entry.environment,
        // These values can be more complex, but are not available in PartialAtlasBundle type when listing bundles
        entry.runtimeModules,
        Array.from(entry.modules.values()),
        entry.transformOptions,
        entry.serializeOptions,
    ];
    writeQueue = writeQueue.then(function () { return (0, jsonl_1.appendJsonLine)(filePath, line); });
    return writeQueue;
}
/** The default location of the metro file */
function getAtlasPath(projectRoot) {
    return path_1.default.join(projectRoot, '.expo/atlas.jsonl');
}
/** The information to validate if a file is compatible with this library version */
function getAtlasMetdata() {
    return { name: package_json_1.name, version: package_json_1.version };
}
/** Validate if the file is compatible with this library version */
function validateAtlasFile(filePath_1) {
    return __awaiter(this, arguments, void 0, function (filePath, metadata) {
        var data;
        if (metadata === void 0) { metadata = getAtlasMetdata(); }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!fs_1.default.existsSync(filePath)) {
                        throw new errors_1.AtlasValidationError('ATLAS_FILE_NOT_FOUND', filePath);
                    }
                    if (env_1.env.EXPO_ATLAS_NO_VALIDATION) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, (0, jsonl_1.parseJsonLine)(filePath, 1)];
                case 1:
                    data = _a.sent();
                    if (data.name !== metadata.name || data.version !== metadata.version) {
                        throw new errors_1.AtlasValidationError('ATLAS_FILE_INCOMPATIBLE', filePath, data.version);
                    }
                    return [2 /*return*/];
            }
        });
    });
}
/**
 * Create or overwrite the file with basic metadata.
 * This metdata is used by the API to determine version compatibility.
 */
function createAtlasFile(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fs_1.default.promises.mkdir(path_1.default.dirname(filePath), { recursive: true })];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, fs_1.default.promises.rm(filePath, { force: true })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0, jsonl_1.appendJsonLine)(filePath, getAtlasMetdata())];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
/**
 * Create the Atlas file if it doesn't exist, or recreate it if it's incompatible.
 */
function ensureAtlasFileExist(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        var error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 5]);
                    return [4 /*yield*/, validateAtlasFile(filePath)];
                case 1:
                    _a.sent();
                    return [3 /*break*/, 5];
                case 2:
                    error_1 = _a.sent();
                    if (!(error_1.code === 'ATLAS_FILE_NOT_FOUND' || error_1.code === 'ATLAS_FILE_INCOMPATIBLE')) return [3 /*break*/, 4];
                    return [4 /*yield*/, createAtlasFile(filePath)];
                case 3:
                    _a.sent();
                    return [2 /*return*/, false];
                case 4: throw error_1;
                case 5: return [2 /*return*/, true];
            }
        });
    });
}
//# sourceMappingURL=AtlasFileSource.js.map