#!/usr/bin/env node
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var arg_1 = __importDefault(require("arg"));
var chalk_1 = __importDefault(require("chalk"));
var open_1 = __importDefault(require("open"));
var path_1 = __importDefault(require("path"));
var createServer_1 = require("./createServer");
var resolveOptions_1 = require("./resolveOptions");
var args = (0, arg_1.default)({
    // Types
    '--help': Boolean,
    '--port': Number,
    '--version': Boolean,
    '--no-open': Boolean,
    // Aliases
    '-h': '--help',
    '-p': '--port',
    '-v': '--version',
});
if (args['--version']) {
    console.log(require('../../package.json').version);
    process.exit(0);
}
if (args['--help']) {
    printLines([
        chalk_1.default.bold('Usage'),
        "  ".concat(chalk_1.default.dim('$'), " expo-atlas ").concat(chalk_1.default.dim('[atlas file]')),
        '',
        chalk_1.default.bold('Options'),
        "  --port".concat(chalk_1.default.dim(', -p'), "      Port to listen on"),
        "  --no-open       Do not open the browser automatically",
        "  --help".concat(chalk_1.default.dim(', -h'), "      Displays this message"),
        "  --version".concat(chalk_1.default.dim(', -v'), "   Displays the current version"),
    ]);
    process.exit(0);
}
process.on('SIGINT', function () { return process.exit(0); });
process.on('SIGTERM', function () { return process.exit(0); });
function run() {
    return __awaiter(this, void 0, void 0, function () {
        var options, server;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, resolveOptions_1.resolveOptions)(args)];
                case 1:
                    options = _a.sent();
                    server = (0, createServer_1.createServer)(options);
                    server.listen(options.port, function () {
                        var href = "http://localhost:".concat(options.port);
                        printLines([
                            "Expo Atlas is ready on: ".concat(chalk_1.default.underline(href)),
                            "  ".concat(chalk_1.default.dim("Using: ".concat(options.atlasFile))),
                        ]);
                        if (options.browserOpen) {
                            (0, open_1.default)(href).catch(function (error) {
                                console.error('Could not automatically open browser:', error.message);
                            });
                        }
                    });
                    return [2 /*return*/];
            }
        });
    });
}
function printLines(lines) {
    console.log("  ".concat(lines.join('\n  ')));
}
run().catch(function (error) {
    if (error.type !== 'AtlasError') {
        throw error;
    }
    if (error.code === 'ATLAS_FILE_INCOMPATIBLE') {
        var atlasFile = path_1.default.relative(process.cwd(), error.filePath);
        console.error('Atlas file is incompatible with this version, use this instead:');
        console.error("  npx expo-atlas@".concat(error.incompatibleVersion, " ").concat(atlasFile));
    }
    else {
        console.error("".concat(error.message, " (").concat(error.code, ")"));
    }
    process.exit(1);
});
//# sourceMappingURL=bin.js.map