"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageNameFromPath = getPackageNameFromPath;
var paths_1 = require("./paths");
/** Pattern to match the last `node_modules/@<org>/<name>` or `node_modules/<name>` occurrence in a string */
var NODE_MODULES_NAME_PATTERN = /(?:.*\/)?node_modules\/((?:@[^/]+\/[^/]+)|[^/]+)/i;
/** A simple map to return previously resolved package names from paths */
var packageNameCache = new Map();
/** Get the package name from absolute path, if the file belongs to a package. */
function getPackageNameFromPath(path) {
    var _a;
    var posixPath = (0, paths_1.convertPathToPosix)(path);
    var packageName = packageNameCache.get(posixPath);
    if (packageName)
        return packageName;
    var _b = (_a = posixPath.match(NODE_MODULES_NAME_PATTERN)) !== null && _a !== void 0 ? _a : [], _match = _b[0], name = _b[1];
    if (name) {
        packageNameCache.set(posixPath, name);
        return name;
    }
    return undefined;
}
//# sourceMappingURL=package.js.map