"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServer = createServer;
var compression_1 = __importDefault(require("compression"));
var express_1 = __importDefault(require("express"));
var AtlasFileSource_1 = require("../data/AtlasFileSource");
var middleware_1 = require("../utils/middleware");
function createServer(options) {
    process.env.NODE_ENV = 'production';
    var source = new AtlasFileSource_1.AtlasFileSource(options.atlasFile);
    var middleware = (0, middleware_1.createAtlasMiddleware)(source);
    var baseUrl = '/_expo/atlas'; // Keep in sync with webui `app.json` `baseUrl`
    var app = (0, express_1.default)();
    app.disable('x-powered-by'); // http://expressjs.com/en/advanced/best-practice-security.html#at-a-minimum-disable-x-powered-by-header
    app.use((0, compression_1.default)());
    app.use(baseUrl, middleware);
    // Add catch-all to redirect to the webui
    app.use(function (req, res, next) { return (!req.url.startsWith(baseUrl) ? res.redirect(baseUrl) : next()); });
    return app;
}
//# sourceMappingURL=createServer.js.map