"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createExpoAtlasMiddleware = createExpoAtlasMiddleware;
var MetroGraphSource_1 = require("./data/MetroGraphSource");
var middleware_1 = require("./utils/middleware");
/**
 * Iniitalize Expo Atlas to gather statistics from Metro when exporting bundles.
 * This function adds the required Metro config, and should be used inside the Expo CLI.
 *
 * @example ```js
 *   const atlasFromProject = requireFrom(projectRoot, 'expo-atlas/cli');
 *   const atlas = atlasFromProject?.createExpoAtlasMiddleware(config);
 *
 *   if (atlas) {
 *     // Register the Atlas middleware, to serve the UI and API.
 *     middleware.use('/_expo/atlas', atlasFromProject.middleware);
 *   }
 * ```
 */
function createExpoAtlasMiddleware(config) {
    var _a, _b;
    var projectRoot = config.projectRoot;
    var source = new MetroGraphSource_1.MetroGraphSource();
    var middleware = (0, middleware_1.createAtlasMiddleware)(source);
    var metroCustomSerializer = (_b = (_a = config.serializer) === null || _a === void 0 ? void 0 : _a.customSerializer) !== null && _b !== void 0 ? _b : (function () { });
    var metroConfig = (0, MetroGraphSource_1.convertMetroConfig)(config);
    // @ts-expect-error Should still be writable at this stage
    config.serializer.customSerializer = function (entryPoint, preModules, graph, serializeOptions) {
        source.serializeGraph({
            entryPoint: entryPoint,
            graph: graph,
            metroConfig: metroConfig,
            preModules: preModules,
            projectRoot: projectRoot,
            serializeOptions: serializeOptions,
        });
        return metroCustomSerializer(entryPoint, preModules, graph, serializeOptions);
    };
    return {
        source: source,
        middleware: middleware,
        /** @deprecated This method does nothing and will be removed in the next major version */
        registerMetro: function () { },
    };
}
//# sourceMappingURL=cli.js.map