package amirz.dngprocessor.device;

import android.util.SparseArray;

import amirz.dngprocessor.params.SensorParams;
import amirz.dngprocessor.parser.TIFFTag;

public class OnePlus6 extends OnePlus {
    @Override
    public boolean isModel(String model) {
        return model.startsWith("ONEPLUS A6");
    }

    @Override
    public void sensorCorrection(SparseArray<TIFFTag> tags, SensorParams sensor) {
        super.sensorCorrection(tags, sensor);
        super.matrixCorrection(tags, sensor);

        if (sensor.gainMap == null) {
            // Extracted from a Camera2 photo
            sensor.gainMap = d2f(
                    3.3370361328125, 3.12744140625, 2.975341796875, 2.7078857421875, 2.4444580078125, 2.2271728515625, 2.0604248046875, 1.9720458984375, 1.9344482421875, 1.952880859375, 2.0250244140625, 2.18701171875, 2.384033203125, 2.6773681640625, 2.9281005859375, 3.1419677734375, 3.3548583984375,
                    3.2327880859375, 2.9757080078125, 2.70556640625, 2.38818359375, 2.115966796875, 1.906494140625, 1.76708984375, 1.6636962890625, 1.629150390625, 1.64453125, 1.727294921875, 1.8604736328125, 2.0703125, 2.33642578125, 2.6546630859375, 2.9547119140625, 3.19677734375,
                    3.1611328125, 2.826171875, 2.4580078125, 2.1396484375, 1.856201171875, 1.6614990234375, 1.5130615234375, 1.42919921875, 1.3994140625, 1.4173583984375, 1.48583984375, 1.613525390625, 1.8077392578125, 2.07373046875, 2.380126953125, 2.77294921875, 3.079833984375,
                    3.056884765625, 2.6405029296875, 2.2603759765625, 1.929443359375, 1.651611328125, 1.4732666015625, 1.3416748046875, 1.2669677734375, 1.2392578125, 1.2601318359375, 1.3236083984375, 1.4332275390625, 1.610595703125, 1.8687744140625, 2.1915283203125, 2.577392578125, 2.989013671875,
                    2.95849609375, 2.4810791015625, 2.0948486328125, 1.770751953125, 1.5208740234375, 1.34033203125, 1.2279052734375, 1.1512451171875, 1.120361328125, 1.1396484375, 1.212890625, 1.3182373046875, 1.481689453125, 1.7080078125, 2.0325927734375, 2.4141845703125, 2.845947265625,
                    2.858154296875, 2.3956298828125, 2.011962890625, 1.6895751953125, 1.440185546875, 1.2708740234375, 1.1510009765625, 1.07861328125, 1.0447998046875, 1.0655517578125, 1.1417236328125, 1.2569580078125, 1.4024658203125, 1.6314697265625, 1.9261474609375, 2.3203125, 2.760498046875,
                    2.81689453125, 2.3809814453125, 1.97705078125, 1.6605224609375, 1.4189453125, 1.251708984375, 1.1285400390625, 1.0570068359375, 1.021728515625, 1.041748046875, 1.1173095703125, 1.2333984375, 1.382568359375, 1.6031494140625, 1.906982421875, 2.2900390625, 2.7471923828125,
                    2.8741455078125, 2.4066162109375, 2.00830078125, 1.696044921875, 1.4451904296875, 1.2745361328125, 1.1553955078125, 1.085693359375, 1.04931640625, 1.07080078125, 1.1396484375, 1.2569580078125, 1.4093017578125, 1.6343994140625, 1.938232421875, 2.3172607421875, 2.7623291015625,
                    2.9769287109375, 2.4993896484375, 2.1123046875, 1.7891845703125, 1.5289306640625, 1.3480224609375, 1.2313232421875, 1.1572265625, 1.12841796875, 1.148681640625, 1.2152099609375, 1.3216552734375, 1.4813232421875, 1.7193603515625, 2.0325927734375, 2.4134521484375, 2.8692626953125,
                    3.0999755859375, 2.6397705078125, 2.253662109375, 1.93408203125, 1.6622314453125, 1.4727783203125, 1.3448486328125, 1.2716064453125, 1.2393798828125, 1.2608642578125, 1.32080078125, 1.4332275390625, 1.6151123046875, 1.8631591796875, 2.178466796875, 2.5755615234375, 3.00537109375,
                    3.2171630859375, 2.8292236328125, 2.4693603515625, 2.134521484375, 1.8638916015625, 1.6602783203125, 1.51123046875, 1.433349609375, 1.401611328125, 1.4202880859375, 1.4886474609375, 1.6136474609375, 1.8143310546875, 2.0699462890625, 2.407958984375, 2.7913818359375, 3.1488037109375,
                    3.2989501953125, 3.024169921875, 2.7403564453125, 2.4090576171875, 2.123291015625, 1.915283203125, 1.763427734375, 1.6651611328125, 1.6361083984375, 1.6492919921875, 1.732421875, 1.8704833984375, 2.06689453125, 2.3446044921875, 2.69384765625, 2.99951171875, 3.2501220703125,
                    3.3668212890625, 3.15380859375, 3.01904296875, 2.7325439453125, 2.470947265625, 2.230712890625, 2.08447265625, 1.996337890625, 1.9534912109375, 1.971435546875, 2.0645751953125, 2.2052001953125, 2.435302734375, 2.69970703125, 2.985595703125, 3.2374267578125, 3.4730224609375
            );
            sensor.gainMapSize = new int[] { 17, 13 };
        }
    }
}
