package SpeedoMeterApp.main;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.widget.TextView;

public final class Speedometer extends Activity implements LocationListener
{
    final int update_interval = 500; // milliseconds
    
    // Data shown to user
    float speed = 0.0f;
    float speed_max = 0.0f;
    
    int num_updates = 0; // GPS update counter
    int no_loc = 0; // Number of null GPS updates
    int no_speed = 0; // Number of GPS updates which don't have speed
    
    LocationManager loc_mgr;
    TextView text;
    
    // Called when the activity is first created.
    @Override
    public void onCreate( Bundle savedInstanceState )
    {
        super.onCreate( savedInstanceState );
        setContentView( R.layout.main );
        
        text = (TextView) findViewById( R.id.speed_text );
        update_speed( 0.0f );
        
        loc_mgr = (LocationManager) getSystemService( Context.LOCATION_SERVICE );
        loc_mgr.requestLocationUpdates( LocationManager.GPS_PROVIDER, update_interval, 0.0f, this );
    }
    
    void update_speed( float x )
    {
        speed = x;
        
        if ( x > speed_max )
            speed_max = x;
        
        String s = String.format( "\n"
                + "Speed:\n"
                + "%.2f m/s\n"
                + "%.0f km/h\n"
                + "\n"
                + "Max speed:\n"
                + "%.2f m/s\n"
                + "%.0f km/h\n"
                + "\n"
                + "Updates: %d\n"
                + "Noloc: %d\n"
                + "Nospeed: %d\n",
                speed, speed * 3.6f,
                speed_max, speed_max * 3.6f,
                num_updates,
                no_loc,
                no_speed
            );
        
        text.setText( s );
    }
    
    public void onLocationChanged( Location loc )
    {
        num_updates++;
        
        if ( loc == null )
        {
            no_loc++;
            return;
        }
            
        if ( !loc.hasSpeed() )
        {
            no_speed++;
            return;
        }
        
        update_speed( loc.getSpeed() );
    }
    
    public void onStatusChanged( String arg0, int arg1, Bundle arg2 ) {}
    public void onProviderEnabled( String arg0 ) {}
    public void onProviderDisabled( String arg0 ) {}
}
