/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.test;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.controls.flyout.MemoryFlyoutPreferences;

public class FlyoutTest {
    private Shell m_shell;
    private CTabFolder m_tabFolder;

    public static void main(String[] args) {
        try {
            FlyoutTest window = new FlyoutTest();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.m_shell.open();
        this.m_shell.layout();
        while (!this.m_shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.m_shell = new Shell();
        this.m_shell.setBounds(600, 300, 800, 600);
        this.m_shell.setText("SWT Application");
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_tabFolder = new CTabFolder((Composite)this.m_shell, 0);
        this.m_tabFolder.setBackground(ColorConstants.button);
        this.m_tabFolder.setSelectionBackground(ColorConstants.button);
        FlyoutControlComposite flyoutComposite = this.createTab("WEST", 1);
        flyoutComposite.setValidDockLocations(3);
        this.createTab("EAST", 2);
        flyoutComposite = this.createTab("NORTH", 4);
        flyoutComposite.setValidDockLocations(12);
        this.createTab("SOUTH", 8);
    }

    private FlyoutControlComposite createTab(String title, int dockLocation) {
        CTabItem tabItem = new CTabItem(this.m_tabFolder, 0);
        tabItem.setText(title);
        MemoryFlyoutPreferences preferences = new MemoryFlyoutPreferences(dockLocation, 0, 200);
        FlyoutControlComposite flyoutControlComposite = new FlyoutControlComposite((Composite)this.m_tabFolder, 0, preferences);
        flyoutControlComposite.setTitleText("Structure");
        Text flyout = new Text(flyoutControlComposite.getFlyoutParent(), 2048);
        flyout.setText("Flyout");
        Text client = new Text(flyoutControlComposite.getClientParent(), 2048);
        client.setText("Client");
        tabItem.setControl((Control)flyoutControlComposite);
        return flyoutControlComposite;
    }
}

