/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.palette;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.internal.draw2d.CustomTooltipProvider;
import org.eclipse.wb.internal.draw2d.JustifyLabel;

public final class JustifyPaletteTooltipProvider
extends CustomTooltipProvider {
    private final String m_header;
    private final String m_details;
    private final int m_wrapChars;

    public JustifyPaletteTooltipProvider(String header, String details, int wrapChars) {
        this.m_header = header;
        this.m_details = details;
        this.m_wrapChars = wrapChars;
    }

    @Override
    protected IFigure createTooltipFigure(IFigure hostFigure) {
        Label headerFigure = new Label(this.m_header);
        Font boldFont = FontDescriptor.createFrom((Font)headerFigure.getFont()).setStyle(1).createFont(null);
        this.m_canvas.addDisposeListener(event -> boldFont.dispose());
        headerFigure.setFont(boldFont);
        JustifyLabel detailsFigure = new JustifyLabel();
        detailsFigure.setBorder(new MarginBorder(new Insets(0, 2, 2, 2)));
        detailsFigure.setWrapChars(this.m_wrapChars);
        detailsFigure.setText(this.m_details);
        Dimension headerSize = headerFigure.getPreferredSize();
        Dimension detailsSize = detailsFigure.getPreferredSize();
        if (headerSize.width > detailsSize.width) {
            detailsFigure.setWrapPixels(headerSize.width + 10);
            detailsSize = detailsFigure.getPreferredSize();
            if (headerSize.width > detailsSize.width) {
                detailsSize.width = headerSize.width + 10;
            }
        }
        headerFigure.setBounds(new Rectangle(detailsSize.width / 2 - headerSize.width / 2, 0, headerSize.width, headerSize.height));
        detailsFigure.setBounds(new Rectangle(0, headerSize.height, detailsSize.width, detailsSize.height));
        Figure tooltipFigure = new Figure();
        tooltipFigure.add((IFigure)headerFigure);
        tooltipFigure.add((IFigure)detailsFigure);
        tooltipFigure.setBounds(new Rectangle(0, 0, detailsSize.width, headerSize.height + detailsSize.height));
        return tooltipFigure;
    }
}

