/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StaticFieldPropertyEditor;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public final class CellConstraintsSupport {
    private final FormLayoutInfo m_layout;
    private final ComponentInfo m_component;
    int x;
    int y;
    int width;
    int height;
    CellConstraints.Alignment alignH;
    CellConstraints.Alignment alignV;
    private int saved_x;
    private int saved_y;
    private int saved_width;
    private int saved_height;
    private CellConstraints.Alignment saved_alignH;
    private CellConstraints.Alignment saved_alignV;
    private ComplexProperty m_complexProperty;

    private boolean needWrite() {
        return this.saved_x != this.x || this.saved_y != this.y || this.saved_width != this.width || this.saved_height != this.height || this.saved_alignH != this.alignH || this.saved_alignV != this.alignV;
    }

    private void rememberWrittenState() {
        this.saved_x = this.x;
        this.saved_y = this.y;
        this.saved_width = this.width;
        this.saved_height = this.height;
        this.saved_alignH = this.alignH;
        this.saved_alignV = this.alignV;
    }

    CellConstraintsSupport(FormLayoutInfo layoutInfo, ComponentInfo componentInfo) {
        this.m_layout = layoutInfo;
        this.m_component = componentInfo;
        FormLayout layout = this.m_layout.getLayoutManager();
        if (layout != null && this.m_component.getComponent() != null && this.m_component.getComponent().getParent() == this.m_layout.getContainer().getContainer()) {
            CellConstraints constraints = layout.getConstraints(this.m_component.getComponent());
            this.x = constraints.gridX;
            this.y = constraints.gridY;
            this.width = constraints.gridWidth;
            this.height = constraints.gridHeight;
            this.alignH = constraints.hAlign;
            this.alignV = constraints.vAlign;
        } else {
            this.height = 1;
            this.width = 1;
            this.y = 1;
            this.x = 1;
            this.alignH = this.alignV = CellConstraints.DEFAULT;
        }
        this.rememberWrittenState();
    }

    public void setSpan(boolean horizontal, Rectangle cells) throws Exception {
        this.x = cells.x;
        this.y = cells.y;
        this.width = cells.width;
        this.height = cells.height;
    }

    public void setAlignH(CellConstraints.Alignment alignment) {
        this.alignH = alignment;
    }

    public void setAlignV(CellConstraints.Alignment alignment) {
        this.alignV = alignment;
    }

    public void write() throws Exception {
        if (this.needWrite()) {
            String source = this.x + ", " + this.y;
            if (this.width != 1 || this.height != 1) {
                source = source + ", " + this.width + ", " + this.height;
            }
            if (this.alignH != CellConstraints.DEFAULT || this.alignV != CellConstraints.DEFAULT) {
                source = source + ", " + String.valueOf(this.alignH) + ", " + String.valueOf(this.alignV);
            }
            if (this.m_component.getAssociation() instanceof InvocationChildAssociation) {
                InvocationChildAssociation association = (InvocationChildAssociation)this.m_component.getAssociation();
                MethodInvocation invocation = association.getInvocation();
                String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
                if (signature.equals("add(java.awt.Component,java.lang.Object)")) {
                    Expression constraintsExpression = (Expression)invocation.arguments().get(1);
                    this.m_layout.getEditor().replaceExpression(constraintsExpression, "\"" + source + "\"");
                } else if (signature.equals("add(java.awt.Component)")) {
                    this.m_layout.getEditor().addInvocationArgument(invocation, 1, "\"" + source + "\"");
                }
            }
            this.rememberWrittenState();
        }
    }

    public Property getPropertyByTitle(String title) throws Exception {
        Property[] propertyArray = this.getCellProperty().getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (property.getTitle().equals(title)) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    public ComplexProperty getCellProperty() throws Exception {
        if (this.m_complexProperty == null) {
            this.m_complexProperty = new ComplexProperty("Constraints", null);
            this.m_complexProperty.setCategory(PropertyCategory.system((int)6));
            IntegerCellProperty xProperty = new IntegerCellProperty(this, "grid x", "x"){

                public boolean isModified() throws Exception {
                    return true;
                }

                @Override
                protected String validate(int value) {
                    int columns = m_layout.getColumns().size();
                    if (1 <= value && value + width - 1 <= columns) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_outOfRange, value, columns - width + 1);
                }
            };
            IntegerCellProperty wProperty = new IntegerCellProperty(this, "grid width", "width"){

                public boolean isModified() throws Exception {
                    return width != 1;
                }

                @Override
                protected Object getDefaultValue() {
                    return 1;
                }

                @Override
                protected String validate(int value) {
                    int columns = m_layout.getColumns().size();
                    if (1 <= value && x + value - 1 <= columns) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_outOfRange, value, columns - x + 1);
                }
            };
            IntegerCellProperty yProperty = new IntegerCellProperty(this, "grid y", "y"){

                public boolean isModified() throws Exception {
                    return true;
                }

                @Override
                protected String validate(int value) {
                    int rows = m_layout.getRows().size();
                    if (1 <= value && value + height - 1 <= rows) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_outOfRange, value, rows - y + 1);
                }
            };
            IntegerCellProperty hProperty = new IntegerCellProperty(this, "grid height", "height"){

                public boolean isModified() throws Exception {
                    return height != 1;
                }

                @Override
                protected Object getDefaultValue() {
                    return 1;
                }

                @Override
                protected String validate(int value) {
                    int rows = m_layout.getRows().size();
                    if (1 <= value && y + value - 1 <= rows) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_outOfRange, value, rows - y + 1);
                }
            };
            AlignmentCellProperty hAlignmentProperty = new AlignmentCellProperty("h alignment", "alignH", CellConstraints.class, new String[]{"DEFAULT", "LEFT", "CENTER", "RIGHT", "FILL"});
            AlignmentCellProperty vAlignmentProperty = new AlignmentCellProperty("v alignment", "alignV", CellConstraints.class, new String[]{"DEFAULT", "TOP", "CENTER", "BOTTOM", "FILL"});
            this.m_complexProperty.setProperties(new Property[]{xProperty, yProperty, wProperty, hProperty, hAlignmentProperty, vAlignmentProperty});
        }
        this.m_complexProperty.setText(MessageFormat.format("{0}, {1}, {2}, {3}, {4}, {5}", this.x, this.y, this.width, this.height, this.alignH, this.alignV));
        return this.m_complexProperty;
    }

    public ImageDescriptor getSmallAlignmentImageDescriptor(boolean horizontal) {
        if (horizontal) {
            if (this.alignH == CellConstraints.LEFT) {
                return CoreImages.ALIGNMENT_H_SMALL_LEFT;
            }
            if (this.alignH == CellConstraints.CENTER) {
                return CoreImages.ALIGNMENT_H_SMALL_CENTER;
            }
            if (this.alignH == CellConstraints.RIGHT) {
                return CoreImages.ALIGNMENT_H_SMALL_RIGHT;
            }
            if (this.alignH == CellConstraints.FILL) {
                return CoreImages.ALIGNMENT_H_SMALL_FILL;
            }
            return null;
        }
        if (this.alignV == CellConstraints.TOP) {
            return CoreImages.ALIGNMENT_V_SMALL_TOP;
        }
        if (this.alignV == CellConstraints.CENTER) {
            return CoreImages.ALIGNMENT_V_SMALL_CENTER;
        }
        if (this.alignV == CellConstraints.BOTTOM) {
            return CoreImages.ALIGNMENT_V_SMALL_BOTTOM;
        }
        if (this.alignV == CellConstraints.FILL) {
            return CoreImages.ALIGNMENT_V_SMALL_FILL;
        }
        return null;
    }

    public void addContextMenu(IMenuManager manager) throws Exception {
        MenuManager manager2 = new MenuManager(ModelMessages.CellConstraintsSupport_horizontalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        this.fillHorizontalAlignmentMenu((IMenuManager)manager2);
        manager2 = new MenuManager(ModelMessages.CellConstraintsSupport_verticalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        this.fillVerticalAlignmentMenu((IMenuManager)manager2);
    }

    public void fillHorizontalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_haDefault, CoreImages.ALIGNMENT_H_MENU_DEFAULT, true, CellConstraints.DEFAULT));
        manager.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_haLeft, CoreImages.ALIGNMENT_H_MENU_LEFT, true, CellConstraints.LEFT));
        manager.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_haCenter, CoreImages.ALIGNMENT_H_MENU_CENTER, true, CellConstraints.CENTER));
        manager.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_haRight, CoreImages.ALIGNMENT_H_MENU_RIGHT, true, CellConstraints.RIGHT));
        manager.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_haFill, CoreImages.ALIGNMENT_H_MENU_FILL, true, CellConstraints.FILL));
    }

    public void fillVerticalAlignmentMenu(IMenuManager manager2) {
        manager2.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_vaDefault, CoreImages.ALIGNMENT_V_MENU_DEFAULT, false, CellConstraints.DEFAULT));
        manager2.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_vaTop, CoreImages.ALIGNMENT_V_MENU_TOP, false, CellConstraints.TOP));
        manager2.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_vaCenter, CoreImages.ALIGNMENT_V_MENU_CENTER, false, CellConstraints.CENTER));
        manager2.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_vaBottom, CoreImages.ALIGNMENT_V_MENU_BOTTOM, false, CellConstraints.BOTTOM));
        manager2.add((IAction)new SetAlignmentAction(ModelMessages.CellConstraintsSupport_vaFill, CoreImages.ALIGNMENT_V_MENU_FILL, false, CellConstraints.FILL));
    }

    private abstract class AbstractCellProperty
    extends Property {
        private final String m_title;
        protected final Field m_field;

        public AbstractCellProperty(String title, String fieldName, PropertyEditor propertyEditor) throws Exception {
            super(propertyEditor);
            this.m_title = title;
            this.m_field = CellConstraintsSupport.class.getDeclaredField(fieldName);
            this.m_field.setAccessible(true);
        }

        public final String getTitle() {
            return this.m_title;
        }

        public final void setValue(Object value) throws Exception {
            if (value == UNKNOWN_VALUE) {
                value = this.getDefaultValue();
            }
            if (value != UNKNOWN_VALUE) {
                String errorMessage = this.validate(value);
                if (errorMessage != null) {
                    UiUtils.openWarning((Shell)DesignerPlugin.getShell(), (String)this.getTitle(), (String)errorMessage);
                    return;
                }
                CellConstraintsSupport.this.m_layout.startEdit();
                try {
                    this.m_field.set(CellConstraintsSupport.this, value);
                    CellConstraintsSupport.this.write();
                }
                finally {
                    CellConstraintsSupport.this.m_layout.endEdit();
                }
            }
        }

        protected Object getDefaultValue() {
            return UNKNOWN_VALUE;
        }

        public Object getValue() throws Exception {
            return this.m_field.get(CellConstraintsSupport.this);
        }

        protected abstract String validate(Object var1) throws Exception;
    }

    private final class AlignmentCellProperty
    extends AbstractCellProperty {
        public AlignmentCellProperty(String title, String fieldName, Class<?> clazz, String[] fieldNames) throws Exception {
            super(title, fieldName, (PropertyEditor)new StaticFieldPropertyEditor());
            StaticFieldPropertyEditor editor = (StaticFieldPropertyEditor)this.getEditor();
            editor.configure(clazz, fieldNames);
        }

        public final boolean isModified() throws Exception {
            return this.getValue() != CellConstraints.DEFAULT;
        }

        @Override
        protected Object getDefaultValue() {
            return CellConstraints.DEFAULT;
        }

        @Override
        protected String validate(Object value) throws Exception {
            return value instanceof CellConstraints.Alignment ? null : ModelMessages.CellConstraintsSupport_alignmentExpected;
        }
    }

    private abstract class IntegerCellProperty
    extends AbstractCellProperty {
        public IntegerCellProperty(String title, String fieldName) throws Exception {
            super(title, fieldName, (PropertyEditor)IntegerPropertyEditor.INSTANCE);
        }

        @Override
        protected final String validate(Object value) throws Exception {
            if (!(value instanceof Integer)) {
                return ModelMessages.CellConstraintsSupport_integerExpected;
            }
            int intValue = (Integer)value;
            return this.validate(intValue);
        }

        protected abstract String validate(int var1);
    }

    private class SetAlignmentAction
    extends ObjectInfoAction {
        private final boolean m_horizontal;
        private final CellConstraints.Alignment m_alignment;

        public SetAlignmentAction(String text, ImageDescriptor icon, boolean horizontal, CellConstraints.Alignment alignment) {
            super((ObjectInfo)CellConstraintsSupport.this.m_layout, text, 8);
            this.setImageDescriptor(icon);
            this.m_horizontal = horizontal;
            this.m_alignment = alignment;
            if (this.m_horizontal) {
                this.setChecked(CellConstraintsSupport.this.alignH == this.m_alignment);
            } else {
                this.setChecked(CellConstraintsSupport.this.alignV == this.m_alignment);
            }
        }

        protected void runEx() throws Exception {
            if (this.m_horizontal) {
                CellConstraintsSupport.this.alignH = this.m_alignment;
            } else {
                CellConstraintsSupport.this.alignV = this.m_alignment;
            }
            CellConstraintsSupport.this.write();
        }
    }
}

