/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;

public class ComplexProperty
extends Property {
    private final String m_title;
    private String m_text;
    private String m_tooltip;
    private boolean m_modified;
    private Property[] m_properties;

    public ComplexProperty(String title, String text) {
        this(title, text, new Property[0]);
    }

    public ComplexProperty(String title, String text, Property[] properties) {
        super(new ComplexPropertyEditor());
        this.m_title = title;
        this.m_text = text;
        this.setText(text);
        this.setProperties(properties);
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getText() throws Exception {
        return this.m_text;
    }

    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
    }

    public void setEditorPresentation(PropertyEditorPresentation presentation) {
        ((ComplexPropertyEditor)this.getEditor()).m_presentation = presentation;
    }

    public Property[] getProperties() {
        return this.m_properties;
    }

    public void setProperties(Property[] properties) {
        this.m_properties = properties;
    }

    public void setProperties(List<Property> properties) {
        Property[] propertiesArray = properties.toArray(new Property[properties.size()]);
        this.setProperties(propertiesArray);
    }

    public void setModified(boolean modified) {
        this.m_modified = modified;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public boolean isModified() throws Exception {
        return this.m_modified;
    }

    @Override
    public Object getValue() throws Exception {
        return null;
    }

    @Override
    public void setValue(Object value) throws Exception {
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class && this.m_tooltip != null) {
            return adapter.cast(new PropertyTooltipTextProvider(){

                @Override
                protected String getText(Property property) throws Exception {
                    return ComplexProperty.this.m_tooltip;
                }
            });
        }
        return super.getAdapter(adapter);
    }

    private static final class ComplexPropertyEditor
    extends TextDisplayPropertyEditor
    implements IComplexPropertyEditor {
        private PropertyEditorPresentation m_presentation;

        private ComplexPropertyEditor() {
        }

        @Override
        public Property[] getProperties(Property property) throws Exception {
            return ((ComplexProperty)property).getProperties();
        }

        @Override
        protected String getText(Property property) throws Exception {
            return ((ComplexProperty)property).getText();
        }

        @Override
        public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
            return false;
        }

        @Override
        public PropertyEditorPresentation getPresentation() {
            return this.m_presentation;
        }
    }
}

