/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public class MarqueeSelectionTool
extends Tool {
    private static final int TOGGLE_MODE = 1;
    private static final int APPEND_MODE = 2;
    private static final Request REQUEST = new Request((Object)"selection");
    private int m_selectionMode;
    private List<EditPart> m_allChildren;
    private List<EditPart> m_selectedEditParts;
    private IFigure m_marqueeFeedbackFigure;

    public MarqueeSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setDisabledCursor(Cursors.NO);
        this.setUnloadWhenFinished(false);
    }

    @Override
    public void deactivate() {
        if (this.m_state == 4) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.m_allChildren = null;
        this.m_selectedEditParts = null;
        this.m_state = 0x40000000;
    }

    @Override
    protected Cursor calculateCursor() {
        switch (this.m_state) {
            case 1: 
            case 2: 
            case 4: {
                return this.getDefaultCursor();
            }
            case 8: {
                return this.getDisabledCursor();
            }
        }
        return super.calculateCursor();
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 4;
                if ((this.m_stateMask & 0x40000) != 0) {
                    this.m_selectionMode = 1;
                } else if ((this.m_stateMask & 0x20000) != 0) {
                    this.m_selectionMode = 2;
                }
            }
        } else {
            this.m_state = 8;
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
        }
        this.refreshCursor();
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.m_state == 4) {
            this.m_state = 0x40000000;
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.m_state == 2 || this.m_state == 4) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.m_selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    private void performMarqueeSelect() {
        IEditPartViewer viewer = this.getCurrentViewer();
        List<EditPart> newSelections = this.calculateNewSelection();
        if (this.m_selectionMode == 2) {
            for (EditPart editPart : newSelections) {
                viewer.appendSelection(editPart);
            }
        } else if (this.m_selectionMode == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            for (EditPart editPart : newSelections) {
                if (editPart.getSelected() == 0) {
                    selected.add(editPart);
                    continue;
                }
                selected.remove(editPart);
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    private List<EditPart> calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        for (EditPart editPart : this.getAllChildren()) {
            if (!editPart.isSelectable()) continue;
            GraphicalEditPart graphicalPart = (GraphicalEditPart)editPart;
            IFigure figure = graphicalPart.getFigure();
            Rectangle r = figure.getBounds().getCopy();
            FigureUtils.translateFigureToAbsolute(figure, (Translatable)r);
            Rectangle marqueeSelectionRectangle = this.getMarqueeSelectionRectangle();
            if (!marqueeSelectionRectangle.contains(r.getTopLeft()) || !marqueeSelectionRectangle.contains(r.getBottomRight()) || !figure.isVisible() || editPart.getTargetEditPart(REQUEST) != editPart) continue;
            newSelections.add(editPart);
        }
        return newSelections;
    }

    private void showTargetFeedback() {
        for (EditPart editPart : this.m_selectedEditParts) {
            editPart.showTargetFeedback(REQUEST);
        }
    }

    private void eraseTargetFeedback() {
        if (this.m_selectedEditParts != null) {
            for (EditPart editPart : this.m_selectedEditParts) {
                editPart.eraseTargetFeedback(REQUEST);
            }
        }
    }

    private void showMarqueeFeedback() {
        if (this.m_marqueeFeedbackFigure == null) {
            this.m_marqueeFeedbackFigure = new Figure(){

                @Override
                protected void paintClientArea(Graphics graphics) {
                    graphics.setLineStyle(4);
                    graphics.setXORMode(true);
                    Rectangle r = this.getClientArea();
                    graphics.drawRectangle(0, 0, r.width - 1, r.height - 1);
                }
            };
            this.m_marqueeFeedbackFigure.setForegroundColor(ColorConstants.white);
            this.m_marqueeFeedbackFigure.setBackgroundColor(ColorConstants.black);
            this.getFeedbackPane().add(this.m_marqueeFeedbackFigure);
        }
        Rectangle bounds = this.getMarqueeSelectionRectangle();
        FigureUtils.translateAbsoluteToFigure(this.m_marqueeFeedbackFigure, (Translatable)bounds);
        this.m_marqueeFeedbackFigure.setBounds(bounds);
    }

    private void eraseMarqueeFeedback() {
        if (this.m_marqueeFeedbackFigure != null) {
            this.getFeedbackPane().remove(this.m_marqueeFeedbackFigure);
            this.m_marqueeFeedbackFigure = null;
        }
    }

    private IFigure getFeedbackPane() {
        return LayerManager.Helper.find((EditPartViewer)this.getCurrentViewer()).getLayer((Object)"Feedback Layer");
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getAbsoluteStartLocation(), this.getAbsoluteLocation());
    }

    private List<EditPart> getAllChildren() {
        if (this.m_allChildren == null || this.m_allChildren.isEmpty()) {
            this.m_allChildren = new ArrayList<EditPart>();
            MarqueeSelectionTool.getAllChildren(this.m_allChildren, (EditPart)this.getCurrentViewer().getRootEditPart());
        }
        return this.m_allChildren;
    }

    private static void getAllChildren(List<EditPart> children, EditPart editPart) {
        for (EditPart childEditPart : editPart.getChildren()) {
            children.add(childEditPart);
            MarqueeSelectionTool.getAllChildren(children, childEditPart);
        }
    }
}

