/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import javax.swing.JButton;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ICreationSupportPermissions;
import org.eclipse.wb.internal.core.model.creation.OpaqueCreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class OpaqueCreationSupportTest
extends SwingModelTest {
    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        ClassInstanceCreation node = (ClassInstanceCreation)panel.getCreationSupport().getNode();
        OpaqueCreationSupport creationSupport = new OpaqueCreationSupport((Expression)node);
        OpaqueCreationSupportTest.assertEquals((Object)"opaque", (Object)creationSupport.toString());
        OpaqueCreationSupportTest.assertSame((Object)node, (Object)creationSupport.getNode());
        OpaqueCreationSupportTest.assertTrue((boolean)creationSupport.isJavaInfo((ASTNode)node));
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.isJavaInfo((ASTNode)JavaInfoUtils.getTypeDeclaration((JavaInfo)panel)));
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.canReorder());
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_add() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new OpaqueCreationSupport("new JButton()"));
        flowLayout.add(newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        OpaqueCreationSupportTest.assertEquals((Object)"new JButton()", (Object)this.m_lastEditor.getSource(newButton.getCreationSupport().getNode()));
        Object node = this.getNode("button = ");
        OpaqueCreationSupportTest.assertTrue((boolean)newButton.isRepresentedBy(node));
    }

    @Test
    public void test_permissions() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        ClassInstanceCreation node = (ClassInstanceCreation)panel.getCreationSupport().getNode();
        OpaqueCreationSupport creationSupport = new OpaqueCreationSupport((Expression)node);
        creationSupport.setJavaInfo((JavaInfo)panel);
        ICreationSupportPermissions permissions = (ICreationSupportPermissions)Mockito.mock(ICreationSupportPermissions.class);
        creationSupport.setPermissions(permissions);
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.canDelete());
        ((ICreationSupportPermissions)Mockito.verify((Object)permissions)).canDelete((JavaInfo)panel);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{permissions});
        Mockito.clearInvocations((Object[])new ICreationSupportPermissions[]{permissions});
        creationSupport.delete();
        ((ICreationSupportPermissions)Mockito.verify((Object)permissions)).delete((JavaInfo)panel);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{permissions});
        Mockito.clearInvocations((Object[])new ICreationSupportPermissions[]{permissions});
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.canReorder());
        ((ICreationSupportPermissions)Mockito.verify((Object)permissions)).canReorder((JavaInfo)panel);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{permissions});
        Mockito.clearInvocations((Object[])new ICreationSupportPermissions[]{permissions});
        OpaqueCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
        ((ICreationSupportPermissions)Mockito.verify((Object)permissions)).canReparent((JavaInfo)panel);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{permissions});
    }
}

