/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.junit.Test;

public class MigLayoutSurroundSupportTest
extends AbstractMigLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button_00 = new JButton();", "      add(button_00, 'cell 0 0');", "    }", "    {", "      JButton button_BAD = new JButton();", "      add(button_BAD, 'cell 0 1');", "    }", "    {", "      JButton button_11 = new JButton();", "      add(button_11, 'cell 1 1');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_00 = MigLayoutSurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_11 = MigLayoutSurroundSupportTest.getButtons(panel).get(2);
        MigLayoutSurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, List.of(button_00, button_11));
    }

    @Test
    public void test_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JTable table = new JTable();", "      add(table, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo table = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutSurroundSupportTest.runSurround("javax.swing.JScrollPane", new ObjectInfo[]{table});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "    {", "      JScrollPane scrollPane = new JScrollPane();", "      add(scrollPane, 'cell 0 0,grow');", "      {", "        JTable table = new JTable();", "        scrollPane.setViewportView(table);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton button_00 = new JButton();", "      add(button_00, 'cell 0 0');", "    }", "    {", "      JButton button_10 = new JButton();", "      add(button_10, 'cell 1 0');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_00 = MigLayoutSurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_10 = MigLayoutSurroundSupportTest.getButtons(panel).get(1);
        MigLayoutSurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_00, button_10});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "    {", "      JPanel panel = new JPanel();", "      add(panel, 'cell 0 0,grow');", "      panel.setLayout(new MigLayout('', '[][]', '[]'));", "      {", "        JButton button_00 = new JButton();", "        panel.add(button_00, 'cell 0 0');", "      }", "      {", "        JButton button_10 = new JButton();", "        panel.add(button_10, 'cell 1 0');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    {", "      JButton button_00 = new JButton();", "      add(button_00, 'cell 0 0');", "    }", "    {", "      JButton button_11 = new JButton();", "      add(button_11, 'cell 1 1');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_00 = MigLayoutSurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_11 = MigLayoutSurroundSupportTest.getButtons(panel).get(1);
        MigLayoutSurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_00, button_11});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "    {", "      JPanel panel = new JPanel();", "      add(panel, 'cell 0 0,grow');", "      panel.setLayout(new MigLayout('', '[][]', '[][]'));", "      {", "        JButton button_00 = new JButton();", "        panel.add(button_00, 'cell 0 0');", "      }", "      {", "        JButton button_11 = new JButton();", "        panel.add(button_11, 'cell 1 1');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    {", "      JButton button_00 = new JButton();", "      add(button_00, 'cell 0 0');", "    }", "    {", "      JButton button_10 = new JButton();", "      add(button_10, 'cell 1 0');", "    }", "    {", "      JButton button_01 = new JButton();", "      add(button_01, 'cell 0 1 2 1,growx,aligny bottom');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_00 = MigLayoutSurroundSupportTest.getButtons(panel).get(0);
        ComponentInfo button_10 = MigLayoutSurroundSupportTest.getButtons(panel).get(1);
        ComponentInfo button_01 = MigLayoutSurroundSupportTest.getButtons(panel).get(2);
        MigLayoutSurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_00, button_10, button_01});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "    {", "      JPanel panel = new JPanel();", "      add(panel, 'cell 0 0,grow');", "      panel.setLayout(new MigLayout('', '[][]', '[][]'));", "      {", "        JButton button_00 = new JButton();", "        panel.add(button_00, 'cell 0 0');", "      }", "      {", "        JButton button_10 = new JButton();", "        panel.add(button_10, 'cell 1 0');", "      }", "      {", "        JButton button_01 = new JButton();", "        panel.add(button_01, 'cell 0 1 2 1,growx,aligny bottom');", "      }", "    }", "  }", "}");
    }

    private static List<ComponentInfo> getButtons(ContainerInfo parent) {
        ArrayList<ComponentInfo> buttons = new ArrayList<ComponentInfo>();
        for (ComponentInfo control : parent.getChildrenComponents()) {
            if (!control.getDescription().getComponentClass().getName().equals("javax.swing.JButton")) continue;
            buttons.add(control);
        }
        return buttons;
    }

    private static IMenuManager createSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        MenuManager resultMenuManager;
        if (objects.size() < 2) {
            resultMenuManager = MigLayoutSurroundSupportTest.getDesignerMenuManager();
            object.getBroadcastObject().addContextMenu(objects, object, (IMenuManager)resultMenuManager);
        } else {
            resultMenuManager = new MenuManager();
            ArrayList<MenuManager> managers = new ArrayList<MenuManager>();
            for (ObjectInfo objectInfo : objects) {
                MenuManager manager = MigLayoutSurroundSupportTest.getDesignerMenuManager();
                object.getBroadcastObject().addContextMenu(objects, objectInfo, (IMenuManager)manager);
                managers.add(manager);
            }
            MenuIntersector.merge((IMenuManager)resultMenuManager, managers);
        }
        return MigLayoutSurroundSupportTest.findChildMenuManager((IContributionManager)resultMenuManager, "Surround with");
    }

    private static IAction getSurroundAction(String actionText, ObjectInfo ... objects) throws Exception {
        MigLayoutSurroundSupportTest.assertFalse((objects.length == 0 ? 1 : 0) != 0);
        IMenuManager surroundManager = MigLayoutSurroundSupportTest.createSurroundManager(objects[0], List.of(objects));
        MigLayoutSurroundSupportTest.assertNotNull((Object)surroundManager);
        return MigLayoutSurroundSupportTest.findChildAction((IContributionManager)surroundManager, actionText);
    }

    private static void assertNoSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        IMenuManager surroundManager = MigLayoutSurroundSupportTest.createSurroundManager(object, objects);
        MigLayoutSurroundSupportTest.assertNull((Object)surroundManager);
    }

    private static void runSurround(String actionText, ObjectInfo ... objects) throws Exception {
        IAction surroundAction = MigLayoutSurroundSupportTest.getSurroundAction(actionText, objects);
        MigLayoutSurroundSupportTest.assertNotNull((Object)surroundAction);
        surroundAction.run();
    }

    private static void runSurround_Composite(ObjectInfo ... objects) throws Exception {
        MigLayoutSurroundSupportTest.runSurround("javax.swing.JPanel", objects);
    }
}

