/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MigLayoutGefTest
extends SwingGefTest {
    private static int COL_GAP = 7;
    private static int ROW_GAP = 7;
    private static int COL_VIRTUAL_SIZE = 25;
    private static int ROW_VIRTUAL_SIZE = 25;
    private static int COL_INSET = 7;
    private static int ROW_INSET = 7;
    private ContainerInfo panel;
    private MigLayoutInfo layout;
    private GraphicalRobot horizontalRobot;
    private GraphicalRobot verticalRobot;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AbstractLayoutTest.configureForTest();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        AbstractLayoutTest.configureDefaults();
        super.tearDown();
    }

    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        AbstractMigLayoutTest.do_configureNewProject();
    }

    @Test
    public void test_setLayout_empty() throws Exception {
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("net.miginfocom.swing.MigLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        this.assertEditor("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[]\"));\n\t}\n}");
    }

    @Test
    public void test_setLayout_replaceGridBagLayout() throws Exception {
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.canvas.select(this.panel);
        this.loadCreationTool("net.miginfocom.swing.MigLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        String source = this.m_lastEditor.getSource();
        Assertions.assertThat((String)source).contains(new CharSequence[]{"new MigLayout("});
    }

    @Test
    public void test_CREATE_filled() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Existing JButton\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)button, 0.5, 0.55).click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Existing JButton\");\n\t\t\tadd(button, \"flowy,cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_empty() throws Exception {
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COL_INSET, ROW_INSET).click();
        this.assertEditor("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_1x1() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t}\n}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE + COL_GAP + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE + ROW_GAP + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[][]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 1 1\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t}\n}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE + COL_GAP + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 1 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_0x1() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t}\n}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE + ROW_GAP + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[][]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 1\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendToColumn_0x1() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(ROW_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[][]\"));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 1\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendToRow_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 1 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_beforeFirstRow() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[][]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 1\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_beforeFirstColumn() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"cell 1 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertRow_endOfComponent() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\tadd(button_2, \"cell 0 1\");\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[][][]\"));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 0 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\tadd(button_2, \"cell 0 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertColumn_endOfComponent() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\tadd(button_2, \"cell 1 0\");\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][][]\", \"[]\"));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"cell 1 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\tadd(button_2, \"cell 2 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_inherited_columnOperations() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t}\n}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"cell 1 0\");\n\t\t}\n\t}\n}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_inherited_rowOperations() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[][]\"));\n\t}\n}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"cell 0 1\");\n\t\t}\n\t}\n}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inX(0.5).outY(ROW_GAP + 1).move();
        MigLayoutGefTest.waitEventLoop(5000);
        this.canvas.assertCommandNull();
    }

    @Ignore
    @Test
    public void test_PASTE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton existing = new JButton(\"My JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.doCopyPaste((JavaInfo)existing);
        this.canvas.target(existing).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t\t{\n\t\t\tJButton existing = new JButton(\"My JButton\");\n\t\t\tadd(existing, \"cell 0 0\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, \"cell 1 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, \"cell 0 0\");\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.canvas.beginDrag(button);
        this.canvas.target(button).inY(0.5).outX(COL_GAP + 1).drag();
        this.canvas.endDrag();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[][]\", \"[]\"));\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, \"cell 1 0\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ADD_virtual_0x0() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t\tinner.setLayout(new MigLayout());\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.panel = (ContainerInfo)MigLayoutGefTest.getJavaInfoByName("inner");
        this.canvas.beginDrag(button);
        this.canvas.target(this.panel).in(COL_INSET, ROW_INSET).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t\tinner.setLayout(new MigLayout());\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\t\tinner.add(button, \"cell 0 0\");\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_inherited() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new MigLayout(\"\", \"[150px][100px]\", \"\"));\n\t}\n}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNull();
    }

    @Test
    public void test_headerColumn_MOVE_forward_beforeOther() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[150px][100px][50px]\", \"\"));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[100px][150px][50px]\", \"[]\"));\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_forward_afterLast() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[150px][100px][50px]\", \"\"));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[100px][50px][150px]\", \"[]\"));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_inherited() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new MigLayout(\"\", \"\", \"[100px][75px]\"));\n\t}\n}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.assertCommandNull();
    }

    @Test
    public void test_headerRow_MOVE_forward_beforeOther() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"\", \"[100px][75px][50px]\"));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[75px][100px][50px]\"));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_forward_afterLast() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"\", \"[100px][75px][50px]\"));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(2);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new MigLayout(\"\", \"[]\", \"[75px][50px][100px]\"));\n\t}\n}");
    }

    @Override
    public String getTestSource(String code) {
        return super.getTestSource("import net.miginfocom.layout.*;\nimport net.miginfocom.swing.*;\n%s".formatted(code));
    }

    private void openPanel(String lines) throws Exception {
        this.panel = this.openContainer(lines);
        if (this.panel.getLayout() instanceof MigLayoutInfo) {
            this.layout = (MigLayoutInfo)this.panel.getLayout();
            IGridInfo grid = this.layout.getGridInfo();
            COL_VIRTUAL_SIZE = grid.getVirtualColumnSize();
            ROW_VIRTUAL_SIZE = grid.getVirtualRowSize();
            COL_GAP = grid.getVirtualColumnGap();
            ROW_GAP = grid.getVirtualRowGap();
            COL_INSET = grid.getColumnIntervals()[0].begin();
            ROW_INSET = grid.getRowIntervals()[0].begin();
        }
        this.horizontalRobot = new GraphicalRobot(this.m_headerHorizontal);
        this.verticalRobot = new GraphicalRobot(this.m_headerVertical);
    }
}

