/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.component.ContainerTest;
import org.junit.Test;

public class LayoutGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_dropLayout_canvas() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t}\n}");
        LayoutInfo newLayout = (LayoutInfo)this.loadCreationTool("java.awt.BorderLayout");
        this.canvas.create();
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}");
        LayoutGefTest.assertSame((Object)newLayout, (Object)panel.getLayout());
    }

    @Test
    public void test_dropLayout_tree() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t}\n}");
        LayoutInfo newLayout = (LayoutInfo)this.loadCreationTool("java.awt.BorderLayout");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}");
        LayoutGefTest.assertSame((Object)newLayout, (Object)panel.getLayout());
    }

    @Test
    public void test_dropLayout_disabledSetLayout_canvas() throws Exception {
        ContainerTest.prepareMyPanel_disabledSetLayout();
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("java.awt.BorderLayout");
        this.canvas.create();
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_dropLayout_disabledSetLayout_tree() throws Exception {
        ContainerTest.prepareMyPanel_disabledSetLayout();
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("java.awt.BorderLayout");
        this.tree.moveOn(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_dropUnknownLayout_noTreeLayout() throws Exception {
        LayoutGefTest.setFileContentSrc("test/MyLayout.java", this.getTestSource("public class MyLayout implements LayoutManager {\n\tpublic void addLayoutComponent(String name, Component comp) {\n\t}\n\tpublic  void removeLayoutComponent(Component comp) {\n\t}\n\tpublic Dimension preferredLayoutSize(Container parent) {\n\t\treturn new Dimension(200, 100);\n\t}\n\tpublic Dimension minimumLayoutSize(Container parent) {\n\t\treturn new Dimension(200, 100);\n\t}\n\tpublic void layoutContainer(Container parent) {\n\t}\n}"));
        LayoutGefTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.cancel();
        this.loadCreationTool("test.MyLayout");
        this.tree.moveOn(panel);
        this.tree.click();
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }
}

