/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class AppletTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_Applet_bounds() throws Exception {
        ContainerInfo applet = this.parseContainer("import java.applet.Applet;", "public class Test extends Applet {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        applet.refresh();
        ComponentInfo button = (ComponentInfo)AppletTest.getJavaInfoByName("button");
        AppletTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)applet.getBounds());
        Rectangle bounds = button.getBounds();
        Assertions.assertThat((int)bounds.x).isGreaterThan(100).isLessThan(300);
        AppletTest.assertEquals((long)bounds.y, (long)5L);
    }

    @Test
    public void test_JApplet_bounds() throws Exception {
        ContainerInfo applet = this.parseContainer("// filler filler filler filler filler", "public class Test extends JApplet {", "  public Test() {", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "  }", "}");
        applet.refresh();
        ComponentInfo contentPane = (ComponentInfo)applet.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)AppletTest.getJavaInfoByName("button");
        AppletTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)applet.getBounds());
        AppletTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)contentPane.getBounds());
        AppletTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)button.getBounds());
    }

    @Test
    public void test_JApplet_getParent() throws Exception {
        ContainerInfo applet = this.parseContainer("public class Test extends JApplet {", "  public Test() {", "  }", "  public void init() {", "    super.getParent();", "  }", "}");
        applet.refresh();
        AppletTest.assertNoErrors((JavaInfo)applet);
        AppletTest.assertHierarchy("{this: javax.swing.JApplet} {this} {}", "  {method: public java.awt.Container javax.swing.JApplet.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_Applet_screenShot() throws Exception {
        ContainerInfo applet = this.parseContainer("import java.applet.Applet;", "public class Test extends Applet {", "  public Test() {", "    setBackground(Color.RED);", "  }", "}");
        applet.refresh();
        AppletTest.assertHasRedPixel(applet);
    }

    @Test
    public void test_JApplet_screenShot() throws Exception {
        ContainerInfo applet = this.parseContainer("// filler filler filler filler filler", "public class Test extends JApplet {", "  public Test() {", "    getContentPane().setBackground(Color.RED);", "  }", "}");
        applet.refresh();
        AppletTest.assertHasRedPixel(applet);
    }

    private static void assertHasRedPixel(ContainerInfo applet) {
        ImageData imageData = applet.getImage().getImageData();
        int pixel = imageData.getPixel(imageData.width / 2, imageData.height / 2);
        RGB rgb = imageData.palette.getRGB(pixel);
        AppletTest.assertEquals((Object)new RGB(255, 0, 0), (Object)rgb);
    }

    @Test
    public void test_GUI_inConstructor() throws Exception {
        ContainerInfo applet = this.parseContainer("public class Test extends JApplet {", "  public Test() {", "    getContentPane().add(new JButton());", "  }", "}");
        AppletTest.assertNoErrors((JavaInfo)applet);
        AppletTest.assertHierarchy("{this: javax.swing.JApplet} {this} {}", "  {method: public java.awt.Container javax.swing.JApplet.getContentPane()} {property} {/getContentPane().add(new JButton())/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/getContentPane().add(new JButton())/}");
        applet.refresh();
        AppletTest.assertNotNull((Object)applet.getComponent());
        AppletTest.assertNotNull((Object)((ComponentInfo)applet.getChildrenComponents().get(0)).getComponent());
    }

    @Test
    public void test_GUI_inMethod_init() throws Exception {
        ContainerInfo applet = this.parseContainer("public class Test extends JApplet {", "  public Test() {", "  }", "  public void init() {", "    getContentPane().add(new JButton());", "  }", "}");
        AppletTest.assertNoErrors((JavaInfo)applet);
        AppletTest.assertHierarchy("{this: javax.swing.JApplet} {this} {}", "  {method: public java.awt.Container javax.swing.JApplet.getContentPane()} {property} {/getContentPane().add(new JButton())/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/getContentPane().add(new JButton())/}");
        applet.refresh();
        AppletTest.assertNotNull((Object)applet.getComponent());
        AppletTest.assertNotNull((Object)((ComponentInfo)applet.getChildrenComponents().get(0)).getComponent());
    }

    @Test
    public void test_GUI_initInExecutionFlow() throws Exception {
        AppletTest.setFileContentSrc("test/MyApplet.java", this.getTestSource("public class MyApplet extends JApplet {", "  public void init() {", "    myInit();", "  }", "  protected void myInit() {", "  }", "}"));
        AppletTest.waitForAutoBuild();
        ContainerInfo applet = this.parseContainer("public class Test extends MyApplet {", "  public Test() {", "  }", "  protected void myInit() {", "    getContentPane().add(new JButton());", "  }", "}");
        applet.refresh();
        AppletTest.assertNoErrors((JavaInfo)applet);
        AppletTest.assertHierarchy("{this: test.MyApplet} {this} {}", "  {method: public java.awt.Container javax.swing.JApplet.getContentPane()} {property} {/getContentPane().add(new JButton())/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {empty} {/getContentPane().add(new JButton())/}");
    }

    @Test
    public void test_applet_in_applet() throws Exception {
        ContainerInfo applet = this.parseContainer("public class Test extends JApplet {", "  private JApplet internalApplet = new JApplet();", "  public Test() {", "  }", "  public void init() {", "  }", "}");
        applet.refresh();
    }
}

