/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.wb.core.model.IGenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.rcp.Activator;
import org.eclipse.wb.internal.rcp.model.rcp.PdeUtils;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageEvaluator;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.BundleImageContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.BundleImageResource;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FileImageContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FileImageResource;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FilterConfigurer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginBundleContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginImagesRoot;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ProjectImageContainer;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.rcp.model.property.ImagePropertyEditorTest;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class ImagePropertyEditorTestPlugin
extends ImagePropertyEditorTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            ImagePropertyEditorTestPlugin.waitForAutoBuild();
        }
    }

    @Override
    protected void configureNewProject() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        ImagePropertyEditorTestPlugin.setFileContentSrc("testplugin/Activator.java", ImagePropertyEditorTestPlugin.getSourceDQ("package testplugin;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "}"));
        IFile file = ImagePropertyEditorTestPlugin.getFile("icons", "1.png");
        ImagePropertyEditorTestPlugin.setFileContent(file, org.eclipse.wb.tests.designer.tests.Activator.getFile("icons/test.png"));
        ImagePropertyEditorTestPlugin.waitForAutoBuild();
        ImagePropertyEditorTestPlugin.forgetCreatedResources();
    }

    @Test
    public void test_ThisPluginImage_OLD() throws Exception {
        this.ensureResourceManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(testplugin.Activator.getDefault(), \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_ThisPluginImage_NEW_workspace() throws Exception {
        this.ensureResourceManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_PluginImage_NEW() throws Exception {
        this.ensureResourceManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")", "Plugin: org.eclipse.jdt.ui /icons/full/elcl16/ch_cancel.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
    }

    @Test
    public void test_ThisPlugin_Value() throws Exception {
        this.ensureResourceManagers();
        GenericProperty property = this.createImagePropertyForSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)values);
        ImagePropertyEditorTestPlugin.assertEquals((long)2L, (long)values.length);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"TestProject", (Object)values[0]);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"icons/1.png", (Object)values[1]);
    }

    @Test
    public void test_Plugin_Value() throws Exception {
        this.ensureResourceManagers();
        GenericProperty property = this.createImagePropertyForSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)values);
        ImagePropertyEditorTestPlugin.assertEquals((long)2L, (long)values.length);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"org.eclipse.jdt.ui", (Object)values[0]);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"/icons/full/elcl16/ch_cancel.png", (Object)values[1]);
    }

    private void ensureResourceManagers() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
    }

    @Ignore
    @Test
    public void test_PluginImagesRoot() throws Exception {
        FilterConfigurer filterConfigurer = new FilterConfigurer(false, false, false, false);
        PluginImagesRoot pluginImagesRoot = new PluginImagesRoot(m_testProject.getProject(), filterConfigurer);
        IImageElement[] elements = pluginImagesRoot.elements();
        ImagePropertyEditorTestPlugin.assertNotNull((Object)elements);
        ImagePropertyEditorTestPlugin.assertEquals((long)1L, (long)elements.length);
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[0], ProjectImageContainer.class, "TestProject");
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[0], "icons/1.png", FileImageContainer.class, FileImageResource.class);
        ProjectImageContainer fileContainer = (ProjectImageContainer)elements[0];
        ImagePropertyEditorTestPlugin.assertNull((Object)fileContainer.findResource("Test-Project", "/icons/1.png"));
        ImagePropertyEditorTestPlugin.assertNull((Object)fileContainer.findResource("TestProject", "/icons/1.png"));
        Object[] fileData = fileContainer.findResource("TestProject", "icons/1.png");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)fileData);
        ImagePropertyEditorTestPlugin.assertEquals((long)3L, (long)fileData.length);
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)fileData[0], ProjectImageContainer.class, "TestProject");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)fileData[1], FileImageContainer.class, "icons");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)fileData[2], FileImageResource.class, "1.png");
        ImagePropertyEditorTestPlugin.assertSame((Object)elements, (Object)pluginImagesRoot.elements());
        filterConfigurer.showRequiredPlugins(true);
        ImagePropertyEditorTestPlugin.assertNotSame((Object)elements, (Object)pluginImagesRoot.elements());
        elements = pluginImagesRoot.elements();
        ImagePropertyEditorTestPlugin.assertNotNull((Object)elements);
        ImagePropertyEditorTestPlugin.assertEquals((long)3L, (long)elements.length);
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[0], ProjectImageContainer.class, "TestProject");
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[1], PluginBundleContainer.class, "org.eclipse.ui");
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[2], PluginBundleContainer.class, "org.eclipse.ui.forms");
        ImagePropertyEditorTestPlugin.assertPluginElement(elements[1], "icons/full/elcl16/close_view.gif", BundleImageContainer.class, BundleImageContainer.class, BundleImageContainer.class, BundleImageResource.class);
        PluginBundleContainer bundleContainer = (PluginBundleContainer)elements[1];
        ImagePropertyEditorTestPlugin.assertNull((Object)bundleContainer.findResource("org.eclipse.UI", "/icons/full/elcl16/close_view.gif"));
        ImagePropertyEditorTestPlugin.assertNull((Object)bundleContainer.findResource("org.eclipse.ui", "icons/full/elcl16/close_view.gif"));
        Object[] bundleData = bundleContainer.findResource("org.eclipse.ui", "/icons/full/elcl16/close_view.gif");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)bundleData);
        ImagePropertyEditorTestPlugin.assertEquals((long)5L, (long)bundleData.length);
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)bundleData[0], PluginBundleContainer.class, "org.eclipse.ui");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)bundleData[1], BundleImageContainer.class, "icons");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)bundleData[2], BundleImageContainer.class, "full");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)bundleData[3], BundleImageContainer.class, "elcl16");
        ImagePropertyEditorTestPlugin.assertPluginElement((IImageElement)bundleData[4], BundleImageResource.class, "close_view.gif");
    }

    @Test
    public void test_PluginImagesRoot_RequiredWithNullPluginId() throws Exception {
        TestProject testProject = null;
        try {
            testProject = new TestProject("RequiredProject");
            PdeProjectConversionUtils.convertToPDE(testProject.getProject(), null, null);
            IFile file = ImagePropertyEditorTestPlugin.getFile(testProject.getProject(), "icons", "2.png");
            ImagePropertyEditorTestPlugin.setFileContent(file, org.eclipse.wb.tests.designer.tests.Activator.getFile("icons/test.png"));
            ImagePropertyEditorTestPlugin.waitForAutoBuild();
            PdeUtils utils = PdeUtils.get((IProject)m_testProject.getProject());
            utils.addPluginImport(new String[]{"RequiredProject"});
            ImagePropertyEditorTestPlugin.waitForAutoBuild();
            FilterConfigurer filterConfigurer = new FilterConfigurer(false, true, false, false);
            PluginImagesRoot pluginImagesRoot = new PluginImagesRoot(m_testProject.getProject(), filterConfigurer);
            IImageElement[] elements = pluginImagesRoot.elements();
            ImagePropertyEditorTestPlugin.assertNotNull((Object)elements);
            ImagePropertyEditorTestPlugin.assertEquals((long)4L, (long)elements.length);
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[0], ProjectImageContainer.class, "RequiredProject");
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[1], ProjectImageContainer.class, "TestProject");
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[2], PluginBundleContainer.class, "org.eclipse.ui");
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[3], PluginBundleContainer.class, "org.eclipse.ui.forms");
            IFile pluginXmlFile = ImagePropertyEditorTestPlugin.getFile(testProject.getProject(), "plugin.xml");
            ImagePropertyEditorTestPlugin.setFileContent(pluginXmlFile, "<?xml version='1.0' encoding='UTF-8'?>\r\n<?eclipse version='3.0'?>\r\n<plugin/>");
            ImagePropertyEditorTestPlugin.getFile(testProject.getProject(), "META-INF/MANIFEST.MF").delete(true, null);
            ImagePropertyEditorTestPlugin.waitForAutoBuild();
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)testProject.getProject());
            ImagePropertyEditorTestPlugin.assertNotNull((Object)plugin);
            ImagePropertyEditorTestPlugin.assertNull((Object)PdeUtils.getId((IPluginModelBase)plugin));
            filterConfigurer.showRequiredPlugins(false);
            filterConfigurer.showRequiredPlugins(true);
            elements = pluginImagesRoot.elements();
            ImagePropertyEditorTestPlugin.assertNotNull((Object)elements);
            ImagePropertyEditorTestPlugin.assertEquals((long)3L, (long)elements.length);
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[0], ProjectImageContainer.class, "TestProject");
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[1], PluginBundleContainer.class, "org.eclipse.ui");
            ImagePropertyEditorTestPlugin.assertPluginElement(elements[2], PluginBundleContainer.class, "org.eclipse.ui.forms");
        }
        finally {
            if (testProject != null) {
                ImagePropertyEditorTestPlugin.do_projectDispose();
                testProject.dispose();
            }
        }
    }

    @Test
    public void test_PluginImagesRoot_NullPluginId() throws Exception {
        ImagePropertyEditorTestPlugin.do_projectDispose();
        ImagePropertyEditorTestPlugin.do_projectCreate();
        try {
            ProjectUtils.addNature((IProject)m_testProject.getProject(), (String)"org.eclipse.pde.PluginNature");
            AbstractPdeTest.createPluginXML("<?xml version='1.0' encoding='UTF-8'?>", "<?eclipse version='3.0'?>", "<plugin/>");
            ImagePropertyEditorTestPlugin.waitForAutoBuild();
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)m_testProject.getProject());
            ImagePropertyEditorTestPlugin.assertNotNull((Object)plugin);
            ImagePropertyEditorTestPlugin.assertNull((Object)PdeUtils.getId((IPluginModelBase)plugin));
            PluginImagesRoot pluginImagesRoot = new PluginImagesRoot(m_testProject.getProject(), new FilterConfigurer(false, false, false, false));
            IImageElement[] elements = pluginImagesRoot.elements();
            ImagePropertyEditorTestPlugin.assertNotNull((Object)elements);
            ImagePropertyEditorTestPlugin.assertEquals((long)0L, (long)elements.length);
        }
        finally {
            ImagePropertyEditorTestPlugin.do_projectDispose();
        }
    }

    private static void assertPluginElement(IImageElement element, String path, Class<?> ... elementsClasses) throws Exception {
        int index = 0;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                String name = stringArray[n2];
                IImageContainer container = (IImageContainer)element;
                IImageElement[] iImageElementArray = container.elements();
                int n3 = iImageElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IImageElement children = iImageElementArray[n4];
                    if (name.equals(children.getName())) {
                        ImagePropertyEditorTestPlugin.assertPluginElement(children, elementsClasses[index++], name);
                        element = children;
                        break block3;
                    }
                    ++n4;
                }
                ImagePropertyEditorTestPlugin.fail((String)("part '" + name + "' of " + path + " not found"));
            }
            ++n2;
        }
    }

    private static void assertPluginElement(IImageElement element, Class<?> elementClass, String name) throws Exception {
        ImagePropertyEditorTestPlugin.assertNotNull((Object)element);
        ImagePropertyEditorTestPlugin.assertInstanceOf(elementClass, (Object)element);
        ImagePropertyEditorTestPlugin.assertEquals((Object)name, (Object)element.getName());
        ImagePropertyEditorTestPlugin.assertNotNull((Object)element.getImage());
    }
}

