/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.rcp.model.jface.ControlDecorationInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class ControlDecorationTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    Text text = new Text(this, SWT.BORDER);", "    {", "      ControlDecoration controlDecoration = new ControlDecoration(text, SWT.LEFT | SWT.TOP);", "      controlDecoration.setDescriptionText(\"My description\");", "    }", "  }", "}");
        shell.refresh();
        ControlDecorationTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new Text(this, SWT.BORDER)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: org.eclipse.swt.widgets.Text} {local-unique: text} {/new Text(this, SWT.BORDER)/ /new ControlDecoration(text, SWT.LEFT | SWT.TOP)/}", "    {new: org.eclipse.jface.fieldassist.ControlDecoration} {local-unique: controlDecoration} {/new ControlDecoration(text, SWT.LEFT | SWT.TOP)/ /controlDecoration.setDescriptionText('My description')/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(0);
        ControlDecorationInfo decoration = (ControlDecorationInfo)text.getChildren(ControlDecorationInfo.class).get(0);
        ControlDecorationTest.assertSame((Object)text, (Object)decoration.getControl());
    }

    @Ignore
    @Test
    public void test_existingImage() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    Text text = new Text(this, SWT.BORDER);", "    {", "      ControlDecoration controlDecoration = new ControlDecoration(text, SWT.LEFT | SWT.TOP);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(0);
        ControlDecorationInfo decoration = (ControlDecorationInfo)text.getChildren(ControlDecorationInfo.class).get(0);
        ManagerUtils.ensure_SWTResourceManager((JavaInfo)shell);
        GenericProperty imageProperty = (GenericProperty)decoration.getPropertyByTitle("image");
        imageProperty.setExpression("org.eclipse.wb.swt.SWTResourceManager.getImage(Test.class, \"/org/eclipse/jface/fieldassist/images/contassist_ovr.gif\")", Property.UNKNOWN_VALUE);
        ControlDecorationTest.assertEquals((Object)new Rectangle(-9, -2, 7, 8), (Object)decoration.getModelBounds());
        IObjectPresentation presentation = decoration.getPresentation();
        ControlDecorationTest.assertFalse((boolean)UiUtils.equals((ImageDescriptor)presentation.getIcon(), (ImageDescriptor)decoration.getDescription().getIcon()));
    }

    @Test
    public void test_virtualImage() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    Text text = new Text(this, SWT.BORDER);", "    {", "      ControlDecoration controlDecoration = new ControlDecoration(text, SWT.LEFT | SWT.TOP);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(0);
        ControlDecorationInfo decoration = (ControlDecorationInfo)text.getChildren(ControlDecorationInfo.class).get(0);
        if (EnvironmentUtils.IS_WINDOWS) {
            ControlDecorationTest.assertEquals((Object)new Rectangle(-9, -2, 7, 8), (Object)decoration.getModelBounds());
        } else {
            ControlDecorationTest.assertEquals((Object)new Rectangle(-16, -1, 7, 8), (Object)decoration.getModelBounds());
        }
        IObjectPresentation presentation = decoration.getPresentation();
        ControlDecorationTest.assertSame((Object)decoration.getDescription().getIcon(), (Object)presentation.getIcon());
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    Text text = new Text(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        ControlInfo text = (ControlInfo)shell.getChildrenControls().get(0);
        ControlDecorationInfo decoration = (ControlDecorationInfo)ControlDecorationTest.createJavaInfo("org.eclipse.jface.fieldassist.ControlDecoration");
        decoration.command_CREATE(text);
        this.assertEditor("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    Text text = new Text(this, SWT.BORDER);", "    {", "      ControlDecoration controlDecoration = new ControlDecoration(text, SWT.LEFT | SWT.TOP);", "      controlDecoration.setDescriptionText('Some description');", "    }", "  }", "}");
        ControlDecorationTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new Text(this, SWT.BORDER)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: org.eclipse.swt.widgets.Text} {local-unique: text} {/new Text(this, SWT.BORDER)/ /new ControlDecoration(text, SWT.LEFT | SWT.TOP)/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "    {new: org.eclipse.jface.fieldassist.ControlDecoration} {local-unique: controlDecoration} {/new ControlDecoration(text, SWT.LEFT | SWT.TOP)/ /controlDecoration.setDescriptionText('Some description')/}");
    }

    @Test
    public void test_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Text text_1 = new Text(this, SWT.BORDER);", "      {", "        ControlDecoration controlDecoration = new ControlDecoration(text_1, SWT.LEFT | SWT.TOP);", "      }", "    }", "    {", "      Text text_2 = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo text_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo text_2 = (ControlInfo)shell.getChildrenControls().get(1);
        ControlDecorationInfo decoration = (ControlDecorationInfo)text_1.getChildren(ControlDecorationInfo.class).get(0);
        decoration.command_ADD(text_2);
        this.assertEditor("import org.eclipse.jface.fieldassist.ControlDecoration;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Text text_1 = new Text(this, SWT.BORDER);", "    }", "    {", "      Text text_2 = new Text(this, SWT.BORDER);", "      {", "        ControlDecoration controlDecoration = new ControlDecoration(text_2, SWT.LEFT | SWT.TOP);", "      }", "    }", "  }", "}");
        ControlDecorationTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new Text(this, SWT.BORDER)/ /new Text(this, SWT.BORDER)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: org.eclipse.swt.widgets.Text} {local-unique: text_1} {/new Text(this, SWT.BORDER)/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "  {new: org.eclipse.swt.widgets.Text} {local-unique: text_2} {/new Text(this, SWT.BORDER)/}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "    {new: org.eclipse.jface.fieldassist.ControlDecoration} {local-unique: controlDecoration} {/new ControlDecoration(text_2, SWT.LEFT | SWT.TOP)/}");
    }
}

