/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import java.util.List;
import javax.swing.JButton;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryContainerInfo;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.FactoryAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.editor.icon.IconPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.Test;

public class InstanceFactoryCreationSupportTest
extends SwingModelTest {
    private static final ImageDescriptor DEFAULT_FACTORY_ICON = DesignerPlugin.getImageDescriptor((String)"components/factory.gif");

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  /**", "  * @wbp.factory.parameter.source text 'Factory button'", "  */", "  public JButton createButton(String text, Icon icon) {", "    return new JButton(text, icon);", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  Test() {", "    add(m_factory.createButton('button', null));", "  }", "}");
        List containers = panel.getChildren(InstanceFactoryContainerInfo.class);
        InstanceFactoryContainerInfo container = (InstanceFactoryContainerInfo)containers.get(0);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"{instance factory container}", (Object)container.toString());
        List factories = container.getChildren(InstanceFactoryInfo.class);
        InstanceFactoryCreationSupportTest.assertEquals((long)1L, (long)factories.size());
        InstanceFactoryCreationSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Association association = button.getAssociation();
        InstanceFactoryCreationSupportTest.assertInstanceOf(InvocationChildAssociation.class, (Object)association);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"add(m_factory.createButton(\"button\", null))", (Object)association.getSource());
        InstanceFactoryCreationSupport creationSupport = (InstanceFactoryCreationSupport)button.getCreationSupport();
        InstanceFactoryCreationSupportTest.assertEquals((Object)"instance factory: {field-initializer: m_factory} createButton(java.lang.String,javax.swing.Icon)", (Object)creationSupport.toString());
        InstanceFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canDelete());
        InstanceFactoryCreationSupportTest.assertTrue((creationSupport.getNode() != null ? 1 : 0) != 0);
        InstanceFactoryCreationSupportTest.assertInstanceOf(CreationSupport.class, (Object)creationSupport.getLiveComponentCreation());
        FactoryMethodDescription description = creationSupport.getDescription();
        InstanceFactoryCreationSupportTest.assertTrue((boolean)description.isFactory());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"test.InstanceFactory", (Object)description.getDeclaringClass().getName());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"javax.swing.JButton", (Object)description.getReturnClass().getName());
        InstanceFactoryCreationSupportTest.assertEquals((long)2L, (long)description.getParameters().size());
        ParameterDescription parameter = description.getParameter(0);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"text", (Object)parameter.getName());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"\"Factory button\"", (Object)parameter.getDefaultSource());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"setText(java.lang.String)", (Object)parameter.getProperty());
        InstanceFactoryCreationSupportTest.assertNotNull((Object)parameter.toString());
        InstanceFactoryCreationSupportTest.assertInstanceOf(StringConverter.class, (Object)parameter.getConverter());
        InstanceFactoryCreationSupportTest.assertInstanceOf(StringPropertyEditor.class, (Object)parameter.getEditor());
        parameter = description.getParameter(1);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"icon", (Object)parameter.getName());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"setIcon(javax.swing.Icon)", (Object)parameter.getProperty());
        InstanceFactoryCreationSupportTest.assertSame(null, (Object)parameter.getConverter());
        InstanceFactoryCreationSupportTest.assertInstanceOf(IconPropertyEditor.class, (Object)parameter.getEditor());
        GenericProperty textProperty = (GenericProperty)button.getPropertyByTitle("text");
        List<ExpressionAccessor> accessors = InstanceFactoryCreationSupportTest.getGenericPropertyAccessors(textProperty);
        InstanceFactoryCreationSupportTest.assertEquals((long)2L, (long)accessors.size());
        InstanceFactoryCreationSupportTest.assertInstanceOf(SetterAccessor.class, (Object)accessors.get(0));
        InstanceFactoryCreationSupportTest.assertInstanceOf(FactoryAccessor.class, (Object)accessors.get(1));
        InstanceFactoryCreationSupportTest.assertTrue((boolean)textProperty.isModified());
        InstanceFactoryCreationSupportTest.assertEquals((Object)"button", (Object)textProperty.getValue());
        InstanceFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(m_factory.createButton(\"button\", null))"});
        textProperty.setValue((Object)"12345");
        InstanceFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(m_factory.createButton(\"12345\", null))"});
        textProperty.setValue(Property.UNKNOWN_VALUE);
        InstanceFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(m_factory.createButton(\"Factory button\", null))"});
        InstanceFactoryCreationSupportTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  Test() {", "  }", "}");
    }

    @Test
    public void test_parse2() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  private final InstanceFactory m_factory2 = new InstanceFactory();", "  Test() {", "    add(m_factory.createButton('111'));", "    add(m_factory2.createButton('222'));", "  }", "}");
        List containers = panel.getChildren(InstanceFactoryContainerInfo.class);
        InstanceFactoryContainerInfo container = (InstanceFactoryContainerInfo)containers.get(0);
        InstanceFactoryCreationSupportTest.assertFalse((boolean)container.canDelete());
        container.delete();
        IObjectPresentation presentation = container.getPresentation();
        InstanceFactoryCreationSupportTest.assertEquals((Object)"(instance factories)", (Object)presentation.getText());
        InstanceFactoryCreationSupportTest.assertNotNull((Object)presentation.getIcon());
        List factories = container.getChildren(InstanceFactoryInfo.class);
        InstanceFactoryCreationSupportTest.assertEquals((long)2L, (long)factories.size());
        InstanceFactoryInfo factory = (InstanceFactoryInfo)factories.get(0);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"m_factory", (Object)factory.getVariableSupport().getName());
        factory = (InstanceFactoryInfo)factories.get(1);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"m_factory2", (Object)factory.getVariableSupport().getName());
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        List factories2 = InstanceFactoryInfo.getFactories((JavaInfo)panel, factoryClass);
        InstanceFactoryCreationSupportTest.assertEquals((long)2L, (long)factories2.size());
        InstanceFactoryCreationSupportTest.assertEquals((long)2L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InstanceFactoryCreationSupport creationSupport = (InstanceFactoryCreationSupport)button.getCreationSupport();
        InstanceFactoryCreationSupportTest.assertEquals((Object)"m_factory", (Object)creationSupport.getFactory().getVariableSupport().getName());
        button = (ComponentInfo)panel.getChildrenComponents().get(1);
        creationSupport = (InstanceFactoryCreationSupport)button.getCreationSupport();
        InstanceFactoryCreationSupportTest.assertEquals((Object)"m_factory2", (Object)creationSupport.getFactory().getVariableSupport().getName());
    }

    @Test
    public void test_parse_createInstanceFactory_usingStaticFactory() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        this.m_waitForAutoBuild = true;
        this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = createMyFactory();", "  public Test() {", "  }", "  /**", "  * @wbp.factory", "  */", "  private static InstanceFactory createMyFactory() {", "    return new InstanceFactory();", "  }", "}");
        InstanceFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {instance factory container}", "    {static factory: test.Test createMyFactory()} {field-initializer: m_factory} {/createMyFactory()/}");
    }

    @Test
    public void test_factoryMethodWithParent() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "    return button;", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  Test() {", "    m_factory.createButton(this);", "  }", "}");
        InstanceFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/m_factory.createButton(this)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {instance factory: {field-initializer: m_factory} createButton(java.awt.Container)} {empty} {/m_factory.createButton(this)/}", "  {instance factory container}", "    {new: test.InstanceFactory} {field-initializer: m_factory} {/new InstanceFactory()/ /m_factory.createButton(this)/}");
        panel.refresh();
        InstanceFactoryCreationSupportTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_factoryMethod_interface() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public Comparable createObject() {", "    return null;", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  Test() {", "    m_factory.createObject();", "  }", "}");
        InstanceFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {instance factory container}", "    {new: test.InstanceFactory} {field-initializer: m_factory} {/new InstanceFactory()/ /m_factory.createObject()/}");
        panel.refresh();
        InstanceFactoryCreationSupportTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_add() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  /**", "  * @wbp.factory.parameter.source text '000'", "  */", "  public JButton createButton(String text) {", "    return new JButton(text);", "  }", "  public void setEnabled(boolean enabled) {", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        BorderLayoutInfo borderLayoutInfo = (BorderLayoutInfo)contentPane.getLayout();
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        InstanceFactoryInfo factoryInfo = InstanceFactoryInfo.add((JavaInfo)frame, factoryClass);
        InstanceFactoryCreationSupportTest.assertNotNull((Object)factoryInfo.getAssociation());
        List factories = InstanceFactoryInfo.getFactories((JavaInfo)frame, factoryClass);
        InstanceFactoryCreationSupportTest.assertEquals((long)1L, (long)factories.size());
        InstanceFactoryCreationSupportTest.assertTrue((boolean)factories.contains(factoryInfo));
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, factoryClass, (String)"createButton(java.lang.String)", (boolean)false);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"\"000\"", (Object)description.getParameter(0).getDefaultSource());
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new InstanceFactoryCreationSupport(factoryInfo, description));
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            borderLayoutInfo.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JFrame {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "    {", "      JButton button = instanceFactory.createButton('000');", "      getContentPane().add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        Association association = newComponent.getAssociation();
        InstanceFactoryCreationSupportTest.assertInstanceOf(InvocationChildAssociation.class, (Object)association);
        InstanceFactoryCreationSupportTest.assertEquals((Object)"getContentPane().add(button, BorderLayout.NORTH)", (Object)association.getSource());
        factoryInfo.getPropertyByTitle("enabled").setValue((Object)Boolean.FALSE);
        this.assertEditor("// filler filler filler", "public class Test extends JFrame {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "    instanceFactory.setEnabled(false);", "    {", "      JButton button = instanceFactory.createButton('000');", "      getContentPane().add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_addFactory() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  /**", "  * @wbp.factory.parameter.source text '000'", "  */", "  public JButton createButton(String text) {", "    return new JButton(text);", "  }", "  public void setEnabled(boolean enabled) {", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayoutInfo = (FlowLayoutInfo)panel.getLayout();
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        InstanceFactoryInfo factoryInfo = InstanceFactoryInfo.add((JavaInfo)panel, factoryClass);
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, factoryClass, (String)"createButton(java.lang.String)", (boolean)false);
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new InstanceFactoryCreationSupport(factoryInfo, description));
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            flowLayoutInfo.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "    {", "      JButton button = instanceFactory.createButton('000');", "      add(button);", "    }", "  }", "}");
        factoryInfo.getPropertyByTitle("enabled").setValue((Object)Boolean.FALSE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "    instanceFactory.setEnabled(false);", "    {", "      JButton button = instanceFactory.createButton('000');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_icon_withCustom() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class InstanceFactory {", "}"));
        IFile iconFile = InstanceFactoryCreationSupportTest.getFileSrc("test", "InstanceFactory.png");
        iconFile.create(Activator.getFile("icons/test.png"), true, null);
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        InstanceFactoryInfo factoryInfo = InstanceFactoryInfo.add((JavaInfo)panel, factoryClass);
        ImageDescriptor factoryIcon = factoryInfo.getDescription().getIcon();
        InstanceFactoryCreationSupportTest.assertTrue((boolean)UiUtils.equals((ImageDescriptor)Activator.getImageDescriptor("test.png"), (ImageDescriptor)factoryIcon));
        InstanceFactoryCreationSupportTest.do_projectDispose();
    }

    @Test
    public void test_icon_noCustom() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class InstanceFactory {", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        InstanceFactoryInfo factoryInfo = InstanceFactoryInfo.add((JavaInfo)panel, factoryClass);
        InstanceFactoryCreationSupportTest.assertSame((Object)DEFAULT_FACTORY_ICON, (Object)factoryInfo.getDescription().getIcon());
    }

    @Test
    public void test_nullAssociationProblem() throws Exception {
        InstanceFactoryCreationSupportTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "  }", "}");
        InstanceFactoryInfo factoryInfo = (InstanceFactoryInfo)InstanceFactoryContainerInfo.get((JavaInfo)panel).getChildrenFactory().get(0);
        InstanceFactoryCreationSupportTest.assertNotNull((Object)factoryInfo.getAssociation());
    }
}

