/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class FactoryParentAssociationTest
extends SwingModelTest {
    @Test
    public void test_parse() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyFactory.addButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryParentAssociation association = (FactoryParentAssociation)button.getAssociation();
        FactoryParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(this)", (Object)association.getSource());
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(this)", (Object)this.m_lastEditor.getSource((ASTNode)association.getInvocation()));
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(this);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        FactoryParentAssociationTest.assertInstanceOf(EmptyVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_delete() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    MyFactory.addButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryParentAssociationTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_morph() throws Exception {
        this.configureProject();
        FactoryParentAssociationTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        FactoryParentAssociationTest.setFileContentSrc("test/MyButton.wbp-component.xml", FactoryParentAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        FactoryParentAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyFactory.addButton(this);", "  }", "}");
        ComponentInfo oldButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryParentAssociation oldAssociation = (FactoryParentAssociation)oldButton.getAssociation();
        FactoryParentAssociationTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)oldAssociation.getCopy());
    }

    @Test
    public void test_add() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = this.createNewButton();
        flowLayout.add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = MyFactory.addButton(this);", "    }", "  }", "}");
        FactoryParentAssociation association = (FactoryParentAssociation)button.getAssociation();
        FactoryParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(this)", (Object)association.getSource());
    }

    @Test
    public void test_moveInner() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = MyFactory.addButton(this);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        FlowLayoutInfo panelLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panelLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "    {", "      JButton button = MyFactory.addButton(this);", "    }", "  }", "}");
        FactoryParentAssociation association = (FactoryParentAssociation)button.getAssociation();
        FactoryParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(this)", (Object)association.getSource());
    }

    @Test
    public void test_moveReparent() throws Exception {
        this.configureProject();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = MyFactory.addButton(this);", "      add(button);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo containerLayout = (FlowLayoutInfo)container.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        containerLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "      {", "        JButton button = MyFactory.addButton(container);", "        container.add(button);", "      }", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)button.getAssociation();
        FactoryParentAssociation association = (FactoryParentAssociation)compoundAssociation.getAssociations().get(0);
        FactoryParentAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        FactoryParentAssociationTest.assertEquals((Object)"MyFactory.addButton(container)", (Object)association.getSource());
    }

    private void configureProject() throws Exception {
        FactoryParentAssociationTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton addButton(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "    return button;", "  }", "}"));
        FactoryParentAssociationTest.waitForAutoBuild();
    }

    private ComponentInfo createNewButton() throws Exception, ClassNotFoundException {
        FactoryMethodDescription factoryDescription = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyFactory"), (String)"addButton(java.awt.Container)", (boolean)true);
        return (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (Class)factoryDescription.getReturnClass(), (CreationSupport)new StaticFactoryCreationSupport(factoryDescription));
    }
}

