/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import javax.swing.JFrame;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Before;
import org.junit.Test;

public class DesignerPluginTest
extends DesignerTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void test_getDefault() {
        DesignerPluginTest.assertNotNull((Object)DesignerPlugin.getDefault());
    }

    @Test
    public void test_log_message() {
        String message = "Information message";
        ILog log = DesignerPlugin.getDefault().getLog();
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                DesignerPluginTest.assertEquals((long)1L, (long)status.getSeverity());
                DesignerPluginTest.assertEquals((Object)"org.eclipse.wb.core", (Object)status.getPlugin());
                DesignerPluginTest.assertEquals((long)1L, (long)status.getCode());
                DesignerPluginTest.assertEquals((Object)"Information message", (Object)status.getMessage());
                DesignerPluginTest.assertNull((Object)status.getException());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.log((String)"Information message");
        }
        finally {
            log.removeLogListener(logListener);
        }
    }

    @Test
    public void test_log_Exception() {
        final Exception exception = new Exception();
        ILog log = DesignerPlugin.getDefault().getLog();
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                DesignerPluginTest.assertEquals((long)4L, (long)status.getSeverity());
                DesignerPluginTest.assertEquals((Object)"org.eclipse.wb.core", (Object)status.getPlugin());
                DesignerPluginTest.assertEquals((long)4L, (long)status.getCode());
                DesignerPluginTest.assertSame((Object)exception, (Object)status.getException());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            DesignerPlugin.log((Throwable)exception);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_preventExit_JFrame() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
    }
}

