/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.header;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.core.gef.header.IHeaderMenuProvider;
import org.eclipse.wb.core.gef.header.IHeadersProvider;
import org.eclipse.wb.core.gef.policy.selection.EmptySelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;

public final class HeadersContainerEditPart
extends GraphicalEditPart
implements IHeaderMenuProvider {
    private final GraphicalViewer m_viewer;
    private final boolean m_horizontal;
    private IHeadersProvider m_headersProvider;

    public HeadersContainerEditPart(GraphicalViewer viewer, boolean horizontal) {
        this.m_viewer = viewer;
        this.m_horizontal = horizontal;
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HeadersContainerEditPart.this.refreshHeaders();
            }
        });
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new EmptySelectionEditPolicy());
    }

    @Override
    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "open" && this.m_headersProvider != null) {
            this.m_headersProvider.handleDoubleClick(this.m_horizontal);
        }
    }

    @Override
    protected Figure createFigure() {
        return new Figure();
    }

    @Override
    protected void refreshVisuals() {
        GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
        if (!viewer.getControl().isDisposed()) {
            Point size = viewer.getControl().getSize();
            Dimension mainSize = this.m_viewer.getLayer("Primary Layer").getSize();
            if (this.m_horizontal) {
                this.getFigure().setBounds(new Rectangle(0, 0, mainSize.width, size.y));
            } else {
                this.getFigure().setBounds(new Rectangle(0, 0, size.x, mainSize.height));
            }
        }
    }

    @Override
    public List<?> getModelChildren() {
        if (this.m_headersProvider != null) {
            return this.m_headersProvider.getHeaders(this.m_horizontal);
        }
        return Collections.emptyList();
    }

    protected org.eclipse.gef.EditPart createChild(Object model) {
        return this.m_headersProvider.createHeaderEditPart(this.m_horizontal, model);
    }

    public void refreshHeaders() {
        FigureCanvas viewerControl = ((GraphicalViewer)this.getViewer()).getControl();
        if (!viewerControl.isDisposed()) {
            this.m_headersProvider = this.getHeadersProvider();
            this.doRefreshHeaders();
        }
    }

    private void doRefreshHeaders() {
        this.installEditPolicy("LayoutEditPolicy", null);
        this.refresh();
        for (org.eclipse.gef.EditPart editPart : this.getChildren()) {
            editPart.refresh();
            ((GraphicalEditPart)editPart).getFigure().repaint();
        }
        if (this.m_headersProvider != null) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.m_headersProvider.getContainerLayoutPolicy(this.m_horizontal));
        }
    }

    private IHeadersProvider getHeadersProvider() {
        IHeadersProvider headersProvider;
        List<? extends org.eclipse.gef.EditPart> selectedEditParts = this.m_viewer.getSelectedEditParts();
        if (selectedEditParts.size() != 1) {
            return null;
        }
        org.eclipse.gef.EditPart selectedEditPart = selectedEditParts.get(0);
        if (selectedEditPart == null) {
            return null;
        }
        org.eclipse.gef.EditPart containerEditPart = selectedEditPart.getParent();
        if (containerEditPart != null && (headersProvider = HeadersContainerEditPart.getHeadersProvider(containerEditPart)) != null) {
            return headersProvider;
        }
        IHeadersProvider headersProvider2 = HeadersContainerEditPart.getHeadersProvider(selectedEditPart);
        if (headersProvider2 != null) {
            return headersProvider2;
        }
        return null;
    }

    private static IHeadersProvider getHeadersProvider(org.eclipse.gef.EditPart editPart) {
        for (EditPolicy editPolicy : ((EditPart)editPart).getEditPolicies()) {
            IHeadersProvider headersProvider;
            if (!(editPolicy instanceof IHeadersProvider) || !(headersProvider = (IHeadersProvider)editPolicy).isActive()) continue;
            return headersProvider;
        }
        return null;
    }

    @Override
    public void buildContextMenu(IMenuManager manager) {
        if (this.m_headersProvider != null) {
            this.m_headersProvider.buildContextMenu(manager, this.m_horizontal);
        }
    }
}

