/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GridDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public GridDragSourceEffect(Grid grid) {
        super((Control)grid);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        Point[] selection;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Grid grid = (Grid)this.getControl();
        Display display = grid.getDisplay();
        Rectangle empty = new Rectangle(0, 0, 0, 0);
        if (grid.getCellSelectionEnabled()) {
            selection = grid.getCellSelection();
        } else {
            ArrayList<Point> l = new ArrayList<Point>();
            GridItem[] selItems = grid.getSelection();
            int i = 0;
            while (i < selItems.length) {
                int j = 0;
                while (j < grid.getColumnCount()) {
                    if (grid.getColumn(j).isVisible()) {
                        l.add(new Point(j, selItems[i].getRowIndex()));
                    }
                    ++j;
                }
                ++i;
            }
            selection = l.toArray(new Point[l.size()]);
        }
        if (selection.length == 0) {
            return null;
        }
        Rectangle bounds = null;
        int i = 0;
        while (i < selection.length) {
            GridItem item = grid.getItem(selection[i].y);
            Rectangle currBounds = item.getBounds(selection[i].x);
            if (empty.equals((Object)currBounds)) {
                selection[i] = null;
            } else {
                bounds = bounds == null ? currBounds : bounds.union(currBounds);
            }
            ++i;
        }
        if (bounds == null) {
            return null;
        }
        if (bounds.width <= 0 || bounds.height <= 0) {
            return null;
        }
        this.dragSourceImage = new Image((Device)display, bounds.width, bounds.height);
        GC gc = new GC((Drawable)this.dragSourceImage);
        int i2 = 0;
        while (i2 < selection.length) {
            if (selection[i2] != null) {
                GridItem item = grid.getItem(selection[i2].y);
                GridColumn column = grid.getColumn(selection[i2].x);
                Rectangle currBounds = item.getBounds(selection[i2].x);
                GridCellRenderer r = column.getCellRenderer();
                r.setBounds(currBounds.x - bounds.x, currBounds.y - bounds.y, currBounds.width, currBounds.height);
                gc.setClipping(currBounds.x - bounds.x - 1, currBounds.y - bounds.y - 1, currBounds.width + 2, currBounds.height + 2);
                r.setColumn(selection[i2].x);
                r.setSelected(false);
                r.setFocus(false);
                r.setRowFocus(false);
                r.setCellFocus(false);
                r.setRowHover(false);
                r.setColumnHover(false);
                r.setCellSelected(false);
                r.setHoverDetail("");
                r.setDragging(true);
                r.paint(gc, (Object)item);
                gc.setClipping(null);
            }
            ++i2;
        }
        gc.dispose();
        return this.dragSourceImage;
    }
}

