/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.gef.tree.TreeViewer;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.eclipse.wb.tests.gef.EventSender;
import org.junit.Assert;

public final class TreeRobot {
    private final TreeViewer m_viewer;
    private final EventSender m_sender;
    private boolean m_dragInProgress;
    private TreeEditPart[] m_justSelectedEditParts;

    public TreeRobot(TreeViewer treeViewer) {
        this.m_viewer = treeViewer;
        this.m_sender = new EventSender(treeViewer.getControl());
    }

    public void cancel() {
        this.m_viewer.getEditDomain().loadDefaultTool();
    }

    public TreeRobot collapseAll() {
        this.m_viewer.collapseAll();
        this.waitEventLoop();
        return this;
    }

    public TreeRobot expandAll() {
        this.m_viewer.expandAll();
        this.waitEventLoop();
        return this;
    }

    public void click() {
        this.m_sender.click();
    }

    public void click(Object object, int deltaX, int deltaY) {
        Point location = TreeRobot.getLocation(this.getEditPart(object), deltaX, deltaY);
        this.m_sender.click(location.x, location.y, 1);
    }

    public TreeRobot startDrag(Object ... models) {
        this.expandAll();
        Assertions.assertThat((Object[])models).isNotEmpty();
        this.select(models);
        TreeEditPart selectedEditPart = this.m_justSelectedEditParts[0];
        Point location = TreeRobot.getLocation(selectedEditPart, 0, 0);
        Event event = this.createDNDEvent(selectedEditPart, location);
        this.notifyDropTarget(2002, event);
        this.m_dragInProgress = true;
        return this;
    }

    public TreeRobot dragOn(Object model) {
        TreeEditPart target = this.getEditPart(model);
        Point location = this.getLocationOn(target);
        Event event = this.createDNDEvent(target, location);
        this.notifyDropTarget(2004, event);
        return this;
    }

    public TreeRobot dragBefore(Object model) {
        TreeEditPart target = this.getEditPart(model);
        Point location = this.getLocationBefore(target);
        Event event = this.createDNDEvent(target, location);
        this.notifyDropTarget(2004, event);
        return this;
    }

    public TreeRobot dragAfter(Object model) {
        TreeEditPart target = this.getEditPart(model);
        Point location = this.getLocationAfter(target);
        Event event = this.createDNDEvent(target, location);
        this.notifyDropTarget(2004, event);
        return this;
    }

    public TreeRobot endDrag() {
        Event event = TreeRobot.createDNDEvent();
        this.notifyDropTarget(2006, event);
        this.m_dragInProgress = false;
        return this;
    }

    private Command getDragCommand() {
        return (Command)ExecutionUtils.runObjectLog(() -> {
            Object eventManager = ReflectionUtils.getFieldObject((Object)this.m_viewer, (String)"m_eventManager");
            Object dropListener = ReflectionUtils.getFieldObject((Object)eventManager, (String)"m_dropListener");
            return (Command)ReflectionUtils.getFieldObject((Object)dropListener, (String)"m_command");
        }, null);
    }

    private Event createDNDEvent(TreeEditPart dragPart, Point locationInTree) {
        Tree tree = dragPart.getWidget().getParent();
        Event event = TreeRobot.createDNDEvent();
        event.widget = tree;
        event.item = dragPart.getWidget();
        org.eclipse.swt.graphics.Point absoluteLocation = Display.getCurrent().map((Control)tree, null, locationInTree.getSWTPoint());
        event.x = absoluteLocation.x;
        event.y = absoluteLocation.y;
        return event;
    }

    private static Event createDNDEvent() {
        return (Event)ExecutionUtils.runObject(() -> {
            Class dndClass = ReflectionUtils.getClassByName((ClassLoader)TreeRobot.class.getClassLoader(), (String)"org.eclipse.swt.dnd.DNDEvent");
            return (Event)ReflectionUtils.newInstance((Class)dndClass, (String)"<init>()", (Object[])new Object[0]);
        });
    }

    private void notifyDropTarget(int eventType, Event event) {
        DropTarget dropTarget = (DropTarget)this.m_viewer.getTree().getData("DropTarget");
        dropTarget.notifyListeners(eventType, event);
    }

    public TreeRobot select(Object ... models) {
        Object[] editParts = this.getEditParts(models);
        this.m_justSelectedEditParts = editParts;
        this.m_viewer.setSelection((ISelection)new StructuredSelection(editParts));
        DesignerTestCase.waitEventLoop(100, 0L);
        return this;
    }

    public TreeRobot moveTo(int x, int y) {
        this.m_sender.moveTo(x, y);
        return this;
    }

    public TreeRobot moveOn(Object model) {
        TreeEditPart editPart = this.getEditPart(model);
        this.setExpanded(editPart, true);
        Point location = this.getLocationOn(editPart);
        this.moveTo(location.x, location.y);
        return this;
    }

    public TreeRobot moveBefore(Object model) {
        TreeEditPart editPart = this.getEditPart(model);
        this.setExpanded(editPart, true);
        Point location = this.getLocationBefore(editPart);
        this.moveTo(location.x, location.y);
        return this;
    }

    public TreeRobot moveAfter(Object model) {
        TreeEditPart editPart = this.getEditPart(model);
        this.setExpanded(editPart, true);
        Point location = this.getLocationAfter(editPart);
        this.moveTo(location.x, location.y);
        return this;
    }

    public TreeEditPart getEditPart(Object model) {
        TreeEditPart editPart = this.getEditPartNull(model);
        Assert.assertNotNull((Object)editPart);
        return editPart;
    }

    public TreeEditPart getEditPartNull(Object object) {
        TreeEditPart editPart = object instanceof TreeEditPart ? (TreeEditPart)object : (TreeEditPart)this.m_viewer.getEditPartRegistry().get(object);
        return editPart;
    }

    public TreeEditPart[] getEditParts(Object[] models) {
        TreeEditPart[] editParts = new TreeEditPart[models.length];
        int i = 0;
        while (i < models.length) {
            Object model = models[i];
            editParts[i] = this.getEditPart(model);
            ++i;
        }
        return editParts;
    }

    public void setExpanded(TreeEditPart editPart, boolean expanded) {
        TreeEditPart parentEditPart = (TreeEditPart)editPart.getParent();
        if (parentEditPart != null) {
            TreeItem widget = parentEditPart.getWidget();
            if (expanded) {
                this.setExpanded(parentEditPart, expanded);
                if (widget != null) {
                    widget.setExpanded(expanded);
                }
            } else {
                if (widget != null) {
                    widget.setExpanded(expanded);
                }
                this.setExpanded(parentEditPart, expanded);
            }
        }
        this.waitEventLoop();
    }

    public void setExpanded(Object model, boolean expanded) {
        this.setExpanded(this.getEditPart(model), expanded);
    }

    public Command getCommand() throws Exception {
        Tool dragTracker;
        Tool tool = this.m_viewer.getEditDomain().getActiveTool();
        if (this.m_dragInProgress) {
            return this.getDragCommand();
        }
        if (tool instanceof SelectionTool && (dragTracker = (Tool)ReflectionUtils.getFieldObject((Object)tool, (String)"m_dragTracker")) != null) {
            tool = dragTracker;
        }
        return (Command)ReflectionUtils.getFieldObject((Object)tool, (String)"m_command");
    }

    private void waitEventLoop() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public Point getLocationOn(Object object) {
        Rectangle bounds = TreeRobot.getBounds(this.getEditPart(object));
        int x = bounds.x + 0;
        int y = bounds.y + bounds.height / 2;
        Point location = new Point(x, y);
        return location;
    }

    public Point getLocationBefore(Object object) {
        Rectangle bounds = TreeRobot.getBounds(this.getEditPart(object));
        int x = bounds.x + 0;
        int y = bounds.y + 4;
        Point location = new Point(x, y);
        return location;
    }

    public Point getLocationAfter(Object object) {
        Rectangle bounds = TreeRobot.getBounds(this.getEditPart(object));
        int x = bounds.x + 0;
        int y = bounds.bottom() - 4;
        Point location = new Point(x, y);
        return location;
    }

    public static Rectangle getBounds(TreeEditPart editPart) {
        TreeItem widget = editPart.getWidget();
        return new Rectangle(widget.getBounds());
    }

    public static Point getLocation(TreeEditPart editPart, int deltaX, int deltaY) {
        Rectangle bounds = TreeRobot.getBounds(editPart);
        Point location = new Point(0, 0);
        location.x = deltaX >= 0 ? bounds.x + deltaX : bounds.right() + deltaX;
        location.y = deltaY >= 0 ? bounds.y + deltaY : bounds.bottom() + deltaY;
        return location;
    }

    public TreeRobot assertSelectedEmpty() {
        List selectedEditParts = this.m_viewer.getSelectedEditParts();
        Assertions.assertThat((List)selectedEditParts).isEmpty();
        return this;
    }

    public TreeRobot assertPrimarySelected(Object object) {
        TreeEditPart editPart = this.getEditPart(object);
        Assert.assertEquals((long)editPart.getSelected(), (long)2L);
        return this;
    }

    public void assertNotExpandedObjects(ObjectInfo ... objects) {
        Object[] expanded = this.getExpandedElements();
        Assertions.assertThat((Object[])expanded).doesNotContain((Object[])objects);
    }

    public void assertExpandedObjects(ObjectInfo ... objects) {
        Object[] expanded = this.getExpandedElements();
        Assertions.assertThat((Object[])expanded).containsOnly((Object[])objects);
    }

    private Object[] getExpandedElements() {
        TreeItem[] expandedItems = UiUtils.getExpanded((Tree)this.m_viewer.getTree());
        Object[] models = new Object[expandedItems.length];
        int i = 0;
        while (i < expandedItems.length) {
            TreeItem treeItem = expandedItems[i];
            EditPart editPart = (EditPart)treeItem.getData();
            models[i] = editPart.getModel();
            ++i;
        }
        return models;
    }

    public TreeRobot assertFeedback_empty() {
        List<TreeItem> selectedItems = this.getFeedbackSelection();
        Assertions.assertThat(selectedItems).isEmpty();
        Tree tree = (Tree)this.m_viewer.getControl();
        Object item = tree.getData("_wbp_insertMarkItem");
        Assert.assertNull((Object)item);
        return this;
    }

    public TreeRobot assertFeedback_on(Object object) {
        TreeEditPart editPart = this.getEditPart(object);
        List<TreeItem> selectedItems = this.getFeedbackSelection();
        Assertions.assertThat(selectedItems).containsOnly((Object[])new TreeItem[]{editPart.getWidget()});
        return this;
    }

    public TreeRobot assertFeedback_notOn(Object object) {
        TreeEditPart editPart = this.getEditPart(object);
        List<TreeItem> selectedItems = this.getFeedbackSelection();
        Assertions.assertThat(selectedItems).doesNotContain((Object[])new TreeItem[]{editPart.getWidget()});
        return this;
    }

    private List<TreeItem> getFeedbackSelection() {
        Tree tree = (Tree)this.m_viewer.getControl();
        ArrayList<TreeItem> selectedItems = new ArrayList<TreeItem>();
        Collections.addAll(selectedItems, tree.getSelection());
        for (EditPart selectedEditPart : this.m_viewer.getSelectedEditParts()) {
            selectedItems.remove(((TreeEditPart)selectedEditPart).getWidget());
        }
        return selectedItems;
    }

    public TreeRobot assertFeedback_before(Object object) {
        this.assertFeedback_insert(object, true);
        return this;
    }

    public TreeRobot assertFeedback_after(Object object) {
        this.assertFeedback_insert(object, false);
        return this;
    }

    private void assertFeedback_insert(Object object, boolean before) {
        Tree tree = (Tree)this.m_viewer.getControl();
        TreeEditPart editPart = this.getEditPart(object);
        Object item = tree.getData("_wbp_insertMarkItem");
        Assert.assertSame((Object)item, (Object)editPart.getWidget());
        Boolean location = (Boolean)tree.getData("_wbp_insertMarkLocation");
        Assert.assertEquals((Object)location, (Object)before);
    }

    public void assertNullEditPart(Object object) {
        Assert.assertNull((Object)this.getEditPartNull(object));
    }

    public void assertNotNullEditPart(Object object) {
        Assert.assertNotNull((Object)this.getEditPartNull(object));
    }

    public TreeRobot assertCommandNull() throws Exception {
        final Command command = this.getCommand();
        ((ObjectAssert)Assertions.assertThat((Object)command).describedAs(new Description(){

            public String value() {
                return "Unexpected command " + String.valueOf(command);
            }
        })).isNull();
        return this;
    }

    public TreeRobot assertCommandNotNull() throws Exception {
        Command command = this.getCommand();
        Assert.assertNotNull((String)"No command.", (Object)command);
        return this;
    }
}

