/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.eclipse.wb.tests.gef.TreeToolTest;
import org.junit.Before;
import org.junit.Test;

public class TreeCreateToolTest
extends TreeToolTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ICreationFactory factory = new ICreationFactory(){

            public void activate() {
            }

            public Object getNewObject() {
                return "_NewObject_";
            }

            public String toString() {
                return "TestFactory";
            }
        };
        this.m_domain.setActiveTool((Tool)new CreationTool(factory));
    }

    @Test
    public void test_Move_1() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, ipolicy);
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, ipolicy);
        TreeEditPart parent1 = this.addEditPart((EditPart)parent, "parent1", actualLogger, ipolicy);
        TreeEditPart parent2 = this.addEditPart((EditPart)parent, "parent2", actualLogger, ipolicy);
        TreeCreateToolTest.refreshTreeParst(parent);
        UiUtils.expandAll((Tree)this.m_viewer.getTree());
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(470, 370);
        actualLogger.assertEmpty();
        Point dropLocation = TreeCreateToolTest.getBeforeLocation(parent);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        actualLogger.assertEmpty();
        dropLocation = TreeCreateToolTest.getOnLocation(parent);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=null)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(parent);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        actualLogger.assertEmpty();
        dropLocation = TreeCreateToolTest.getBeforeLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=child1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getOnLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)child1, "getCreateCommand(object=_NewObject_, next=null)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=parent1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getBeforeLocation(parent1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=parent1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getOnLocation(parent1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent1, "getCreateCommand(object=_NewObject_, next=null)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(parent1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=parent2)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(parent2);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=null)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Move_2() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, ipolicy);
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, null);
        this.addEditPart((EditPart)parent, "parent1", actualLogger, ipolicy);
        TreeCreateToolTest.refreshTreeParst(parent);
        UiUtils.expandAll((Tree)this.m_viewer.getTree());
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(470, 370);
        actualLogger.assertEmpty();
        Point dropLocation = TreeCreateToolTest.getBeforeLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=child1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getOnLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=parent1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)parent, "getCreateCommand(object=_NewObject_, next=parent1)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Move_3() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, (request, editPart) -> !"child1".equals(editPart.getModel()));
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, ipolicy);
        this.addEditPart((EditPart)parent, "parent1", actualLogger, ipolicy);
        TreeCreateToolTest.refreshTreeParst(parent);
        UiUtils.expandAll((Tree)this.m_viewer.getTree());
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(470, 370);
        actualLogger.assertEmpty();
        Point dropLocation = TreeCreateToolTest.getBeforeLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        actualLogger.assertEmpty();
        dropLocation = TreeCreateToolTest.getOnLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        expectedLogger.log((EditPart)child1, "getCreateCommand(object=_NewObject_, next=null)");
        TreeCreateToolTest.assertLoggers(expectedLogger, actualLogger);
        dropLocation = TreeCreateToolTest.getAfterLocation(child1);
        this.m_sender.moveTo(dropLocation.x, dropLocation.y);
        actualLogger.assertEmpty();
    }
}

