/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.rcp.model.widgets.ScrolledCompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ScrolledCompositeTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noContent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        ScrolledCompositeTest.assertNull((Object)composite.getContent());
        ScrolledCompositeTest.assertTrue((boolean)composite.hasRequired_setContent());
    }

    @Test
    public void test_withContent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(composite, SWT.NONE);", "    }", "    composite.setContent(button);", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        ScrolledCompositeTest.assertSame((Object)button, (Object)composite.getContent());
        ScrolledCompositeTest.assertTrue((boolean)composite.hasRequired_setContent());
    }

    @Test
    public void test_hasChildControl_withContent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(composite, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        Assertions.assertThat((List)composite.getChildrenControls()).hasSize(1);
        ScrolledCompositeTest.assertNull((Object)composite.getContent());
        ScrolledCompositeTest.assertFalse((boolean)composite.hasRequired_setContent());
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        composite.command_CREATE(button);
        this.assertEditor("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(composite, SWT.NONE);", "    }", "    composite.setContent(button);", "    composite.setMinSize(button.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "  }", "}");
    }

    @Test
    public void test_CREATE2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Group group;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      group = new Group(composite, SWT.NONE);", "      group.setLayout(new RowLayout());", "    }", "    composite.setContent(group);", "    composite.setMinSize(group.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        CompositeInfo group = (CompositeInfo)composite.getContent();
        ControlInfo button = BTestUtils.createButton();
        group.getLayout().command_CREATE(button, null);
        this.assertEditor("public class Test extends Shell {", "  private Group group;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      group = new Group(composite, SWT.NONE);", "      group.setLayout(new RowLayout());", "      {", "        Button button = new Button(group, SWT.NONE);", "      }", "    }", "    composite.setContent(group);", "    composite.setMinSize(group.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        composite.command_ADD(button);
        this.assertEditor("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(composite, SWT.NONE);", "    }", "    composite.setContent(button);", "    composite.setMinSize(button.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "  }", "}");
    }

    @Test
    public void test_MOVE_out() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(composite, SWT.NONE);", "    }", "    composite.setContent(button);", "    composite.setMinSize(button.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "  }", "}");
        shell.refresh();
        ScrolledCompositeInfo composite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = composite.getContent();
        shell.getLayout().command_MOVE(button, null);
        this.assertEditor("public class Test extends Shell {", "  private Button button;", "  public Test() {", "    setLayout(new FillLayout());", "    ScrolledComposite composite = new ScrolledComposite(this, SWT.NONE);", "    {", "      button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }
}

