/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.beans;

import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanPropertyDescriptorBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.CollectionPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.FieldBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.MethodBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectPropertyObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.SetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.eclipse.wb.tests.designer.databinding.rcp.model.beans.BeanBindableTest;
import org.junit.Test;

public class BeanObservableTest
extends AbstractBindingTest {
    @Test
    public void test_direct() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import java.util.ArrayList;", "public class Test {", "  protected Shell m_shell;", "  private IObservableValue m_value;", "  private IObservableList m_list;", "  private IObservableSet m_set;", "  private IObservableMap m_map;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanObservableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanObservableTest.assertNotNull((Object)observes);
        BeanObservableTest.assertEquals((long)6L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_value - IObservableValue|m_value|org.eclipse.core.databinding.observable.value.IObservableValue", observes.get(1));
        List valueChildren = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanObservableTest.assertEquals((long)1L, (long)valueChildren.size());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, observes.get(1), true, "m_value.getRealm()|m_value.getRealm()|org.eclipse.core.databinding.observable.Realm", valueChildren.get(0));
        List valueProperties = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanObservableTest.assertEquals((long)7L, (long)valueProperties.size());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Object as IObservableValue||org.eclipse.core.databinding.observable.value.IObservableValue", valueProperties.get(0));
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Detail for IObservableValue||org.eclipse.core.databinding.observable.value.IObservableValue", valueProperties.get(1));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "disposed|\"disposed\"|boolean", valueProperties.get(2));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "realm|\"realm\"|org.eclipse.core.databinding.observable.Realm", valueProperties.get(3));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "stale|\"stale\"|boolean", valueProperties.get(4));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "value|\"value\"|java.lang.Object", valueProperties.get(5));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "valueType|\"valueType\"|java.lang.Object", valueProperties.get(6));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_list - IObservableList|m_list|org.eclipse.core.databinding.observable.list.IObservableList", observes.get(2));
        List listChildren = ((IObserveInfo)observes.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanObservableTest.assertEquals((long)1L, (long)listChildren.size());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, observes.get(2), true, "m_list.getRealm()|m_list.getRealm()|org.eclipse.core.databinding.observable.Realm", listChildren.get(0));
        List listProperties = ((IObserveInfo)observes.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        if (Runtime.version().feature() >= 21) {
            BeanObservableTest.assertEquals((long)8L, (long)listProperties.size());
        } else {
            BeanObservableTest.assertEquals((long)6L, (long)listProperties.size());
        }
        int index = 0;
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Object as IObservableList||org.eclipse.core.databinding.observable.list.IObservableList", listProperties.get(index++));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "disposed|\"disposed\"|boolean", listProperties.get(index++));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "elementType|\"elementType\"|java.lang.Object", listProperties.get(index++));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "empty|\"empty\"|boolean", listProperties.get(index++));
        if (Runtime.version().feature() >= 21) {
            BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "first|\"first\"|java.lang.Object", listProperties.get(index++));
            BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "last|\"last\"|java.lang.Object", listProperties.get(index++));
        }
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "realm|\"realm\"|org.eclipse.core.databinding.observable.Realm", listProperties.get(index++));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "stale|\"stale\"|boolean", listProperties.get(index++));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_set - IObservableSet|m_set|org.eclipse.core.databinding.observable.set.IObservableSet", observes.get(3));
        List setChildren = ((IObserveInfo)observes.get(3)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanObservableTest.assertEquals((long)1L, (long)setChildren.size());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, observes.get(3), true, "m_set.getRealm()|m_set.getRealm()|org.eclipse.core.databinding.observable.Realm", setChildren.get(0));
        List setProperties = ((IObserveInfo)observes.get(3)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanObservableTest.assertEquals((long)6L, (long)setProperties.size());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Object as IObservableSet||org.eclipse.core.databinding.observable.set.IObservableSet", setProperties.get(0));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "disposed|\"disposed\"|boolean", setProperties.get(1));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "elementType|\"elementType\"|java.lang.Object", setProperties.get(2));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "empty|\"empty\"|boolean", setProperties.get(3));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "realm|\"realm\"|org.eclipse.core.databinding.observable.Realm", setProperties.get(4));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "stale|\"stale\"|boolean", setProperties.get(5));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, false, "m_map - IObservableMap|m_map|org.eclipse.core.databinding.observable.map.IObservableMap", observes.get(4));
        List mapChildren = ((IObserveInfo)observes.get(4)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanObservableTest.assertEquals((long)0L, (long)mapChildren.size());
        List mapProperties = ((IObserveInfo)observes.get(4)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanObservableTest.assertEquals((long)0L, (long)mapProperties.size());
    }

    @Test
    public void test_directObservable_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private WritableValue m_value;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanObservableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanObservableTest.assertNotNull((Object)observes);
        BeanObservableTest.assertEquals((long)3L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_shell - Shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_value - WritableValue|m_value|org.eclipse.core.databinding.observable.value.WritableValue", observes.get(1));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getClass()|getClass()|java.lang.Class", observes.get(2));
        List properties = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanObservableTest.assertEquals((long)8L, (long)properties.size());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Object as IObservableValue||org.eclipse.core.databinding.observable.value.WritableValue", properties.get(0));
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Detail for IObservableValue||org.eclipse.core.databinding.observable.value.WritableValue", properties.get(1));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "class|\"class\"|java.lang.Class", properties.get(2));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "disposed|\"disposed\"|boolean", properties.get(3));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "realm|\"realm\"|org.eclipse.core.databinding.observable.Realm", properties.get(4));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "stale|\"stale\"|boolean", properties.get(5));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "value|\"value\"|java.lang.Object", properties.get(6));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "valueType|\"valueType\"|java.lang.Object", properties.get(7));
    }

    @Test
    public void test_directObservable_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private WritableValue m_value;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    bindingContext.bindValue(observeWidget, m_value, null, null);", "    return bindingContext;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DirectObservableInfo.class, (Object)binding.getModelObservable());
        BeanObservableTest.assertEquals((Object)"m_value", (Object)binding.getModelObservable().getVariableIdentifier());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_value - WritableValue|m_value|org.eclipse.core.databinding.observable.value.WritableValue", binding.getModelObservable().getBindableObject());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Object as IObservableValue||org.eclipse.core.databinding.observable.value.WritableValue", binding.getModelObservable().getBindableProperty());
    }

    @Test
    public void test_directObservable_detail() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private WritableValue m_value;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    IObservableValue observeDetail = BeanProperties.value(\"name\", String.class).observeDetail(m_value);", "    bindingContext.bindValue(observeWidget, observeDetail, null, null);", "    return bindingContext;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DetailValueBeanObservableInfo.class, (Object)binding.getModelObservable());
        DetailValueBeanObservableInfo modelObservable = (DetailValueBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertNotNull((Object)modelObservable.getMasterObservable());
        BeanObservableTest.assertInstanceOf(DirectObservableInfo.class, (Object)modelObservable.getMasterObservable());
        BeanObservableTest.assertSame((Object)modelObservable.getMasterObservable().getBindableObject(), (Object)modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_value - WritableValue|m_value|org.eclipse.core.databinding.observable.value.WritableValue", modelObservable.getBindableObject());
        BeanObservableTest.assertSame((Object)modelObservable.getMasterObservable().getBindableProperty(), (Object)modelObservable.getBindableProperty());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "Detail for IObservableValue||org.eclipse.core.databinding.observable.value.WritableValue", modelObservable.getBindableProperty());
        BeanObservableTest.assertEquals((Object)"\"name\"", (Object)modelObservable.getDetailPropertyReference());
        BeanObservableTest.assertNotNull((Object)modelObservable.getDetailPropertyType());
        BeanObservableTest.assertEquals((Object)"java.lang.String", (Object)modelObservable.getDetailPropertyType().getName());
    }

    @Test
    public void test_directObservableProperties_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Binding m_binding;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanObservableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanObservableTest.assertNotNull((Object)observes);
        BeanObservableTest.assertEquals((long)3L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_shell - Shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_binding - Binding|m_binding|org.eclipse.core.databinding.Binding", observes.get(1));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getClass()|getClass()|java.lang.Class", observes.get(2));
        List properties = CoreUtils.cast((List)((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
        BeanObservableTest.assertEquals((long)7L, (long)properties.size());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "class|\"class\"|java.lang.Class", properties.get(0));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "disposed|\"disposed\"|boolean", properties.get(1));
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getModel()|getModel()|org.eclipse.core.databinding.observable.IObservable", properties.get(2));
        BeanObservableTest.assertNull((Object)((BindableInfo)properties.get(2)).getObservableFactory());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getModels()|getModels()|org.eclipse.core.databinding.observable.list.IObservableList", properties.get(3));
        BeanObservableTest.assertNotNull((Object)((BindableInfo)properties.get(3)).getObservableFactory());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getTarget()|getTarget()|org.eclipse.core.databinding.observable.IObservable", properties.get(4));
        BeanObservableTest.assertNull((Object)((BindableInfo)properties.get(4)).getObservableFactory());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getTargets()|getTargets()|org.eclipse.core.databinding.observable.list.IObservableList", properties.get(5));
        BeanObservableTest.assertNotNull((Object)((BindableInfo)properties.get(5)).getObservableFactory());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getValidationStatus()|getValidationStatus()|org.eclipse.core.databinding.observable.value.IObservableValue", properties.get(6));
        BeanObservableTest.assertNotNull((Object)((BindableInfo)properties.get(6)).getObservableFactory());
    }

    @Test
    public void test_directObservableProperties_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private Binding m_binding0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    bindingContext.bindValue(observeWidget, m_binding0.getValidationStatus(), null, null);", "    return bindingContext;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DirectPropertyObservableInfo.class, (Object)binding.getModelObservable());
        BeanObservableTest.assertEquals((Object)"m_binding0.getValidationStatus()", (Object)binding.getModelObservable().getVariableIdentifier());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_binding0 - Binding|m_binding0|org.eclipse.core.databinding.Binding", binding.getModelObservable().getBindableObject());
        BeanBindableTest.assertBindable(DirectPropertyBindableInfo.class, null, false, "getValidationStatus()|getValidationStatus()|org.eclipse.core.databinding.observable.value.IObservableValue", binding.getModelObservable().getBindableProperty());
    }

    @Test
    public void test_observeValue_1() throws Exception {
        this.observeValue("    IObservableValue observeValue0 = BeanProperties.value(\"name\").observe(m_bean0);", "    IObservableValue observeValue1 = BeanProperties.value(\"value\").observe(getBean1());");
    }

    @Test
    public void test_observeValue_2() throws Exception {
        this.observeValue("    IObservableValue observeValue0 = BeanProperties.value(\"name\").observe(Realm.getDefault(), m_bean0);", "    IObservableValue observeValue1 = BeanProperties.value(\"value\").observe(Realm.getDefault(), getBean1());");
    }

    private void observeValue(String line0, String line1) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public String getName() {", "    return null;", "  }", "  public int getValue() {", "    return 0;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", line0, line1, "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeValue0, observeValue1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)binding.getTargetObservable());
        ValueBeanObservableInfo targetObservable = (ValueBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertEquals((Object)"observeValue0", (Object)targetObservable.getVariableIdentifier());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "name|\"name\"|java.lang.String", targetObservable.getBindableProperty());
        BeanObservableTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)binding.getModelObservable());
        ValueBeanObservableInfo modelObservable = (ValueBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertEquals((Object)"observeValue1", (Object)modelObservable.getVariableIdentifier());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, null, true, "getBean1()|getBean1()|test.TestBean", modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "value|\"value\"|int", modelObservable.getBindableProperty());
    }

    @Test
    public void test_observeList_1() throws Exception {
        this.observeList("    IObservableList observeList0 = BeanProperties.list(\"names\").observe(Realm.getDefault(), m_bean0);", "    IObservableList observeList1 = BeanProperties.list(\"names\").observe(Realm.getDefault(), getBean1());");
    }

    @Test
    public void test_observeList_2() throws Exception {
        this.observeList("    IObservableList observeList0 = BeanProperties.list(\"names\", java.lang.String.class).observe(Realm.getDefault(),m_bean0);", "    IObservableList observeList1 = BeanProperties.list(\"names\", String.class).observe(Realm.getDefault(), getBean1());");
    }

    private void observeList(String line0, String line1) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", line0, line1, "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeList0, observeList1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(ListBeanObservableInfo.class, (Object)binding.getTargetObservable());
        ListBeanObservableInfo targetObservable = (ListBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertEquals((Object)"observeList0", (Object)targetObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"m_bean0.names(List)", (Object)targetObservable.getPresentationText());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.List", targetObservable.getBindableProperty());
        BeanObservableTest.assertInstanceOf(ListBeanObservableInfo.class, (Object)binding.getModelObservable());
        ListBeanObservableInfo modelObservable = (ListBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertEquals((Object)"observeList1", (Object)modelObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"getBean1().names(List)", (Object)modelObservable.getPresentationText());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, null, true, "getBean1()|getBean1()|test.TestBean", modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.List", modelObservable.getBindableProperty());
    }

    @Test
    public void test_observeSet_1() throws Exception {
        this.observeSet("    IObservableSet observeSet0 = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean0);", "    IObservableSet observeSet1 = BeanProperties.set(\"names\").observe(Realm.getDefault(), getBean1());");
    }

    @Test
    public void test_observeSet_2() throws Exception {
        this.observeSet("    IObservableSet observeSet0 = BeanProperties.set(\"names\", java.lang.String.class).observe(Realm.getDefault(), m_bean0);", "    IObservableSet observeSet1 = BeanProperties.set(\"names\", String.class).observe(Realm.getDefault(), getBean1());");
    }

    private void observeSet(String line0, String line1) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", line0, line1, "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeSet0, observeSet1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding.getTargetObservable());
        SetBeanObservableInfo targetObservable = (SetBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertEquals((Object)"observeSet0", (Object)targetObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"m_bean0.names(Set)", (Object)targetObservable.getPresentationText());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.Set", targetObservable.getBindableProperty());
        BeanObservableTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding.getModelObservable());
        SetBeanObservableInfo modelObservable = (SetBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertEquals((Object)"observeSet1", (Object)modelObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"getBean1().names(Set)", (Object)modelObservable.getPresentationText());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, null, true, "getBean1()|getBean1()|test.TestBean", modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.Set", modelObservable.getBindableProperty());
    }

    @Test
    public void test_observeDetailValue_1() throws Exception {
        this.observeDetailValue("    IObservableValue observeDetailsValue = BeanProperties.value(\"empty\", boolean.class).observeDetail(observeValue0);");
    }

    @Test
    public void test_observeDetailValue_2() throws Exception {
        this.observeDetailValue("    IObservableValue observeDetailsValue = BeanProperties.value(String.class, \"empty\", boolean.class).observeDetail(observeValue0);");
    }

    private void observeDetailValue(String line) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public String getName() {", "    return null;", "  }", "  public int getValue() {", "    return 0;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue0 = BeanProperties.value(\"name\").observe(m_bean0);", line, "    IObservableValue observeValue1 = BeanProperties.value(\"value\").observe(getBean1());", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeDetailsValue, observeValue1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DetailValueBeanObservableInfo.class, (Object)binding.getTargetObservable());
        DetailValueBeanObservableInfo targetObservable = (DetailValueBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertNotNull((Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableObject(), (Object)targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableProperty(), (Object)targetObservable.getBindableProperty());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "name|\"name\"|java.lang.String", targetObservable.getBindableProperty());
        BeanObservableTest.assertEquals((Object)"\"empty\"", (Object)targetObservable.getDetailPropertyReference());
        BeanObservableTest.assertNotNull((Object)targetObservable.getDetailPropertyType());
        BeanObservableTest.assertEquals((Object)"boolean", (Object)targetObservable.getDetailPropertyType().getName());
        BeanObservableTest.assertEquals((Object)"m_bean0.name.detailValue(\"empty\", boolean.class)", (Object)targetObservable.getPresentationText());
    }

    @Test
    public void test_observeDetailList() throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public String getName() {", "    return null;", "  }", "  public java.util.List getValues() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue0 = BeanProperties.value(\"name\").observe(m_bean0);", "    IObservableList observeDetailsList = BeanProperties.list(\"empty\", boolean.class).observeDetail(observeValue0);", "    IObservableList observeList1 = BeanProperties.list(\"values\").observe(getBean1());", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeDetailsList, observeList1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DetailListBeanObservableInfo.class, (Object)binding.getTargetObservable());
        DetailBeanObservableInfo targetObservable = (DetailBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertNotNull((Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableObject(), (Object)targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableProperty(), (Object)targetObservable.getBindableProperty());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "name|\"name\"|java.lang.String", targetObservable.getBindableProperty());
        BeanObservableTest.assertEquals((Object)"\"empty\"", (Object)targetObservable.getDetailPropertyReference());
        BeanObservableTest.assertNotNull((Object)targetObservable.getDetailPropertyType());
        BeanObservableTest.assertEquals((Object)"boolean", (Object)targetObservable.getDetailPropertyType().getName());
        BeanObservableTest.assertEquals((Object)"m_bean0.name.detailList(\"empty\", boolean.class)", (Object)targetObservable.getPresentationText());
        targetObservable.setDetailPropertyReference(Object.class, "\"foo\"");
        targetObservable.setDetailPropertyType(String.class);
        BeanObservableTest.assertEquals((Object)"m_bean0.name.detailList(\"foo\", String.class)", (Object)targetObservable.getPresentationText());
        targetObservable.setDetailPropertyReference(Object.class, null);
        targetObservable.setDetailPropertyType(null);
        BeanObservableTest.assertEquals((Object)"m_bean0.name.detailList(?????, ?????.class)", (Object)targetObservable.getPresentationText());
    }

    @Test
    public void test_observeDetailSet() throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public String getName() {", "    return null;", "  }", "  public java.util.Set getValues() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue0 = BeanProperties.value(\"name\").observe(m_bean0);", "    IObservableSet observeDetailsSet = BeanProperties.set(\"empty\", boolean.class).observeDetail(observeValue0);", "    IObservableSet observeSet1 = BeanProperties.set(\"values\").observe(getBean1());", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeDetailsSet, observeSet1, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(DetailSetBeanObservableInfo.class, (Object)binding.getTargetObservable());
        DetailBeanObservableInfo targetObservable = (DetailBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertNotNull((Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertInstanceOf(ValueBeanObservableInfo.class, (Object)targetObservable.getMasterObservable());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableObject(), (Object)targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanObservableTest.assertSame((Object)targetObservable.getMasterObservable().getBindableProperty(), (Object)targetObservable.getBindableProperty());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "name|\"name\"|java.lang.String", targetObservable.getBindableProperty());
        BeanObservableTest.assertEquals((Object)"\"empty\"", (Object)targetObservable.getDetailPropertyReference());
        BeanObservableTest.assertNotNull((Object)targetObservable.getDetailPropertyType());
        BeanObservableTest.assertEquals((Object)"boolean", (Object)targetObservable.getDetailPropertyType().getName());
        BeanObservableTest.assertEquals((Object)"m_bean0.name.detailSet(\"empty\", boolean.class)", (Object)targetObservable.getPresentationText());
    }

    @Test
    public void test_WritableList_1() throws Exception {
        this.test_WritableList("    WritableList writableList = new WritableList(m_list, String.class);");
    }

    @Test
    public void test_WritableList_2() throws Exception {
        this.test_WritableList("    WritableList writableList = new WritableList(Realm.getDefault(), m_list, String.class);");
    }

    private void test_WritableList(String line) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  private java.util.ArrayList m_list;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\", java.lang.String.class).observe(Realm.getDefault(), m_bean0);", line, "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeList, writableList, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(ListBeanObservableInfo.class, (Object)binding.getTargetObservable());
        ListBeanObservableInfo targetObservable = (ListBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertEquals((Object)"observeList", (Object)targetObservable.getVariableIdentifier());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.List", targetObservable.getBindableProperty());
        BeanObservableTest.assertInstanceOf(WritableListBeanObservableInfo.class, (Object)binding.getModelObservable());
        WritableListBeanObservableInfo modelObservable = (WritableListBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertEquals((Object)"writableList", (Object)modelObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"WritableList(m_list, String.class)", (Object)modelObservable.getPresentationText());
        BeanObservableTest.assertNotNull((Object)modelObservable.getElementType());
        BeanObservableTest.assertSame(String.class, (Object)modelObservable.getElementType());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_list - ArrayList|m_list|java.util.ArrayList", modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(CollectionPropertyBindableInfo.class, null, false, "Collection as WritableList/Properties.selfList()|m_list|java.util.ArrayList", modelObservable.getBindableProperty());
        modelObservable.setElementType(null);
        BeanObservableTest.assertEquals((Object)"WritableList(m_list, ?????.class)", (Object)modelObservable.getPresentationText());
    }

    @Test
    public void test_WritableSet_1() throws Exception {
        this.test_WritableSet("    WritableSet writableSet = new WritableSet(m_set, String.class);");
    }

    @Test
    public void test_WritableSet_2() throws Exception {
        this.test_WritableSet("    WritableSet writableSet = new WritableSet(Realm.getDefault(), m_set, String.class);");
    }

    private void test_WritableSet(String line) throws Exception {
        BeanObservableTest.setFileContentSrc("test/TestBean.java", BeanObservableTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BeanObservableTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  private TestBean m_bean0;", "  private java.util.HashSet m_set;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\", java.lang.String.class).observe(m_bean0);", line, "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeSet, writableSet, null, null);", "    return bindingContext;", "  }", "  public TestBean getBean1() {", "    return null;", "  }", "}"});
        BeanObservableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BeanObservableTest.assertNotNull((Object)bindings);
        BeanObservableTest.assertEquals((long)1L, (long)bindings.size());
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BeanObservableTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding.getTargetObservable());
        SetBeanObservableInfo targetObservable = (SetBeanObservableInfo)binding.getTargetObservable();
        BeanObservableTest.assertEquals((Object)"observeSet", (Object)targetObservable.getVariableIdentifier());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_bean0 - TestBean|m_bean0|test.TestBean", targetObservable.getBindableObject());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "names|\"names\"|java.util.Set", targetObservable.getBindableProperty());
        BeanObservableTest.assertInstanceOf(WritableSetBeanObservableInfo.class, (Object)binding.getModelObservable());
        WritableSetBeanObservableInfo modelObservable = (WritableSetBeanObservableInfo)binding.getModelObservable();
        BeanObservableTest.assertEquals((Object)"writableSet", (Object)modelObservable.getVariableIdentifier());
        BeanObservableTest.assertEquals((Object)"WritableSet(m_set, String.class)", (Object)modelObservable.getPresentationText());
        BeanObservableTest.assertNotNull((Object)modelObservable.getElementType());
        BeanObservableTest.assertSame(String.class, (Object)modelObservable.getElementType());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, null, true, "m_set - HashSet|m_set|java.util.HashSet", modelObservable.getBindableObject());
        BeanBindableTest.assertBindable(CollectionPropertyBindableInfo.class, null, false, "Collection as WritableSet/Properties.selfSet()|m_set|java.util.HashSet", modelObservable.getBindableProperty());
        modelObservable.setElementType(null);
        BeanObservableTest.assertEquals((Object)"WritableSet(m_set, ?????.class)", (Object)modelObservable.getPresentationText());
    }
}

