/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.check;

import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.junit.Assert;
import org.junit.Test;

public class AssertTest
extends Assert {
    @Test
    public void test_isLegal() {
        org.eclipse.wb.internal.core.utils.check.Assert.isLegal((boolean)true);
        org.eclipse.wb.internal.core.utils.check.Assert.isLegal((boolean)true, (String)"message");
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isLegal((boolean)false);
            AssertTest.fail();
        }
        catch (IllegalArgumentException e) {
            AssertTest.assertEquals((Object)"", (Object)e.getMessage());
        }
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isLegal((boolean)false, (String)"message");
            AssertTest.fail();
        }
        catch (IllegalArgumentException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNull(null);
        org.eclipse.wb.internal.core.utils.check.Assert.isNull(null, (String)"message");
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNull((Object)((Object)this));
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"null argument expected", (Object)e.getMessage());
        }
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNull((Object)((Object)this), (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull_1() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNull(null, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNull((Object)((Object)this), (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNull_2() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNull2(null, (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNull2((Object)((Object)this), (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_1() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNotNull((Object)((Object)this));
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNotNull(null);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"null argument", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_2() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNotNull((Object)((Object)this), (String)"message");
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNotNull(null, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull_3() {
        org.eclipse.wb.internal.core.utils.check.Assert.isNotNull((Object)((Object)this), (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNotNull(null, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isNotNull2() throws Exception {
        org.eclipse.wb.internal.core.utils.check.Assert.isNotNull2((Object)((Object)this), (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isNotNull2(null, (String)"errorFormat {0} {1}", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_fail() throws Exception {
        String message = "My fail message";
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.fail((String)message);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertSame((Object)message, (Object)e.getMessage());
        }
    }

    @Test
    public void test_fail_withParameters() throws Exception {
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.fail((String)"My {1} message {0}.", (Object[])new Object[]{"second", "first"});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"My first message second.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_1() {
        org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)true);
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)false);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"assertion failed", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_2() {
        org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)true, (String)"message");
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)false, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue_3() {
        org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)true, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrue((boolean)false, (String)"errorFormat %d %d", (Object[])new Object[]{1, 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat 1 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_isTrue2() {
        org.eclipse.wb.internal.core.utils.check.Assert.isTrue2((boolean)true, (String)"errorFormat {0} {1}", (Object[])new Object[]{"ABC", 2});
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrue2((boolean)false, (String)"errorFormat {0} {1}", (Object[])new Object[]{"ABC", 2});
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"errorFormat ABC 2", (Object)e.getMessage());
        }
    }

    @Test
    public void test_equals_int() throws Exception {
        org.eclipse.wb.internal.core.utils.check.Assert.equals((int)0, (int)0);
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.equals((int)0, (int)1);
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"0 expected, but 1 found", (Object)e.getMessage());
        }
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.equals((int)0, (int)1, (String)"message");
            AssertTest.fail();
        }
        catch (AssertionFailedException e) {
            AssertTest.assertEquals((Object)"message", (Object)e.getMessage());
        }
    }

    @Test
    public void test_instanceOf() throws Exception {
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.instanceOf(String.class, null);
            AssertTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
        org.eclipse.wb.internal.core.utils.check.Assert.instanceOf(String.class, (Object)"");
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.instanceOf(String.class, (Object)Boolean.TRUE);
            AssertTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_isTrueException_success() throws Exception {
        int exceptionCode = -1;
        org.eclipse.wb.internal.core.utils.check.Assert.isTrueException((boolean)true, (int)exceptionCode, (Object[])new Object[0]);
    }

    @Test
    public void test_isTrueException_String() throws Exception {
        int exceptionCode = -1;
        String message = "message";
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{message});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((long)exceptionCode, (long)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((long)1L, (long)parameters.length);
            AssertTest.assertSame((Object)message, (Object)parameters[0]);
        }
    }

    @Test
    public void test_isTrueException_Object() throws Exception {
        int exceptionCode = -1;
        Integer parameter = 10;
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{parameter});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((long)exceptionCode, (long)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((long)1L, (long)parameters.length);
            AssertTest.assertEquals((Object)"10", (Object)parameters[0]);
        }
    }

    @Test
    public void test_isTrueException_null() throws Exception {
        int exceptionCode = -1;
        Object parameter = null;
        try {
            org.eclipse.wb.internal.core.utils.check.Assert.isTrueException((boolean)false, (int)exceptionCode, (Object[])new Object[]{parameter});
            AssertTest.fail();
        }
        catch (DesignerException e) {
            AssertTest.assertEquals((long)exceptionCode, (long)e.getCode());
            String[] parameters = e.getParameters();
            AssertTest.assertEquals((long)1L, (long)parameters.length);
            AssertTest.assertEquals((Object)"null", (Object)parameters[0]);
        }
    }
}

