/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.internal.core.utils.ast.AnonymousTypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.Before;
import org.junit.Test;

public class AstNodeUtilsTest
extends AbstractJavaTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            AstNodeUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getFullyQualifiedName_null() {
        String qualifiedName = AstNodeUtils.getFullyQualifiedName(null, (boolean)false);
        AstNodeUtilsTest.assertSame((Object)AstNodeUtils.NO_TYPE_BINDING_NAME, (Object)qualifiedName);
    }

    @Test
    public void test_getFullyQualifiedName_type_expression() throws Exception {
        String code = "private String m_string = \"12345\";";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration field = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((Type)field.getType(), (boolean)false));
        VariableDeclarationFragment vdf = (VariableDeclarationFragment)field.fragments().get(0);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((Expression)vdf.getInitializer(), (boolean)false));
    }

    @Test
    public void test_getFullyQualifiedName() throws Exception {
        String code = "private int m_int;private int[] m_int_array;private String m_string;private String[] m_array_1;private String[][] m_array_2;private Inner m_inner;private Inner[] m_inner_array;private Class m_class = getClass();private class Inner{}";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 0, "int", "int");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 1, "int[]", "int[]");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 2, "java.lang.String", "java.lang.String");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 3, "java.lang.String[]", "java.lang.String[]");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 4, "java.lang.String[][]", "java.lang.String[][]");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 5, "test.Test.Inner", "test.Test$Inner");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 6, "test.Test.Inner[]", "test.Test$Inner[]");
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 7, "java.lang.Class", "java.lang.Class");
        FieldDeclaration field = typeDeclaration.getFields()[7];
        VariableDeclaration variableDeclaration = (VariableDeclaration)field.fragments().get(0);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.Class", (Object)AstNodeUtils.getFullyQualifiedName((Expression)variableDeclaration.getInitializer(), (boolean)false));
    }

    @Test
    public void test_getFullyQualifiedName_anon() throws Exception {
        TypeDeclaration type_0 = this.createTypeDeclaration_Test("public class Test {\n\tObject o_1 = new Object() {\n\t};\n\tObject o_2 = new Object() {\n\t};\n\tObject o_3 = new Object() {\n\t\tObject o_4 = new Object() {;\n\t\t};\n\t\tObject o_5 = new Object() {;\n\t\t\tObject o_6 = new Object() {;\n\t\t\t};\n\t\t};\n\t\tObject o_7 = new Object() {;\n\t\t\tObject o_8 = new Object() {;\n\t\t\t};\n\t\t};\n\t};\n}");
        FieldDeclaration field_1 = type_0.getFields()[0];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$1", field_1);
        FieldDeclaration field_2 = type_0.getFields()[1];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$2", field_2);
        FieldDeclaration field_3 = type_0.getFields()[2];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3", field_3);
        TypeDeclaration type_3 = AnonymousTypeDeclaration.create((AnonymousClassDeclaration)((ClassInstanceCreation)((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field_3).get(0)).getInitializer()).getAnonymousClassDeclaration());
        FieldDeclaration field_4 = type_3.getFields()[0];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3$1", field_4);
        FieldDeclaration field_5 = type_3.getFields()[1];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3$2", field_5);
        TypeDeclaration type_5 = AnonymousTypeDeclaration.create((AnonymousClassDeclaration)((ClassInstanceCreation)((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field_5).get(0)).getInitializer()).getAnonymousClassDeclaration());
        FieldDeclaration field_6 = type_5.getFields()[0];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3$2$1", field_6);
        FieldDeclaration field_7 = type_3.getFields()[2];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3$3", field_7);
        TypeDeclaration type_7 = AnonymousTypeDeclaration.create((AnonymousClassDeclaration)((ClassInstanceCreation)((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field_7).get(0)).getInitializer()).getAnonymousClassDeclaration());
        FieldDeclaration field_8 = type_7.getFields()[0];
        AstNodeUtilsTest.assert_getFullyQualifiedName_anon("test.Test$3$3$1", field_8);
    }

    private static void assert_getFullyQualifiedName_anon(String expectedName, FieldDeclaration field) {
        Expression initializer = ((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field).get(0)).getInitializer();
        AstNodeUtilsTest.assertEquals((Object)expectedName, (Object)AstNodeUtils.getFullyQualifiedName((Expression)initializer, (boolean)true));
    }

    @Test
    public void test_getFullyQualifiedName_generic_TypeVariable() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyObject.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class MyObject<E> {", "  public MyObject(E[] elements) {", "  }", "}"));
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tnew MyObject<String>(new String[]{\"a\", \"b\", \"c\"});\n\t}\n}");
        ClassInstanceCreation creation = (ClassInstanceCreation)this.getNode("new MyObject");
        IMethodBinding binding = AstNodeUtils.getCreationBinding((ClassInstanceCreation)creation);
        ITypeBinding parameterType = binding.getParameterTypes()[0];
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String[]", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)parameterType, (boolean)false));
        IMethodBinding genericBinding = binding.getMethodDeclaration();
        ITypeBinding parameterType2 = genericBinding.getParameterTypes()[0];
        AstNodeUtilsTest.assertEquals((Object)"E[]", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)parameterType2, (boolean)false));
    }

    @Test
    public void test_getFullyQualifiedName_generic() throws Exception {
        this.createModelType("test", "G.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class G<N extends java.lang.Number> {", "  private N value;", "  public G(N value){", "    this.value = value;", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_TestC(AstNodeUtilsTest.getSourceDQ("  // filler filler filler filler filler", "  private G field_1 = new/*marker_1*/ G(new Long(1));", "  private G field_2 = new/*marker_2*/ G<java.lang.Double>(1.5);", "  private G field_3 = new/*marker_3*/ G<Integer>(2);"));
        ITypeBinding binding_1 = this.getNode("marker_1", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_2 = this.getNode("marker_2", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_3 = this.getNode("marker_3", ClassInstanceCreation.class).resolveTypeBinding();
        AstNodeUtilsTest.assertNotSame((Object)binding_1, (Object)binding_2);
        String name_1 = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding_1, (boolean)false);
        String name_2 = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding_2, (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)name_1, (Object)"test.G");
        AstNodeUtilsTest.assertEquals((Object)name_2, (Object)"test.G");
        AstNodeUtilsTest.assertEquals((Object)name_1, (Object)name_2);
        name_1 = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding_1, (boolean)false, (boolean)true);
        name_2 = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding_2, (boolean)false, (boolean)true);
        String name_3 = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding_3, (boolean)false, (boolean)true);
        AstNodeUtilsTest.assertEquals((Object)name_1, (Object)"test.G");
        AstNodeUtilsTest.assertEquals((Object)name_2, (Object)"test.G<java.lang.Double>");
        AstNodeUtilsTest.assertEquals((Object)name_3, (Object)"test.G<java.lang.Integer>");
        AstNodeUtilsTest.assertNotEquals((Object)name_1, (Object)name_2);
    }

    @Test
    public void test_typeBindings_defaultPackage() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("", "Test.java", AstNodeUtilsTest.getSourceDQ("public class Test {", "  private Inner m_inner;", "  private class Inner {", "  }", "}"));
        this.check_FieldDeclarationQualifiedNames(typeDeclaration, 0, "Test.Inner", "Test$Inner");
    }

    @Test
    public void test_getTypeBinding() throws Exception {
        String code = "private String m_string = \"123\";";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclaration variableDeclaration = (VariableDeclaration)fieldDeclaration.fragments().get(0);
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)variableDeclaration.getInitializer());
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
    }

    @Test
    public void test_getTypeByQualifiedName() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  Object o_1 = new Object() {", "  };", "  Object o_2 = new Object() {", "  };", "}"));
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByQualifiedName((CompilationUnit)compilationUnit, (String)"test.Test");
        AstNodeUtilsTest.assertSame(DomGenerics.types((CompilationUnit)compilationUnit).get(0), (Object)typeDeclaration);
        typeDeclaration = AstNodeUtils.getTypeByQualifiedName((CompilationUnit)compilationUnit, (String)"test.Test$1");
        AnonymousClassDeclaration acd = (AnonymousClassDeclaration)typeDeclaration.getParent();
        ClassInstanceCreation creation = (ClassInstanceCreation)acd.getParent();
        VariableDeclaration variableDeclaration = (VariableDeclaration)creation.getParent();
        AstNodeUtilsTest.assertEquals((Object)"o_1", (Object)variableDeclaration.getName().getIdentifier());
    }

    @Test
    public void test_getTypeBinding_Type_goodType() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test {", "  String str;", "}"));
        Type type = (Type)this.m_lastEditor.getEnclosingNode("String ").getParent();
        ITypeBinding binding = AstNodeUtils.getTypeBinding((Type)type);
        AstNodeUtilsTest.assertNotNull((Object)binding);
        AstNodeUtilsTest.assertEquals((Object)"java.lang", (Object)binding.getPackage().getName());
        AstNodeUtilsTest.assertEquals((Object)"String", (Object)binding.getName());
    }

    @Test
    public void test_getTypeBinding_Type_badType() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test {", "  Foo foo;", "}"));
        Type type = (Type)this.m_lastEditor.getEnclosingNode("Foo ").getParent();
        ITypeBinding binding = AstNodeUtils.getTypeBinding((Type)type);
        AstNodeUtilsTest.assertNull((Object)binding);
    }

    @Test
    public void test_getTypeBinding_TypeDeclaration_goodType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends javax.swing.JPanel {\n\t// filler\n}");
        ITypeBinding binding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        AstNodeUtilsTest.assertNotNull((Object)binding);
        AstNodeUtilsTest.assertEquals((Object)"test", (Object)binding.getPackage().getName());
        AstNodeUtilsTest.assertEquals((Object)"Test", (Object)binding.getName());
        AstNodeUtilsTest.assertEquals((Object)"JPanel", (Object)binding.getSuperclass().getName());
    }

    @Test
    public void test_getTypeBindingArgument() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/Wrapper.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Wrapper<N extends java.lang.Number> {", "  private N value;", "  public Wrapper(N value){", "    this.value = value;", "  }", "}"));
        AstNodeUtilsTest.setFileContentSrc("test/WrapperSub.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class WrapperSub<T, S extends java.lang.Number> extends Wrapper<S> {", "  public WrapperSub(S value){", "    super(value);", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_TestC(AstNodeUtilsTest.getSourceDQ("  // filler filler filler filler filler", "  private Wrapper field_1 = new/*marker_1*/ Wrapper(new Long(1));", "  private Wrapper field_2 = new/*marker_2*/ Wrapper<Double>(1.5);", "  private WrapperSub field_3 = new/*marker_3*/ WrapperSub<String, Float>(3.5f);"));
        ITypeBinding binding_1 = this.getNode("marker_1", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_2 = this.getNode("marker_2", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_3 = this.getNode("marker_3", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding argument = AstNodeUtils.getTypeBindingArgument((ITypeBinding)binding_1, (int)0);
        AstNodeUtilsTest.assertNotNull((Object)argument);
        String argumentName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)argument, (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)argumentName, (Object)"java.lang.Number");
        argument = AstNodeUtils.getTypeBindingArgument((ITypeBinding)binding_2, (int)0);
        AstNodeUtilsTest.assertNotNull((Object)argument);
        argumentName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)argument, (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)argumentName, (Object)"java.lang.Double");
        argument = AstNodeUtils.getTypeBindingArgument((ITypeBinding)binding_3, (int)0);
        AstNodeUtilsTest.assertNotNull((Object)argument);
        argumentName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)argument, (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)argumentName, (Object)"java.lang.String");
        argument = AstNodeUtils.getTypeBindingArgument((ITypeBinding)binding_3, (String)"test.Wrapper", (int)0);
        AstNodeUtilsTest.assertNotNull((Object)argument);
        argumentName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)argument, (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)argumentName, (Object)"java.lang.Float");
        try {
            AstNodeUtils.getTypeBindingArgument((ITypeBinding)binding_3, (String)"no.such.Class", (int)0);
            AstNodeUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getVariableBinding_notVariable() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test {", "  // filler", "}"));
        SimpleName name = (SimpleName)this.m_lastEditor.getEnclosingNode("Test");
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getVariableBinding((ASTNode)name));
    }

    @Test
    public void test_getVariableBinding_SimpleName() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test {", "  private int m_value = 123;", "}"));
        SimpleName variable = (SimpleName)this.m_lastEditor.getEnclosingNode("m_value");
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)variable);
        AstNodeUtilsTest.assertNotNull((Object)variableBinding);
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)variableBinding.getName());
        AstNodeUtilsTest.assertEquals((Object)true, (Object)variableBinding.isField());
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable(null));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)variable));
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getVariableName((ASTNode)variable));
        AstNodeUtilsTest.assertSame((Object)variable, (Object)AstNodeUtils.getVariableSimpleName((ASTNode)variable));
    }

    @Test
    public void test_getVariableBinding_FieldAccess() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  private int m_value;", "  void foo() {", "    this.m_value = 123;", "  }", "}"));
        FieldAccess variable = (FieldAccess)this.m_lastEditor.getEnclosingNode(".m_value");
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)variable);
        AstNodeUtilsTest.assertNotNull((Object)variableBinding);
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)variableBinding.getName());
        AstNodeUtilsTest.assertEquals((Object)true, (Object)variableBinding.isField());
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable(null));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)variable));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)variable.getName()));
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getVariableName((ASTNode)variable));
        AstNodeUtilsTest.assertSame((Object)variable.getName(), (Object)AstNodeUtils.getVariableSimpleName((ASTNode)variable));
    }

    @Test
    public void test_getVariableBinding_unknownType() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  private Foo m_value = 123;", "}"));
        SimpleName variable = (SimpleName)this.m_lastEditor.getEnclosingNode("m_value");
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)variable);
        AstNodeUtilsTest.assertNull((Object)variableBinding);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)variable));
        AstNodeUtilsTest.assertSame((Object)variable, (Object)AstNodeUtils.getVariableSimpleName((ASTNode)variable));
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getVariableName((ASTNode)variable));
    }

    private void check_FieldDeclarationQualifiedNames(TypeDeclaration typeDeclaration, int index, String sourceName, String runtimeName) {
        FieldDeclaration fieldDeclaration = (FieldDeclaration)typeDeclaration.bodyDeclarations().get(index);
        ITypeBinding typeBinding = fieldDeclaration.getType().resolveBinding();
        this.check_typeBindingNames(typeBinding, sourceName, runtimeName);
        AstNodeUtilsTest.assertEquals((long)1L, (long)fieldDeclaration.fragments().size());
        VariableDeclaration variableDeclaration = (VariableDeclaration)fieldDeclaration.fragments().get(0);
        ITypeBinding typeBinding2 = variableDeclaration.resolveBinding().getType();
        this.check_typeBindingNames(typeBinding2, sourceName, runtimeName);
    }

    private void check_typeBindingNames(ITypeBinding typeBinding, String sourceName, String runtimeName) {
        AstNodeUtilsTest.assertEquals((Object)sourceName, (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false));
        AstNodeUtilsTest.assertEquals((Object)runtimeName, (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)true));
    }

    @Test
    public void test_getTypeBinding_SingleVariableDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate void foo(int a, String b, String[] c) {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        List parameters = DomGenerics.parameters((MethodDeclaration)methodDeclaration);
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        ITypeBinding binding = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
        AstNodeUtilsTest.assertEquals((Object)"int", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
        parameter = (SingleVariableDeclaration)parameters.get(1);
        binding = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
        parameter = (SingleVariableDeclaration)parameters.get(2);
        binding = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String[]", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
    }

    @Test
    public void test_getTypeBinding_SingleVariableDeclaration_noType() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate void foo(NoSuchType a) {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        List parameters = DomGenerics.parameters((MethodDeclaration)methodDeclaration);
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        ITypeBinding binding = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
        AstNodeUtilsTest.assertNull((Object)binding);
    }

    @Test
    public void test_getTypeBinding_VariableDeclaration() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler\npublic class Test {\n\tprivate short d;\n\tprivate void foo(long a) {\n\t\tString b;\n\t\tfor (int c = 0; c < 10; c++) {\n\t\t}\n\t}\n}");
        VariableDeclaration var = this.getNode("a)", VariableDeclaration.class);
        ITypeBinding binding = AstNodeUtils.getTypeBinding((VariableDeclaration)var);
        AstNodeUtilsTest.assertEquals((Object)"long", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
        var = this.getNode("b;", VariableDeclaration.class);
        binding = AstNodeUtils.getTypeBinding((VariableDeclaration)var);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
        var = this.getNode("c =", VariableDeclaration.class);
        binding = AstNodeUtils.getTypeBinding((VariableDeclaration)var);
        AstNodeUtilsTest.assertEquals((Object)"int", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
        var = this.getNode("d;", VariableDeclaration.class);
        binding = AstNodeUtils.getTypeBinding((VariableDeclaration)var);
        AstNodeUtilsTest.assertEquals((Object)"short", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false));
    }

    @Test
    public void test_getFullyQualifiedName_SingleVariableDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate void foo(int a, String b, String[] c) {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        List parameters = DomGenerics.parameters((MethodDeclaration)methodDeclaration);
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        AstNodeUtilsTest.assertEquals((Object)"int", (Object)AstNodeUtils.getFullyQualifiedName((SingleVariableDeclaration)parameter, (boolean)false));
        parameter = (SingleVariableDeclaration)parameters.get(1);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String", (Object)AstNodeUtils.getFullyQualifiedName((SingleVariableDeclaration)parameter, (boolean)false));
        parameter = (SingleVariableDeclaration)parameters.get(2);
        AstNodeUtilsTest.assertEquals((Object)"java.lang.String[]", (Object)AstNodeUtils.getFullyQualifiedName((SingleVariableDeclaration)parameter, (boolean)false));
    }

    @Test
    public void test_isSuccessorOf_ITypeBinding_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate String m_string = \"123\";\n\tprivate String[] m_string_array = {};\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        ITypeBinding typeBinding = fieldDeclaration.getType().resolveBinding();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.String"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, String.class));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.Object"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.Integer"));
        fieldDeclaration = typeDeclaration.getFields()[1];
        typeBinding = fieldDeclaration.getType().resolveBinding();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.String"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.String[]"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"java.lang.Object"));
    }

    @Test
    public void test_isSuccessorOf_ITypeBinding_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test extends javax.swing.JPanel {\n}");
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String[])new String[]{"java.util.List", "java.util.Map"}));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String[])new String[]{"java.util.List", "java.awt.Container"}));
    }

    @Test
    public void test_isSuccessorOf_ITypeBinding_3() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tprivate String m_string = \"123\";\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclaration declaration = (VariableDeclaration)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0);
        Expression initializer = declaration.getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Expression)initializer, (String)"java.lang.String"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Expression)initializer, String.class));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Expression)initializer, (String)"java.lang.Object"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((Expression)initializer, (String)"java.lang.Integer"));
    }

    @Test
    public void test_isSuccessorOf_ITypeBinding_ITypeBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate java.util.List m_List = null;\n\tprivate java.util.ArrayList m_ArrayList = null;\n\tprivate java.util.Set m_Set = null;\n}");
        FieldDeclaration[] fields = typeDeclaration.getFields();
        ITypeBinding bindingList = AstNodeUtils.getTypeBinding((Type)fields[0].getType());
        ITypeBinding bindingArrayList = AstNodeUtils.getTypeBinding((Type)fields[1].getType());
        ITypeBinding bindingSet = AstNodeUtils.getTypeBinding((Type)fields[2].getType());
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)bindingArrayList, (ITypeBinding)bindingList));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)bindingArrayList, (ITypeBinding)bindingSet));
    }

    @Test
    public void test_isSuccessorOf_Expression_ITypeBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate Object m_ArrayList = new java.util.ArrayList();\n\tprivate java.util.List m_List = null;\n\tprivate java.util.Set m_Set = null;\n}");
        FieldDeclaration[] fields = typeDeclaration.getFields();
        Expression expressionArrayList = ((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)fields[0]).get(0)).getInitializer();
        ITypeBinding bindingList = AstNodeUtils.getTypeBinding((Type)fields[1].getType());
        ITypeBinding bindingSet = AstNodeUtils.getTypeBinding((Type)fields[2].getType());
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Expression)expressionArrayList, (ITypeBinding)bindingList));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((Expression)expressionArrayList, (ITypeBinding)bindingSet));
    }

    @Test
    public void test_isSuccessorOf_SingleVariableDeclaration_ITypeBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate void foo(int a, String b, java.util.ArrayList c) {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        List parameters = DomGenerics.parameters((MethodDeclaration)methodDeclaration);
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(0);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((SingleVariableDeclaration)parameter, (String)"int"));
        parameter = (SingleVariableDeclaration)parameters.get(1);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((SingleVariableDeclaration)parameter, (String)"java.lang.String"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((SingleVariableDeclaration)parameter, (String)"java.lang.Object"));
        parameter = (SingleVariableDeclaration)parameters.get(2);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((SingleVariableDeclaration)parameter, (String)"java.util.List"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((SingleVariableDeclaration)parameter, (String)"java.util.Map"));
    }

    @Test
    public void test_isSuccessorOf_Type() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test {", "  String str;", "}"));
        Type type = this.getNode("String ", Type.class);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((Type)type, (String)"java.util.List"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Type)type, (String)"java.lang.String"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((Type)type, (String)"java.lang.Object"));
    }

    @Test
    public void test_isSuccessorOf_TypeDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "import java.util.ArrayList;", "public class Test extends ArrayList {", "}"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((TypeDeclaration)typeDeclaration, (String)"java.lang.Object"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((TypeDeclaration)typeDeclaration, (String)"java.util.List"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((TypeDeclaration)typeDeclaration, (String)"java.util.ArrayList"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((TypeDeclaration)typeDeclaration, (String)"java.util.Map"));
    }

    @Test
    public void test_isSuccessorOf_Anonymous() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "import java.util.ArrayList;", "public class Test {", "  ArrayList object = new ArrayList() {", "    // marker", "  };", "}"));
        AnonymousClassDeclaration declaration = this.getNode("marker", AnonymousClassDeclaration.class);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((AnonymousClassDeclaration)declaration, (String)"java.lang.Object"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((AnonymousClassDeclaration)declaration, (String)"java.util.List"));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((AnonymousClassDeclaration)declaration, (String)"java.util.ArrayList"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isSuccessorOf((AnonymousClassDeclaration)declaration, (String)"java.util.Map"));
    }

    @Test
    public void test_hasVisibility() throws Exception {
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)1, (int)1));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)4, (int)4));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)2, (int)2));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)20, (int)4));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasVisibility((int)1, (int)4));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasVisibility((int)4, (int)1));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasVisibility((int)2, (int)5));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)1, (int)5));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasVisibility((int)4, (int)5));
    }

    @Test
    public void test_isStatic_forBodyDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate int m_foo;\n\tprivate static int m_bar;\n\tpublic void foo() {\n\t}\n\tpublic static void bar() {\n\t}\n}");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isStatic((BodyDeclaration)fieldDeclaration));
        fieldDeclaration = typeDeclaration.getFields()[1];
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isStatic((BodyDeclaration)fieldDeclaration));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isStatic((BodyDeclaration)methodDeclaration));
        methodDeclaration = typeDeclaration.getMethods()[1];
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isStatic((BodyDeclaration)methodDeclaration));
    }

    @Test
    public void test_isStatic_IMethodBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t}\n\tpublic static void bar() {\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)methodDeclaration);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isStatic((IMethodBinding)methodBinding));
        methodDeclaration = typeDeclaration.getMethods()[1];
        methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)methodDeclaration);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isStatic((IMethodBinding)methodBinding));
    }

    @Test
    public void test_isStatic_ITypeBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic class Foo {\n\t}\n\tpublic static class Bar {\n\t}\n}");
        TypeDeclaration fooType = typeDeclaration.getTypes()[0];
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)fooType);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isStatic((ITypeBinding)typeBinding));
        TypeDeclaration barType = typeDeclaration.getTypes()[1];
        typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)barType);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isStatic((ITypeBinding)typeBinding));
    }

    @Test
    public void test_isAbstract_IMethodBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public abstract class Test {\n\tpublic void foo() {\n\t}\n\tpublic abstract void bar();\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)methodDeclaration);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isAbstract((IMethodBinding)methodBinding));
        methodDeclaration = typeDeclaration.getMethods()[1];
        methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)methodDeclaration);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isAbstract((IMethodBinding)methodBinding));
    }

    @Test
    public void test_isAbstract_MethodDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public abstract class Test {\n\tpublic void foo() {\n\t}\n\tpublic abstract void bar();\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isAbstract((MethodDeclaration)methodDeclaration));
        methodDeclaration = typeDeclaration.getMethods()[1];
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isAbstract((MethodDeclaration)methodDeclaration));
    }

    @Test
    public void test_isAbstract_ITypeBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic class Foo {\n\t}\n\tpublic abstract class Bar {\n\t}\n}");
        TypeDeclaration fooType = typeDeclaration.getTypes()[0];
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)fooType);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isAbstract((ITypeBinding)typeBinding));
        TypeDeclaration barType = typeDeclaration.getTypes()[1];
        typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)barType);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isAbstract((ITypeBinding)typeBinding));
    }

    @Test
    public void test_isMember() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Object foo() {\n\t\treturn new Object() {};\n\t}\n\tpublic class Bar {\n\t}\n}");
        ClassInstanceCreation creation = (ClassInstanceCreation)this.m_lastEditor.getEnclosingNode("new Object");
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)creation);
        AstNodeUtilsTest.assertFalse((boolean)typeBinding.isMember());
        TypeDeclaration barType = typeDeclaration.getTypes()[0];
        typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)barType);
        AstNodeUtilsTest.assertTrue((boolean)typeBinding.isMember());
    }

    @Test
    public void test_getMethodBindings_bindingsWithVisibility() throws Exception {
        this.createModelType("test", "A.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class A {", "  private void aPrivate() {}", "  protected void aProtected() {}", "  public void aPublic() {}", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "B.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class B extends A {", "  private void bPrivate() {}", "  protected void bProtected() {}", "  public void bPublic() {}", "}"));
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        List methods = AstNodeUtils.getMethodBindings((ITypeBinding)typeBinding, (int)1);
        AstNodeUtilsTest.assertHasMethods(methods, new String[]{"aPublic()", "bPublic()"}, new String[]{"aPrivate()", "aProtected()", "bPrivate()", "bProtected()"});
        methods = AstNodeUtils.getMethodBindings((ITypeBinding)typeBinding, (int)5);
        AstNodeUtilsTest.assertHasMethods(methods, new String[]{"aPublic()", "aProtected()", "bPublic()", "bProtected()"}, new String[]{"aPrivate()", "bPrivate()"});
        methods = AstNodeUtils.getMethodBindings((ITypeBinding)typeBinding, (int)2);
        AstNodeUtilsTest.assertHasMethods(methods, new String[]{"bPrivate()"}, new String[]{"aPrivate()", "aProtected()", "aPublic()", "bProtected()", "bPublic()"});
    }

    private static void assertHasMethods(List<IMethodBinding> methods, String[] expectedSignatures, String[] unExpectedSignatures) {
        TreeSet<String> actualSignatures = new TreeSet<String>();
        for (IMethodBinding methodBinding : methods) {
            actualSignatures.add(AstNodeUtils.getMethodSignature((IMethodBinding)methodBinding));
        }
        Assertions.assertThat(actualSignatures).contains((Object[])expectedSignatures);
        String[] stringArray = unExpectedSignatures;
        int n = unExpectedSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String unExpectedSignature = stringArray[n2];
            AstNodeUtilsTest.assertFalse((String)String.valueOf(actualSignatures), (boolean)actualSignatures.contains(unExpectedSignature));
            ++n2;
        }
    }

    @Test
    public void test_getFieldBindings_bindingsWithVisibility() throws Exception {
        this.createModelType("test", "A.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class A {", "  private int aPrivate;", "  protected int aProtected;", "  public int aPublic;", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "B.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class B extends A {", "  private int bPrivate;", "  protected int bProtected;", "  public int bPublic;", "}"));
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        List fields = AstNodeUtils.getFieldBindings((ITypeBinding)typeBinding, (int)1);
        AstNodeUtilsTest.assertHasFields(fields, new String[]{"aPublic", "bPublic"}, new String[]{"aPrivate", "aProtected", "bPrivate", "bProtected"});
        fields = AstNodeUtils.getFieldBindings((ITypeBinding)typeBinding, (int)5);
        AstNodeUtilsTest.assertHasFields(fields, new String[]{"aPublic", "aProtected", "bPublic", "bProtected"}, new String[]{"aPrivate", "bPrivate"});
        fields = AstNodeUtils.getFieldBindings((ITypeBinding)typeBinding, (int)2);
        AstNodeUtilsTest.assertHasFields(fields, new String[]{"bPrivate"}, new String[]{"aPrivate", "aProtected", "aPublic", "bProtected", "bPublic"});
    }

    private static void assertHasFields(List<IVariableBinding> actualFields, String[] expectedNames, String[] unExpectedNames) {
        TreeSet<String> actualNames = new TreeSet<String>();
        for (IVariableBinding field : actualFields) {
            actualNames.add(field.getName());
        }
        Assertions.assertThat(actualNames).contains((Object[])expectedNames);
        String[] stringArray = unExpectedNames;
        int n = unExpectedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String unExpectedSignature = stringArray[n2];
            AstNodeUtilsTest.assertFalse((String)String.valueOf(actualNames), (boolean)actualNames.contains(unExpectedSignature));
            ++n2;
        }
    }

    @Test
    public void test_getFieldAssignment_QualifiedName() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyObject.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class MyObject {", "  public int m_value;", "}"));
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tMyObject foo = new MyObject();\n\t\tfoo.m_value = 1;\n\t}\n}");
        int index = this.m_lastEditor.getSource().indexOf("foo =");
        Expression fooNode = (Expression)this.m_lastEditor.getEnclosingNode(index);
        Expression fieldAccess = AstNodeUtils.getFieldAssignment((ASTNode)fooNode);
        AstNodeUtilsTest.assertNull((Object)fieldAccess);
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getFieldAccessName((Expression)fooNode));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getFieldAccessQualifier((Expression)fooNode));
        index = this.m_lastEditor.getSource().indexOf("oo.");
        fooNode = this.m_lastEditor.getEnclosingNode(index);
        fieldAccess = AstNodeUtils.getFieldAssignment((ASTNode)fooNode);
        AstNodeUtilsTest.assertInstanceOf(QualifiedName.class, (Object)fieldAccess);
        AstNodeUtilsTest.assertInstanceOf(Assignment.class, (Object)fieldAccess.getParent());
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getFieldAccessName((Expression)fieldAccess).getIdentifier());
        Expression qualifier = AstNodeUtils.getFieldAccessQualifier((Expression)fieldAccess);
        AstNodeUtilsTest.assertInstanceOf(SimpleName.class, (Object)qualifier);
        AstNodeUtilsTest.assertEquals((Object)"foo", (Object)this.m_lastEditor.getSource((ASTNode)qualifier));
    }

    @Test
    public void test_getFieldAssignment_FieldAccess() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyObject.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class MyObject {", "  public int m_value;", "}"));
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tnew MyObject().m_value = 1;\n\t}\n}");
        int index = this.m_lastEditor.getSource().indexOf("().");
        ASTNode objectNode = this.m_lastEditor.getEnclosingNode(index);
        Expression fieldAccess = AstNodeUtils.getFieldAssignment((ASTNode)objectNode);
        AstNodeUtilsTest.assertInstanceOf(FieldAccess.class, (Object)fieldAccess);
        AstNodeUtilsTest.assertInstanceOf(Assignment.class, (Object)fieldAccess.getParent());
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)AstNodeUtils.getFieldAccessName((Expression)fieldAccess).getIdentifier());
        Expression qualifier = AstNodeUtils.getFieldAccessQualifier((Expression)fieldAccess);
        AstNodeUtilsTest.assertInstanceOf(ClassInstanceCreation.class, (Object)qualifier);
        AstNodeUtilsTest.assertEquals((Object)"new MyObject()", (Object)this.m_lastEditor.getSource((ASTNode)qualifier));
    }

    @Test
    public void test_getFieldFragmentByName() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate int m_value;\n\tpublic String m_name = \"123\";\n}");
        VariableDeclarationFragment fragment0 = AstNodeUtils.getFieldFragmentByName((TypeDeclaration)typeDeclaration, (String)"m_value");
        AstNodeUtilsTest.assertNotNull((Object)fragment0);
        AstNodeUtilsTest.assertEquals((Object)"m_value", (Object)fragment0.getName().getIdentifier());
        VariableDeclarationFragment fragment1 = AstNodeUtils.getFieldFragmentByName((TypeDeclaration)typeDeclaration, (String)"m_name");
        AstNodeUtilsTest.assertNotNull((Object)fragment1);
        AstNodeUtilsTest.assertEquals((Object)"m_name", (Object)fragment1.getName().getIdentifier());
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getFieldFragmentByName((TypeDeclaration)typeDeclaration, (String)"m_key"));
    }

    @Test
    public void test_getEnclosingStatement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){System.out.println();}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ExpressionStatement statement = (ExpressionStatement)methodDeclaration.getBody().statements().get(0);
        AstNodeUtilsTest.assertSame((Object)statement, (Object)AstNodeUtils.getEnclosingStatement((ASTNode)statement));
        AstNodeUtilsTest.assertSame((Object)statement, (Object)AstNodeUtils.getEnclosingStatement((ASTNode)statement.getExpression()));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getEnclosingStatement((ASTNode)typeDeclaration));
    }

    @Test
    public void test_getEnclosingBlock() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){System.out.println();}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Block body = methodDeclaration.getBody();
        ExpressionStatement statement = (ExpressionStatement)body.statements().get(0);
        AstNodeUtilsTest.assertSame((Object)body, (Object)AstNodeUtils.getEnclosingBlock((ASTNode)body));
        AstNodeUtilsTest.assertSame((Object)body, (Object)AstNodeUtils.getEnclosingBlock((ASTNode)statement));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getEnclosingBlock((ASTNode)typeDeclaration));
    }

    @Test
    public void test_getEnclosingFieldDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_field;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertSame((Object)fieldDeclaration, (Object)AstNodeUtils.getEnclosingFieldDeclaration((ASTNode)fieldDeclaration));
        AstNodeUtilsTest.assertSame((Object)fieldDeclaration, (Object)AstNodeUtils.getEnclosingFieldDeclaration((ASTNode)fieldDeclaration.getType()));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getEnclosingFieldDeclaration((ASTNode)typeDeclaration));
    }

    @Test
    public void test_getEnclosingMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        AstNodeUtilsTest.assertSame((Object)methodDeclaration, (Object)AstNodeUtils.getEnclosingMethod((ASTNode)methodDeclaration));
        AstNodeUtilsTest.assertSame((Object)methodDeclaration, (Object)AstNodeUtils.getEnclosingMethod((ASTNode)methodDeclaration.getBody()));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getEnclosingMethod((ASTNode)typeDeclaration));
    }

    @Test
    public void test_getEnclosingMethod_inTypeDeclaration() throws Exception {
        TypeDeclaration testType = this.createTypeDeclaration_Test("public class Test {\n\tprivate int markA;\n\tpublic void methodA() {\n\t\tclass Inner {\n\t\t\tpublic void methodB() {\n\t\t\t\tint markB;\n\t\t\t}\n\t\t}\n\t}\n\tpublic void methodC() {\n\t\tint markC;\n\t}\n}");
        Object markA = this.getNode("markA");
        Object markB = this.getNode("markB");
        Object markC = this.getNode("markC");
        MethodDeclaration methodA = this.getNode("methodA", MethodDeclaration.class);
        MethodDeclaration methodC = this.getNode("methodC", MethodDeclaration.class);
        AstNodeUtilsTest.assertSame(null, (Object)AstNodeUtils.getEnclosingMethod((TypeDeclaration)testType, markA));
        AstNodeUtilsTest.assertSame((Object)methodA, (Object)AstNodeUtils.getEnclosingMethod((TypeDeclaration)testType, markB));
        AstNodeUtilsTest.assertSame((Object)methodC, (Object)AstNodeUtils.getEnclosingMethod((TypeDeclaration)testType, markC));
    }

    @Test
    public void test_getEnclosingType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("String m_string;");
        AstNodeUtilsTest.assertSame((Object)typeDeclaration, (Object)AstNodeUtils.getEnclosingType((ASTNode)typeDeclaration));
        AstNodeUtilsTest.assertSame((Object)typeDeclaration, (Object)AstNodeUtils.getEnclosingType((ASTNode)typeDeclaration.getFields()[0]));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getEnclosingType((ASTNode)typeDeclaration.getParent()));
    }

    @Test
    public void test_getEnclosingTypeTop() throws Exception {
        TypeDeclaration testType = this.createTypeDeclaration_Test("public class Test {\n\tpublic class Inner {\n\t\tpublic void foo() {\n\t\t}\n\t}\n\tpublic void bar() {\n\t}\n}");
        TypeDeclaration innerType = testType.getTypes()[0];
        MethodDeclaration fooMethod = innerType.getMethods()[0];
        MethodDeclaration barMethod = testType.getMethods()[0];
        AstNodeUtilsTest.assertSame((Object)testType, (Object)AstNodeUtils.getEnclosingTypeTop((ASTNode)fooMethod));
        AstNodeUtilsTest.assertSame((Object)testType, (Object)AstNodeUtils.getEnclosingTypeTop((ASTNode)barMethod));
        AstNodeUtilsTest.assertSame((Object)testType, (Object)AstNodeUtils.getEnclosingTypeTop((ASTNode)innerType));
        AstNodeUtilsTest.assertSame((Object)testType, (Object)AstNodeUtils.getEnclosingTypeTop((ASTNode)testType));
    }

    @Test
    public void test_getParentType() throws Exception {
        TypeDeclaration testType = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tObject object = new Object(){\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"test\";\n\t\t\t}\n\t\t};\n\t}\n}");
        MethodDeclaration fooMethod = testType.getMethods()[0];
        AstNodeUtilsTest.assertSame((Object)AstNodeUtils.getParentType((MethodDeclaration)fooMethod), (Object)testType);
        MethodDeclaration toStringMethod = AstNodeUtils.getEnclosingMethod(this.getNode("toString"));
        AstNodeUtilsTest.assertInstanceOf(AnonymousClassDeclaration.class, (Object)toStringMethod.getParent());
        AstNodeUtilsTest.assertSame((Object)AstNodeUtils.getEnclosingType((ASTNode)toStringMethod), (Object)testType);
        AstNodeUtilsTest.assertInstanceOf(TypeDeclaration.class, (Object)AstNodeUtils.getParentType((MethodDeclaration)toStringMethod));
    }

    @Test
    public void test_getEnclosingNode_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        SimpleName node = typeDeclaration.getName();
        AstNodeUtilsTest.assertSame((Object)node, (Object)AstNodeUtils.getEnclosingNode((ASTNode)typeDeclaration, (int)(node.getStartPosition() + 1)));
        node = method.getName();
        AstNodeUtilsTest.assertSame((Object)method, (Object)AstNodeUtils.getEnclosingNode((ASTNode)typeDeclaration, (int)AstNodeUtils.getSourceEnd((ASTNode)node)));
    }

    @Test
    public void test_getEnclosingNode_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){   int a;   }");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        Block body = method.getBody();
        AstNodeUtilsTest.assertSame((Object)body, (Object)AstNodeUtils.getEnclosingNode((ASTNode)typeDeclaration, (int)(body.getStartPosition() + 1)));
    }

    @Test
    public void test_getCommonParent() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t\tint b;\n\t}\n\tpublic void foo() {\n\t\tint c;\n\t}\n}");
        Object nodeA = this.getNode("a;");
        Object nodeB = this.getNode("b;");
        Object nodeC = this.getNode("c;");
        Block blockTest = AstNodeUtils.getEnclosingBlock(nodeA);
        ASTNode commonParent = AstNodeUtils.getCommonParent(nodeA, nodeB);
        AstNodeUtilsTest.assertSame((Object)blockTest, (Object)commonParent);
        ASTNode parentA = nodeA.getParent();
        ASTNode commonParent2 = AstNodeUtils.getCommonParent(nodeA, nodeA);
        AstNodeUtilsTest.assertSame((Object)parentA, (Object)commonParent2);
        commonParent = AstNodeUtils.getCommonParent(nodeA, nodeC);
        AstNodeUtilsTest.assertSame((Object)typeDeclaration, (Object)commonParent);
    }

    @Test
    public void test_getCommonBlock() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t\tint b;\n\t}\n\tpublic void foo() {\n\t\tint c;\n\t}\n}");
        Object nodeA = this.getNode("a;");
        Object nodeB = this.getNode("b;");
        Object nodeC = this.getNode("c;");
        Block blockTest = AstNodeUtils.getEnclosingBlock(nodeA);
        Block commonBlock = AstNodeUtils.getCommonBlock(nodeA, nodeB);
        AstNodeUtilsTest.assertSame((Object)blockTest, (Object)commonBlock);
        commonBlock = AstNodeUtils.getCommonBlock(nodeA, nodeA);
        AstNodeUtilsTest.assertSame((Object)blockTest, (Object)commonBlock);
        commonBlock = AstNodeUtils.getCommonBlock(nodeA, nodeC);
        AstNodeUtilsTest.assertSame(null, (Object)commonBlock);
    }

    @Test
    public void test_getStatementWithinBlock() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint a;\n\t\t{\n\t\t\tint b;\n\t\t}\n\t}\n\tpublic void foo() {\n\t\tint c;\n\t}\n}");
        Object nodeA = this.getNode("a;");
        Object nodeB = this.getNode("b;");
        Object nodeC = this.getNode("c;");
        Block blockA = AstNodeUtils.getEnclosingBlock(nodeA);
        Block blockB = AstNodeUtils.getEnclosingBlock(nodeB);
        Statement statementA = AstNodeUtils.getEnclosingStatement(nodeA);
        Statement statement = AstNodeUtils.getStatementWithinBlock((Block)blockA, nodeA);
        AstNodeUtilsTest.assertSame((Object)statementA, (Object)statement);
        Statement statementB = AstNodeUtils.getEnclosingStatement(nodeB);
        statement = AstNodeUtils.getStatementWithinBlock((Block)blockB, nodeB);
        AstNodeUtilsTest.assertSame((Object)statementB, (Object)statement);
        Statement statement2 = AstNodeUtils.getStatementWithinBlock((Block)blockA, nodeB);
        AstNodeUtilsTest.assertSame((Object)blockB, (Object)statement2);
        statement2 = AstNodeUtils.getStatementWithinBlock((Block)blockA, nodeC);
        AstNodeUtilsTest.assertSame(null, (Object)statement2);
    }

    @Test
    public void test_getNextStatement() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    int a;", "    int b;", "    int c;", "  }", "}"));
        int index = this.m_lastEditor.getSource().indexOf("int b;");
        Statement statement = this.m_lastEditor.getEnclosingStatement(index);
        Statement nextStatement = AstNodeUtils.getNextStatement((Statement)statement);
        AstNodeUtilsTest.assertEquals((Object)"int c;", (Object)this.m_lastEditor.getSource((ASTNode)nextStatement));
        index = this.m_lastEditor.getSource().indexOf("int c;");
        statement = this.m_lastEditor.getEnclosingStatement(index);
        nextStatement = AstNodeUtils.getNextStatement((Statement)statement);
        AstNodeUtilsTest.assertNull((Object)nextStatement);
    }

    private void check_getVariableDeclarationsAll(String[] lines, String[] expectedNames) throws Exception {
        Object source = AstNodeUtilsTest.getSource(lines);
        source = "package test;\n" + (String)source;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", (String)source);
        List declarations = AstNodeUtils.getVariableDeclarationsAll((ASTNode)typeDeclaration);
        AstNodeUtilsTest.assertEquals((String)"Wrong count of variables.", (long)expectedNames.length, (long)declarations.size());
        int i = 0;
        while (i < declarations.size()) {
            VariableDeclaration declaration = (VariableDeclaration)declarations.get(i);
            AstNodeUtilsTest.assertEquals((Object)declaration.getName().getIdentifier(), (Object)expectedNames[i]);
            ++i;
        }
    }

    @Test
    public void test_getVariableDeclarationsAll() throws Exception {
        this.check_getVariableDeclarationsAll(new String[]{"public class Test {", "  private int a;", "  public void foo(int b) {", "    int c;", "  }", "}"}, new String[]{"a", "b", "c"});
    }

    private void check_getVariableDeclarationsAfter(String[] lines, String positionSource, String[] expectedNames) throws Exception {
        Object source = AstNodeUtilsTest.getSource(lines);
        source = "package test;\n" + (String)source;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", (String)source);
        int position = ((String)source).indexOf(positionSource);
        AstNodeUtilsTest.assertTrue((position != -1 ? 1 : 0) != 0);
        List declarations = AstNodeUtils.getVariableDeclarationsAfter((ASTNode)typeDeclaration, (int)position);
        AstNodeUtilsTest.assertEquals((String)"Wrong count of shadowing variables.", (long)expectedNames.length, (long)declarations.size());
        int i = 0;
        while (i < declarations.size()) {
            VariableDeclaration declaration = (VariableDeclaration)declarations.get(i);
            AstNodeUtilsTest.assertEquals((Object)declaration.getName().getIdentifier(), (Object)expectedNames[i]);
            ++i;
        }
    }

    @Test
    public void test_getVariableDeclarationsAfter_type() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  // marker", "  int a;", "  void foo(int b) {", "    int c;", "  }", "}"}, "// marker", new String[]{"b", "c"});
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_1() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  int a;", "  void foo() {", "    int b;", "    System.gc();", "    int c;", "  }", "}"}, "System.gc()", new String[]{"c"});
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_2() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  void foo() {", "    int a;", "    // marker", "    int b;", "  }", "}"}, "// marker", new String[]{"b"});
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_3() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  void foo() {", "    int a;", "    int b;", "  }", "}"}, "int b", new String[]{"b"});
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_4() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  void foo() {", "    int a;", "    System.gc();", "    int b;", "    {", "      int c;", "    }", "  }", "}"}, "System.gc()", new String[]{"b", "c"});
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_5() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  void foo() {", "    {", "      System.gc();", "    }", "    int a;", "    {", "      int b;", "    }", "  }", "}"}, "System.gc()", new String[0]);
    }

    @Test
    public void test_getVariableDeclarationsAfter_statement_6() throws Exception {
        this.check_getVariableDeclarationsAfter(new String[]{"public class Test {", "  void foo() {", "    System.gc();", "    class Inner {int a;}", "    Runtime.getRuntime().addShutdownHook(new Thread() {int b;});", "  }", "}"}, "System.gc()", new String[]{"a", "b"});
    }

    @Test
    public void test_getVariableDeclarationsVisibleAt_1() throws Exception {
        String code = "void foo(){int a = 1; int b;}";
        this.check_getVariableDeclarationsVisibleAt(code, new int[1], 0, new String[0]);
    }

    @Test
    public void test_getVariableDeclarationsVisibleAt_2() throws Exception {
        String code = "void foo(){int a = 1;  int b;}";
        this.check_getVariableDeclarationsVisibleAt(code, new int[]{1}, 0, new String[]{"a = 1"});
    }

    @Test
    public void test_getVariableDeclarationsVisibleAt_3() throws Exception {
        String code = "void foo(){int a = 1;  int b;}";
        this.check_getVariableDeclarationsVisibleAt(code, new int[]{1}, -1, new String[]{"a = 1"});
    }

    @Test
    public void test_getVariableDeclarationsVisibleAt_4() throws Exception {
        String code = "void foo(){int a = 1;  int b;}";
        this.check_getVariableDeclarationsVisibleAt(code, new int[]{1}, -4, new String[0]);
    }

    @Test
    public void test_getVariableDeclarationsVisibleAt_5() throws Exception {
        String code = "int a = 1; void foo(int b){int c;}";
        this.check_getVariableDeclarationsVisibleAt(code, new int[1], 0, new String[]{"int b", "a = 1"});
    }

    public void check_getVariableDeclarationsVisibleAt(String code, int[] indexes, int offset, String[] expectedSources) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        Statement statement = AstNodeUtilsTest.getStatement(method.getBody(), indexes);
        int position = statement.getStartPosition() + offset;
        List declarations = AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)typeDeclaration, (int)position);
        AstNodeUtilsTest.assertEquals((long)expectedSources.length, (long)declarations.size());
        int i = 0;
        while (i < declarations.size()) {
            VariableDeclaration declaration = (VariableDeclaration)declarations.get(i);
            String actualSource = this.m_lastEditor.getSource((ASTNode)declaration);
            String expectedSource = expectedSources[i];
            AstNodeUtilsTest.assertEquals((Object)expectedSource, (Object)actualSource);
            ++i;
        }
    }

    @Test
    public void test_isVariable() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tint field = 0;\n\tpublic void foo() {\n\t\tint local = 0;\n\t\tSystem.out.println(field);\n\t\tSystem.out.println(this.field);\n\t\tSystem.out.println(local);\n\t\tSystem.out.println(java.util.Collections.EMPTY_LIST);\n\t}\n}");
        SimpleName argument = (SimpleName)this.m_lastEditor.getEnclosingNode("field)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        argument = (SimpleName)this.m_lastEditor.getEnclosingNode("local)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        argument = (FieldAccess)this.m_lastEditor.getEnclosingNode(".field)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)argument.getName()));
        argument = (VariableDeclarationFragment)this.m_lastEditor.getEnclosingNode("local = 0").getParent();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        argument = (QualifiedName)this.m_lastEditor.getEnclosingNode("EMPTY_LIST)").getParent();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)argument.getName()));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isVariable((ASTNode)argument.getQualifier()));
    }

    @Test
    public void test_getActualVariableExpression() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tObject field1 = new Object();\n\tObject field2 = null;\n\tpublic void foo() {\n\t\tfield2 = new Double(0);\n\t\tObject local1 = null;\n\t\tObject local2 = null;\n\t\tSystem.out.println(field1/*marker1*/);\n\t\tSystem.out.println(this.field2/*marker2*/);\n\t\tlocal1 = new Integer(7);\n\t\tSystem.out.println(local1/*marker3*/);\n\t\tSystem.out.println(local2/*marker4*/);\n\t}\n}");
        this.assert_variable("marker1", "new Object()");
        this.assert_variable("marker2", "new Double(0)");
        this.assert_variable("marker3", "new Integer(7)");
        this.assert_variable("marker4", "null");
    }

    private void assert_variable(String marker, String actualExpression) {
        MethodInvocation invocation = (MethodInvocation)this.getNode(marker);
        Expression argument = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isVariable((ASTNode)argument));
        Expression expression = AstNodeUtils.getActualVariableExpression((Expression)argument);
        AstNodeUtilsTest.assertEquals((Object)expression.toString(), (Object)actualExpression);
    }

    @Test
    public void test_getMethodInvocations_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tvoid foo() {\n\t\tbar(1);\n\t\tbar(2);\n\t}\n\tvoid bar(int i) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getMethodInvocations((MethodDeclaration)methods[1]);
        Assertions.assertThat((List)invocations).hasSize(2);
        List statementList = DomGenerics.statements((Block)methods[0].getBody());
        Statement[] statements = statementList.toArray(new Statement[statementList.size()]);
        AstNodeUtilsTest.assertTrue((boolean)invocations.contains(((ExpressionStatement)statements[0]).getExpression()));
        AstNodeUtilsTest.assertTrue((boolean)invocations.contains(((ExpressionStatement)statements[1]).getExpression()));
    }

    @Test
    public void test_getMethodInvocations_sameSignature_differentTypes() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyObject.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class MyObject {", "  public void bar(int i) {", "  }", "}"));
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tprivate MyObject myObject = new MyObject();\n\tvoid foo() {\n\t\tmyObject.bar(1);\n\t\tbar(2);\n\t}\n\tvoid bar(int i) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getMethodInvocations((MethodDeclaration)methods[1]);
        Assertions.assertThat((List)invocations).hasSize(1);
        List statementList = DomGenerics.statements((Block)methods[0].getBody());
        Statement[] statements = statementList.toArray(new Statement[statementList.size()]);
        AstNodeUtilsTest.assertTrue((boolean)invocations.contains(((ExpressionStatement)statements[1]).getExpression()));
    }

    @Test
    public void test_getMethodInvocations_noType_noBinding() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tvoid root() {\n\t\ttoInvoke(null);\n\t}\n\tvoid toInvoke(NoSuchType o) {\n\t}\n}");
        MethodDeclaration method = typeDeclaration.getMethods()[1];
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBinding((MethodDeclaration)method));
        List invocations = AstNodeUtils.getMethodInvocations((MethodDeclaration)method);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getLocalMethodDeclaration_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tvoid foo() {\n\t\tbar();\n\t\tthis.bar();\n\t\tnew Test().bar();\n\t\tSystem.gc();\n\t}\n\tvoid bar() {\n\t}\n}");
        List statements = DomGenerics.statements((Block)typeDeclaration.getMethods()[0].getBody());
        MethodInvocation invocation = (MethodInvocation)((ExpressionStatement)statements.get(0)).getExpression();
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
        invocation = (MethodInvocation)((ExpressionStatement)statements.get(1)).getExpression();
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
        invocation = (MethodInvocation)((ExpressionStatement)statements.get(2)).getExpression();
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
        invocation = (MethodInvocation)((ExpressionStatement)statements.get(3)).getExpression();
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
    }

    @Test
    public void test_getLocalMethodDeclaration_2() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  void foo() {", "    baZ();", "  }", "  void bar() {", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List statements = DomGenerics.statements((Block)typeDeclaration.getMethods()[0].getBody());
        MethodInvocation invocation = (MethodInvocation)((ExpressionStatement)statements.get(0)).getExpression();
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
    }

    @Test
    public void test_getLocalMethodDeclaration_cachingBug() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tvoid foo() {\n\t\tbar();\n\t}\n\tvoid bar() {\n\t}\n}");
        MethodInvocation invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode("bar()").getParent();
        MethodDeclaration oldMethod = typeDeclaration.getMethods()[1];
        AstNodeUtilsTest.assertSame((Object)oldMethod, (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
        this.m_lastEditor.removeBodyDeclaration((BodyDeclaration)oldMethod);
        MethodDeclaration newMethod = this.m_lastEditor.addMethodDeclaration("void bar()", Collections.emptyList(), new BodyDeclarationTarget(typeDeclaration, false));
        AstNodeUtilsTest.assertSame((Object)newMethod, (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
        AstNodeUtilsTest.assertSame((Object)newMethod, (Object)AstNodeUtils.getLocalMethodDeclaration((MethodInvocation)invocation));
    }

    @Test
    public void test_getLocalConstructorDeclaration() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  void foo() {", "    new Test(0);", "    new Integer(0);", "  }", "  public Test(int value) {", "  }", "}"));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List statements = DomGenerics.statements((Block)typeDeclaration.getMethods()[0].getBody());
        ClassInstanceCreation creation = (ClassInstanceCreation)((ExpressionStatement)statements.get(0)).getExpression();
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)AstNodeUtils.getLocalConstructorDeclaration((ClassInstanceCreation)creation));
        creation = (ClassInstanceCreation)((ExpressionStatement)statements.get(1)).getExpression();
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getLocalConstructorDeclaration((ClassInstanceCreation)creation));
    }

    @Test
    public void test_getConstructorInvocations_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tTest() {\n\t\tthis(1);\n\t}\n\tpublic Test(int i) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getConstructorInvocations((MethodDeclaration)methods[1]);
        Assertions.assertThat((List)invocations).hasSize(1);
        ConstructorInvocation expected = (ConstructorInvocation)this.m_lastEditor.getEnclosingNode("this(1)");
        AstNodeUtilsTest.assertSame((Object)expected, invocations.get(0));
    }

    @Test
    public void test_getConstructorInvocations_noType_noBinding() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tTest() {\n\t\tthis(null);\n\t}\n\tTest(NoSuchType o) {\n\t}\n}");
        MethodDeclaration method = typeDeclaration.getMethods()[1];
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBinding((MethodDeclaration)method));
        List invocations = AstNodeUtils.getConstructorInvocations((MethodDeclaration)method);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getClassInstanceCreations_0() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tpublic Test(int value) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getClassInstanceCreations((MethodDeclaration)methods[0]);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getClassInstanceCreations_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int value) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Test(1);\n\t\tnew Test(2);\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getClassInstanceCreations((MethodDeclaration)methods[0]);
        Assertions.assertThat((List)invocations).hasSize(2);
        Assertions.assertThat((List)invocations).containsOnly((Object[])new ASTNode[]{this.m_lastEditor.getEnclosingNode("new Test(1)"), this.m_lastEditor.getEnclosingNode("new Test(2)")});
    }

    @Test
    public void test_getConstructors() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int value) {\n\t}\n\tpublic void foo() {\n\t}\n\tpublic Test(boolean value) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List constructors = AstNodeUtils.getConstructors((TypeDeclaration)typeDeclaration);
        Assertions.assertThat((List)constructors).containsOnly((Object[])new MethodDeclaration[]{methods[0], methods[2]});
    }

    @Test
    public void test_getClassInstanceCreations_TypeDeclaration_0() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\npublic class Test {\n\tpublic Test(int value) {\n\t}\n\tprivate class Foo {\n\t}\n}");
        TypeDeclaration foo = typeDeclaration.getTypes()[0];
        List invocations = AstNodeUtils.getClassInstanceCreations((TypeDeclaration)foo);
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_getClassInstanceCreations_TypeDeclaration_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test(int value) {\n\t\tnew Foo(1);\n\t\tnew Foo(2);\n\t}\n\tprivate class Foo {\n\t\tFoo(int value) {}\n\t}\n}");
        TypeDeclaration foo = typeDeclaration.getTypes()[0];
        List invocations = AstNodeUtils.getClassInstanceCreations((TypeDeclaration)foo);
        Assertions.assertThat((List)invocations).hasSize(2);
        Assertions.assertThat((List)invocations).containsExactly((Object[])new ASTNode[]{this.getNode("new Foo(1)"), this.getNode("new Foo(2)")});
    }

    @Test
    public void test_getJavaDocTag() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\t/**\n\t * @my.tag\n\t */\n\tprivate int m_foo;\n\t/**\n\t * Not a tag.\n\t */\n\tprivate int m_bar;\n\t/**\n\t * @second.tag aaa bbb\n\t */\n\tprivate int m_baz;\n\tprivate int m_goo;\n}");
        FieldDeclaration fooField = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getJavaDocTag((BodyDeclaration)fooField, (String)"@noSuchTag"));
        TagElement tagElement = AstNodeUtils.getJavaDocTag((BodyDeclaration)fooField, (String)"@my.tag");
        AstNodeUtilsTest.assertNotNull((Object)tagElement);
        AstNodeUtilsTest.assertEquals((Object)"@my.tag", (Object)this.m_lastEditor.getSource((ASTNode)tagElement));
        FieldDeclaration barField = typeDeclaration.getFields()[1];
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getJavaDocTag((BodyDeclaration)barField, (String)"@noAnyTag"));
        FieldDeclaration bazField = typeDeclaration.getFields()[2];
        tagElement = AstNodeUtils.getJavaDocTag((BodyDeclaration)bazField, (String)"@second.tag");
        AstNodeUtilsTest.assertNotNull((Object)tagElement);
        AstNodeUtilsTest.assertEquals((Object)"@second.tag aaa bbb", (Object)this.m_lastEditor.getSource((ASTNode)tagElement));
        FieldDeclaration gooField = typeDeclaration.getFields()[3];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasJavaDocTag((BodyDeclaration)gooField, (String)"@noAnyTag"));
    }

    @Test
    public void test_hasJavaDocTag() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\t/**\n\t * @my.tag\n\t */\n\tprivate int m_foo;\n\t/**\n\t * Not a tag.\n\t */\n\tprivate int m_bar;\n\tprivate int m_goo;\n}");
        FieldDeclaration fooField = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.hasJavaDocTag((BodyDeclaration)fooField, (String)"@my.tag"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasJavaDocTag((BodyDeclaration)fooField, (String)"@noSuchTag"));
        FieldDeclaration barField = typeDeclaration.getFields()[1];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasJavaDocTag((BodyDeclaration)barField, (String)"@noAnyTag"));
        FieldDeclaration gooField = typeDeclaration.getFields()[2];
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.hasJavaDocTag((BodyDeclaration)gooField, (String)"@noAnyTag"));
    }

    @Test
    public void test_isMethodInvocation_onlySignature() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tprivate void root() {\n\t\tSystem.exit(0);\n\t\texit(1);\n\t}\n\tprivate void exit(int code) {\n\t}\n}");
        ASTNode node = this.m_lastEditor.getEnclosingNode("(0)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)node, (String)"exit(int)"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)node, (String)"incorrectSignature()"));
        node = this.m_lastEditor.getEnclosingNode("(1)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)node, (String)"exit(int)"));
        node = this.m_lastEditor.getEnclosingNode("Test");
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)node, (String)"notMethodInvocation()"));
    }

    @Test
    public void test_isMethodInvocation_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tObject m_1 = java.util.Arrays.toString(new int[] {});\n\tObject m_2 = null;\n\tint m_3 = hashCode();\n}");
        Expression initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Arrays", (String)"toString(int[])"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Arrays", (String)"toString(long[])"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Collections", (String)"no-such-signature"));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 1).getInitializer();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"not-a-class", (String)"no-such-signature"));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 2).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, null, (String)"hashCode()"));
    }

    @Test
    public void test_isMethodInvocation_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tint m_1 = new java.util.ArrayList().size();\n}");
        Expression initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.List", (String)"size()"));
    }

    @Test
    public void test_isMethodInvocation_SuperMethodInvocation() throws Exception {
        this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tint value = 123;\n\t\tsuper.hashCode();\n\t}\n}");
        Expression expression = (Expression)this.getNode(".hashCode", SuperMethodInvocation.class);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"java.lang.Object", (String)"hashCode()"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"wrong.Class", (String)"hashCode()"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"java.lang.Object", (String)"no-such-signature"));
        expression = (Expression)this.getNode("123");
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"not-a-class", (String)"no-such-signature"));
    }

    @Test
    public void test_isMethodInvocation_signatures_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tObject m_1 = java.util.Arrays.toString(new int[] {});\n\tObject m_2 = null;\n\tint m_3 = hashCode();\n}");
        Expression initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Arrays", (String[])new String[]{"toString(int[])"}));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Arrays", (String[])new String[]{"toString(long[])"}));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Collections", (String[])new String[]{"no-such-signature"}));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Collections", (String[])new String[]{"no-such-signature", "toString(int[])"}));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 1).getInitializer();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"not-a-class", (String[])new String[]{"no-such-signature"}));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 2).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, null, (String[])new String[]{"hashCode()"}));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.Collection", (String[])new String[]{"hashCode()"}));
    }

    @Test
    public void test_isMethodInvocation_signatures_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tint m_1 = new java.util.ArrayList().size();\n}");
        Expression initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isMethodInvocation((ASTNode)initializer, (String)"java.util.List", (String[])new String[]{"size()"}));
    }

    @Test
    public void test_isCreation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tObject m_1 = new java.util.ArrayList(0);\n\tObject m_2 = null;\n}");
        Expression initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"java.util.ArrayList", (String)"<init>(int)"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"java.util.List", (String)"<init>(int)"));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"java.util.ArrayList", (String)"invalid-signature"));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 0).getInitializer();
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"java.util.ArrayList", (String[])new String[]{"<init>(int)", "<init>()"}));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"java.util.ArrayList", (String[])new String[]{"<init>()", "<init>()"}));
        initializer = AstNodeUtilsTest.getFieldFragment(typeDeclaration, 1).getInitializer();
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isCreation((ASTNode)initializer, (String)"not-a-class", (String)"no-such-signature"));
    }

    @Test
    public void test_getMethodBySignature() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.util.ArrayList;\npublic class Test extends ArrayList {\n\tpublic void foo() {\n\t}\n}");
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        IMethodBinding method = AstNodeUtils.getMethodBySignature((ITypeBinding)typeBinding, (String)"foo()");
        String declaringType = AstNodeUtils.getFullyQualifiedName((ITypeBinding)method.getDeclaringClass(), (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)"test.Test", (Object)declaringType);
        method = AstNodeUtils.getMethodBySignature((ITypeBinding)typeBinding, (String)"get(int)");
        declaringType = AstNodeUtils.getFullyQualifiedName((ITypeBinding)method.getDeclaringClass(), (boolean)false);
        AstNodeUtilsTest.assertEquals((Object)"java.util.ArrayList", (Object)declaringType);
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBySignature((ITypeBinding)typeBinding, (String)"noSuchMethod()"));
    }

    @Test
    public void test_getMethodSignature_forMethodInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){bar(1);} void bar(int i){}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List invocations = AstNodeUtils.getMethodInvocations((MethodDeclaration)methods[1]);
        AstNodeUtilsTest.assertEquals((long)1L, (long)invocations.size());
        MethodInvocation invocation = (MethodInvocation)invocations.get(0);
        AstNodeUtilsTest.assertEquals((Object)"bar(int)", (Object)AstNodeUtils.getMethodSignature((MethodInvocation)invocation));
    }

    @Test
    public void test_getMainType_1() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", "public class Test{} class Foo{}");
        TypeDeclaration mainType = AstNodeUtils.getTypeByName((CompilationUnit)compilationUnit, (String)"Test");
        AstNodeUtilsTest.assertNotNull((Object)mainType);
        AstNodeUtilsTest.assertEquals((Object)"Test", (Object)mainType.getName().getIdentifier());
    }

    @Test
    public void test_getMainType_2() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", "class Foo{} public class Test{}");
        TypeDeclaration mainType = AstNodeUtils.getTypeByName((CompilationUnit)compilationUnit, (String)"Test");
        AstNodeUtilsTest.assertNotNull((Object)mainType);
        AstNodeUtilsTest.assertEquals((Object)"Test", (Object)mainType.getName().getIdentifier());
    }

    @Test
    public void test_getMainType_3() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", "class Foo{} class Test{}");
        TypeDeclaration mainType = AstNodeUtils.getTypeByName((CompilationUnit)compilationUnit, (String)"Test");
        AstNodeUtilsTest.assertNotNull((Object)mainType);
        AstNodeUtilsTest.assertEquals((Object)"Test", (Object)mainType.getName().getIdentifier());
    }

    @Test
    public void test_getMainType_4() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", "class Foo{} class Bar{}");
        TypeDeclaration mainType = AstNodeUtils.getTypeByName((CompilationUnit)compilationUnit, (String)"Test");
        AstNodeUtilsTest.assertNull((Object)mainType);
    }

    @Test
    public void test_getMainType_noTypeBinding() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstNodeUtilsTest.getSource("// filler filler filler", "package test;", "public class Test {", "  public EntityCombo<ArticleFormat> foo;", "  public Test() {", "    foo.bar();", "  }", "}"));
        AstNodeUtilsTest.assertNotNull((Object)typeDeclaration.resolveBinding());
        CompilationUnit compilationUnit = (CompilationUnit)typeDeclaration.getParent();
        TypeDeclaration actual = AstNodeUtils.getTypeByName((CompilationUnit)compilationUnit, (String)"Test");
        AstNodeUtilsTest.assertSame((Object)typeDeclaration, (Object)actual);
    }

    @Test
    public void test_getFullyQualifiedName_TypeDeclaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\nclass Test {\n\tprivate class A {}\n}");
        AstNodeUtilsTest.assertEquals((Object)"test.Test", (Object)AstNodeUtils.getFullyQualifiedName((TypeDeclaration)typeDeclaration, (boolean)false));
        AstNodeUtilsTest.assertEquals((Object)"test.Test.A", (Object)AstNodeUtils.getFullyQualifiedName((TypeDeclaration)typeDeclaration.getTypes()[0], (boolean)false));
    }

    @Test
    public void test_getTypeDeclaration_inner() throws Exception {
        this.createTypeDeclaration_Test("class Test {\n\tprivate class A {}\n\tvoid foo() {\n\t\tnew A();\n\t\tnew Integer(0);\n\t}\n}");
        ClassInstanceCreation creation = (ClassInstanceCreation)this.getNode("new A(");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeDeclaration((ClassInstanceCreation)creation);
        AstNodeUtilsTest.assertNotNull((Object)typeDeclaration);
        creation = (ClassInstanceCreation)this.getNode("new Integer(");
        typeDeclaration = AstNodeUtils.getTypeDeclaration((ClassInstanceCreation)creation);
        AstNodeUtilsTest.assertNull((Object)typeDeclaration);
    }

    @Test
    public void test_getTypeDeclaration_local() throws Exception {
        this.createTypeDeclaration_Test("class Test {\n\tvoid foo() {\n\t\tclass A {}\n\t\tnew A();\n\t}\n}");
        ClassInstanceCreation creation = (ClassInstanceCreation)this.getNode("new A(");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeDeclaration((ClassInstanceCreation)creation);
        AstNodeUtilsTest.assertNotNull((Object)typeDeclaration);
    }

    @Test
    public void test_getMethodSignature_null() throws Exception {
        AstNodeUtilsTest.assertSame((Object)AstNodeUtils.NO_METHOD_BINDING_SIGNATURE, (Object)AstNodeUtils.getMethodSignature(null));
    }

    @Test
    public void test_getMethodSignature_constructor() throws Exception {
        String code = "Test() {} Test(int i, String s) {}";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        AstNodeUtilsTest.assertEquals((Object)"<init>()", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[0]));
        AstNodeUtilsTest.assertEquals((Object)"<init>(int,java.lang.String)", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[1]));
    }

    @Test
    public void test_getMethodSignature() throws Exception {
        String code = "void m_0() {}void m_1(int p1) {}void m_2(String p1) {}int m_3(String p1, java.util.ArrayList p2) {return 0;}java.util.Map m_4(String p1) {return null;}";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        AstNodeUtilsTest.assertEquals((Object)"m_0()", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[0]));
        AstNodeUtilsTest.assertEquals((Object)"m_1(int)", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[1]));
        AstNodeUtilsTest.assertEquals((Object)"m_2(java.lang.String)", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[2]));
        AstNodeUtilsTest.assertEquals((Object)"m_3(java.lang.String,java.util.ArrayList)", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[3]));
        AstNodeUtilsTest.assertEquals((Object)"m_4(java.lang.String)", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)methods[4]));
        while (true) {
            try {
                AstNodeUtils.getMethodSignature(null);
            }
            catch (AssertionFailedException e) {
                break;
            }
            AstNodeUtilsTest.fail();
        }
        AstNodeUtilsTest.assertSame((Object)methods[0], (Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_0()"));
        AstNodeUtilsTest.assertSame((Object)methods[1], (Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_1(int)"));
        AstNodeUtilsTest.assertSame((Object)methods[2], (Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_2(java.lang.String)"));
        AstNodeUtilsTest.assertSame((Object)methods[3], (Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_3(java.lang.String,java.util.ArrayList)"));
        AstNodeUtilsTest.assertSame((Object)methods[4], (Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_4(java.lang.String)"));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)""));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_0(int)"));
        AstNodeUtilsTest.assertNull((Object)AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"m_X(int)"));
        while (true) {
            try {
                AstNodeUtils.getMethodBySignature(null, (String)"");
            }
            catch (AssertionFailedException e) {
                break;
            }
            AstNodeUtilsTest.fail();
        }
        while (true) {
            try {
                AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, null);
            }
            catch (AssertionFailedException e) {
                break;
            }
            AstNodeUtilsTest.fail();
        }
    }

    @Test
    public void test_getMethodGenericSignature_noBounds() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyPanel.java", AstNodeUtilsTest.getSourceDQ("package test;", "import javax.swing.*;", "public class MyPanel extends JPanel {", "  public <T> void foo(int v, T value) {", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\tfoo(0, new JButton());\n\t}\n}");
        MethodInvocation invocation = this.getNode("foo(", MethodInvocation.class);
        IMethodBinding binding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        int i = 0;
        while (i < 2) {
            if (i != 0) {
                binding = new BindingContext().get(binding);
            }
            AstNodeUtilsTest.assertEquals((Object)"foo(int,javax.swing.JButton)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,T)", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,java.lang.Object)", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)binding));
            ++i;
        }
    }

    @Test
    public void test_getMethodGenericSignature_array() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyPanel.java", AstNodeUtilsTest.getSourceDQ("package test;", "import javax.swing.*;", "public class MyPanel extends JPanel {", "  public <T> void foo(int v, T[] value) {", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\tfoo(0, new String[0]);\n\t}\n}");
        MethodInvocation invocation = this.getNode("foo(", MethodInvocation.class);
        IMethodBinding binding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        int i = 0;
        while (i < 2) {
            if (i != 0) {
                binding = new BindingContext().get(binding);
            }
            AstNodeUtilsTest.assertEquals((Object)"foo(int,java.lang.String[])", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,T[])", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,java.lang.Object[])", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)binding));
            ++i;
        }
    }

    @Test
    public void test_getMethodGenericSignature_extendsClass() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyPanel.java", AstNodeUtilsTest.getSourceDQ("package test;", "import javax.swing.*;", "public class MyPanel extends JPanel {", "  public <T extends JButton> void foo(int v, T value) {", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\tfoo(0, new JButton());\n\t}\n}");
        MethodInvocation invocation = this.getNode("foo(", MethodInvocation.class);
        IMethodBinding binding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        int i = 0;
        while (i < 2) {
            if (i != 0) {
                binding = new BindingContext().get(binding);
            }
            AstNodeUtilsTest.assertEquals((Object)"foo(int,javax.swing.JButton)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,T)", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,javax.swing.JButton)", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)binding));
            ++i;
        }
    }

    @Test
    public void test_getMethodGenericSignature_extendsInterface() throws Exception {
        AstNodeUtilsTest.setFileContentSrc("test/MyPanel.java", AstNodeUtilsTest.getSourceDQ("package test;", "import javax.swing.*;", "public class MyPanel extends JPanel {", "  public <T extends java.util.List> void foo(int v, T value) {", "  }", "}"));
        AstNodeUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.*;\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\tfoo(0, new java.util.ArrayList());\n\t}\n}");
        MethodInvocation invocation = this.getNode("foo(", MethodInvocation.class);
        IMethodBinding binding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        int i = 0;
        while (i < 2) {
            if (i != 0) {
                binding = new BindingContext().get(binding);
            }
            AstNodeUtilsTest.assertEquals((Object)"foo(int,java.util.ArrayList)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,T)", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)binding));
            AstNodeUtilsTest.assertEquals((Object)"foo(int,java.util.List)", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)binding));
            ++i;
        }
    }

    @Test
    public void test_getMethodSignatures() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t}\n\tpublic void bar(int a, String b) {\n\t}\n}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        List signatures = AstNodeUtils.getMethodSignatures(List.of(methods[0], methods[1]));
        AstNodeUtilsTest.assertEquals((long)signatures.size(), (long)2L);
        AstNodeUtilsTest.assertEquals((Object)signatures, List.of("foo()", "bar(int,java.lang.String)"));
    }

    @Test
    public void test_getMethodByName() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.util.ArrayList;\npublic class Test extends ArrayList {\n\tpublic void foo(int a) {\n\t}\n}");
        MethodDeclaration actual = AstNodeUtils.getMethodByName((TypeDeclaration)typeDeclaration, (String)"foo");
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)actual);
        actual = AstNodeUtils.getMethodByName((TypeDeclaration)typeDeclaration, (String)"noSuchMethod");
        AstNodeUtilsTest.assertSame(null, (Object)actual);
    }

    @Test
    public void test_getMethodBinding_2_declaration() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int foo(String s) {return 0;}");
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        IMethodBinding binding = AstNodeUtils.getMethodBinding((MethodDeclaration)methods[0]);
        AstNodeUtilsTest.assertEquals((Object)"foo(java.lang.String)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
    }

    @Test
    public void test_getMethodBinding_MethodDeclaration_noBinding() throws Exception {
        this.m_ignoreModelCompileProblems = true;
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstNodeUtilsTest.getSource("package test;", "public class Test {", "  private badMethod(Foo foo) {", "  }", "}"));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        AstNodeUtilsTest.assertSame(null, (Object)AstNodeUtils.getMethodBinding((MethodDeclaration)methodDeclaration));
    }

    @Test
    public void test_ConstructorInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Test() {\n\t\tthis(false, 2);\n\t}\n\tpublic Test(boolean b, int i) {\n\t}\n}");
        ConstructorInvocation invocation = (ConstructorInvocation)this.m_lastEditor.getEnclosingNode("this(");
        AstNodeUtilsTest.assertEquals((Object)"<init>(boolean,int)", (Object)AstNodeUtils.getSignature((ConstructorInvocation)invocation));
        AstNodeUtilsTest.assertSame((Object)typeDeclaration.getMethods()[1], (Object)AstNodeUtils.getConstructor((ConstructorInvocation)invocation));
    }

    @Test
    public void test_getMethodBinding_SuperMethodInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic String toString() {\n\t\tsuper.toString();\n\t\treturn null;\n\t}\n}");
        MethodDeclaration toStringMethod = typeDeclaration.getMethods()[0];
        ExpressionStatement firstStatement = (ExpressionStatement)toStringMethod.getBody().statements().get(0);
        SuperMethodInvocation superInvocation = (SuperMethodInvocation)firstStatement.getExpression();
        IMethodBinding binding = AstNodeUtils.getMethodBinding((SuperMethodInvocation)superInvocation);
        AstNodeUtilsTest.assertEquals((Object)"toString()", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
    }

    @Test
    public void test_getCreationSignature_1() throws Exception {
        String code = "javax.swing.JButton button_1 = new javax.swing.JButton();\njavax.swing.JButton button_2 = new javax.swing.JButton(\"abc\");\njavax.swing.JButton button_3 = new javax.swing.JButton(\"abc\", null);\n";
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        AstNodeUtilsTest.check_getCreationSignature(typeDeclaration, 0, "<init>()");
        AstNodeUtilsTest.check_getCreationSignature(typeDeclaration, 1, "<init>(java.lang.String)");
        AstNodeUtilsTest.check_getCreationSignature(typeDeclaration, 2, "<init>(java.lang.String,javax.swing.Icon)");
    }

    @Test
    public void test_getCreationSignature_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler\n// filler filler filler\npublic class Test {\n}\n");
        this.m_lastEditor.addFieldDeclaration("private Integer value = new Integer(5);", new BodyDeclarationTarget(typeDeclaration, true));
        AstNodeUtilsTest.assertEditor(AstNodeUtilsTest.getSourceDQ("package test;", "// filler filler filler", "// filler filler filler", "public class Test {", "  private Integer value = new Integer(5);", "}"), this.m_lastEditor);
        AstNodeUtilsTest.check_getCreationSignature(typeDeclaration, 0, "<init>(int)");
    }

    private static void check_getCreationSignature(TypeDeclaration typeDeclaration, int fieldIndex, String expectedSignature) throws Exception {
        FieldDeclaration[] fields = typeDeclaration.getFields();
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fields[fieldIndex].fragments().get(0);
        ClassInstanceCreation initializer = (ClassInstanceCreation)fragment.getInitializer();
        AstNodeUtilsTest.assertEquals((Object)expectedSignature, (Object)AstNodeUtils.getCreationSignature((ClassInstanceCreation)initializer));
    }

    @Test
    public void test_SuperConstructorInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.*;\nimport javax.swing.*;\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsuper(new BorderLayout());\n\t}\n}");
        MethodDeclaration constructor = typeDeclaration.getMethods()[0];
        List statements = DomGenerics.statements((Block)constructor.getBody());
        SuperConstructorInvocation invocation = (SuperConstructorInvocation)statements.get(0);
        String signature = AstNodeUtils.getSuperSignature((SuperConstructorInvocation)invocation);
        AstNodeUtilsTest.assertEquals((Object)"<init>(java.awt.LayoutManager)", (Object)signature);
        IMethodBinding binding = AstNodeUtils.getSuperBinding((SuperConstructorInvocation)invocation);
        String signature2 = AstNodeUtils.getMethodSignature((IMethodBinding)binding);
        AstNodeUtilsTest.assertEquals((Object)"<init>(java.awt.LayoutManager)", (Object)signature2);
    }

    @Test
    public void test_getSourceX() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getStartPosition(), (long)AstNodeUtils.getSourceBegin((ASTNode)fieldDeclaration));
        AstNodeUtilsTest.assertEquals((long)(fieldDeclaration.getStartPosition() + fieldDeclaration.getLength()), (long)AstNodeUtils.getSourceEnd((ASTNode)fieldDeclaration));
    }

    @Test
    public void test_setSourceBegin() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int newBegin = 555;
        int oldLength = fieldDeclaration.getLength();
        AstNodeUtils.setSourceBegin((ASTNode)fieldDeclaration, (int)newBegin);
        AstNodeUtilsTest.assertEquals((long)newBegin, (long)fieldDeclaration.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)oldLength, (long)fieldDeclaration.getLength());
    }

    @Test
    public void test_setSourceBegin_keepEnd() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("");
        SimpleName node = typeDeclaration.getAST().newSimpleName("node");
        node.setSourceRange(10, 20);
        AstNodeUtils.setSourceBegin_keepEnd((ASTNode)node, (int)15);
        AstNodeUtilsTest.assertEquals((long)15L, (long)node.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)15L, (long)node.getLength());
    }

    @Test
    public void test_setSourceEnd() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        SimpleName sourceNode = (SimpleName)this.getNode("m_value");
        SimpleName targetNode = typeDeclaration.getAST().newSimpleName("foo");
        targetNode.setSourceRange(10, 0);
        AstNodeUtils.setSourceEnd((ASTNode)targetNode, (ASTNode)sourceNode);
        AstNodeUtilsTest.assertEquals((long)10L, (long)targetNode.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)AstNodeUtils.getSourceEnd((ASTNode)sourceNode), (long)AstNodeUtils.getSourceEnd((ASTNode)targetNode));
    }

    @Test
    public void test_setSourceLength() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        int newLength = 50;
        int oldPosition = fieldDeclaration.getStartPosition();
        AstNodeUtils.setSourceLength((ASTNode)fieldDeclaration, (int)newLength);
        AstNodeUtilsTest.assertEquals((long)oldPosition, (long)fieldDeclaration.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)newLength, (long)fieldDeclaration.getLength());
    }

    @Test
    public void test_copySourceRange() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        SimpleName targetNode = typeDeclaration.getAST().newSimpleName("foo");
        AstNodeUtils.copySourceRange((ASTNode)targetNode, (ASTNode)fieldDeclaration);
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getStartPosition(), (long)targetNode.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getLength(), (long)targetNode.getLength());
    }

    @Test
    public void test_setSourceRange_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName targetNode = typeDeclaration.getAST().newSimpleName("foo");
        AstNodeUtils.setSourceRange((ASTNode)targetNode, (ASTNode)fieldDeclaration.getType(), (ASTNode)fragment.getName());
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getStartPosition(), (long)targetNode.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)(fieldDeclaration.getLength() - ";".length()), (long)targetNode.getLength());
    }

    @Test
    public void test_setSourceRange_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        SimpleName targetNode = typeDeclaration.getAST().newSimpleName("foo");
        AstNodeUtils.setSourceRange((ASTNode)targetNode, (ASTNode)fieldDeclaration.getType(), (ASTNode)fragment.getName(), (int)1);
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getStartPosition(), (long)targetNode.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getLength(), (long)targetNode.getLength());
    }

    @Test
    public void test_setSourceRange_3() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        SimpleName targetNode = typeDeclaration.getAST().newSimpleName("foo");
        AstNodeUtils.setSourceRange((ASTNode)targetNode, (ASTNode)fieldDeclaration, (int)1);
        AstNodeUtilsTest.assertEquals((long)fieldDeclaration.getStartPosition(), (long)targetNode.getStartPosition());
        AstNodeUtilsTest.assertEquals((long)(fieldDeclaration.getLength() + 1), (long)targetNode.getLength());
    }

    @Test
    public void test_moveNode() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        final LinkedList ranges = new LinkedList();
        fieldDeclaration.accept(new ASTVisitor(){

            public void preVisit(ASTNode node) {
                ranges.add(node.getStartPosition());
                ranges.add(node.getLength());
            }
        });
        int targetPosition = 1;
        final int delta = targetPosition - fieldDeclaration.getStartPosition();
        AstNodeUtils.moveNode((ASTNode)fieldDeclaration, (int)targetPosition);
        fieldDeclaration.accept(new ASTVisitor(){

            public void preVisit(ASTNode node) {
                AstNodeUtilsTest.assertEquals(ranges.removeFirst(), (Object)(node.getStartPosition() - delta));
                AstNodeUtilsTest.assertEquals(ranges.removeFirst(), (Object)node.getLength());
            }
        });
    }

    @Test
    public void test_comparators() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){int a; int b; int c;}");
        Statement[] statements = DomGenerics.statements((Block)typeDeclaration.getMethods()[0].getBody());
        Statement statement_1 = (Statement)statements.get(0);
        Statement statement_2 = (Statement)statements.get(1);
        Statement statement_3 = (Statement)statements.get(2);
        statements = new Statement[]{statement_1, statement_3, statement_2};
        Arrays.sort(statements, AstNodeUtils.SORT_BY_POSITION);
        AstNodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new Statement[]{statement_1, statement_2, statement_3}, (Object)statements));
        Arrays.sort(statements, AstNodeUtils.SORT_BY_REVERSE_POSITION);
        AstNodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new Statement[]{statement_3, statement_2, statement_1}, (Object)statements));
    }

    @Test
    public void test_isDangling() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("void foo(){int a; int b; int c;}");
        MethodDeclaration method = typeDeclaration.getMethods()[0];
        Statement statement = (Statement)method.getBody().statements().get(0);
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isDanglingNode((ASTNode)statement));
        this.m_lastEditor.removeStatement(statement);
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isDanglingNode((ASTNode)statement));
    }

    @Test
    public void test_contains() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("int a; int b;");
        FieldDeclaration field_1 = typeDeclaration.getFields()[0];
        FieldDeclaration field_2 = typeDeclaration.getFields()[1];
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.contains((ASTNode)field_1, (ASTNode)field_1.getType()));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.contains((ASTNode)field_1, (ASTNode)field_2));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.contains((ASTNode)field_1, (ASTNode)field_1));
    }

    @Test
    public void test_removeDanglingNodes() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", AstNodeUtilsTest.getSource("package test;", "public class Test {", "  int field_1;", "  int field_2;", "}"));
        FieldDeclaration field_1 = typeDeclaration.getFields()[0];
        FieldDeclaration field_2 = typeDeclaration.getFields()[1];
        ArrayList fields = Lists.newArrayList((Object[])new FieldDeclaration[]{field_1, field_2});
        Assertions.assertThat((List)fields).containsExactly((Object[])new FieldDeclaration[]{field_1, field_2});
        AstNodeUtils.removeDanglingNodes((Iterable)fields);
        Assertions.assertThat((List)fields).containsExactly((Object[])new FieldDeclaration[]{field_1, field_2});
        this.m_lastEditor.removeBodyDeclaration((BodyDeclaration)field_1);
        Assertions.assertThat((List)fields).containsExactly((Object[])new FieldDeclaration[]{field_1, field_2});
        AstNodeUtils.removeDanglingNodes((Iterable)fields);
        Assertions.assertThat((List)fields).containsExactly((Object[])new FieldDeclaration[]{field_2});
    }

    @Test
    public void test_isLiteral_simple() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    int var = 1;", "    System.out.println(true);", "    System.out.println(123);", "    System.out.println('abc');", "    Object valueNull = null; // 1", "    Object valueCastNull = (Object) null; // 2", "    System.out.println(java.util.Collections.EMPTY_LIST);", "    System.out.println(var);", "  }", "}"));
        BooleanLiteral booleanLiteral = (BooleanLiteral)this.m_lastEditor.getEnclosingNode("true");
        NumberLiteral numberLiteral = (NumberLiteral)this.m_lastEditor.getEnclosingNode("123");
        StringLiteral stringLiteral = (StringLiteral)this.m_lastEditor.getEnclosingNode("abc");
        NullLiteral nullLiteral = (NullLiteral)this.m_lastEditor.getEnclosingNode("null; // 1");
        CastExpression castNullNode = (CastExpression)this.m_lastEditor.getEnclosingNode("(Object) null; // 2");
        QualifiedName qualifiedName = (QualifiedName)this.m_lastEditor.getEnclosingNode("EMPTY_LIST").getParent();
        SimpleName varNode = (SimpleName)this.m_lastEditor.getEnclosingNode("var)");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)booleanLiteral));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)numberLiteral));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)stringLiteral));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)nullLiteral));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)castNullNode));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)qualifiedName));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.isLiteral((Expression)varNode));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.areLiterals(Collections.emptyList()));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.areLiterals(List.of(booleanLiteral, numberLiteral)));
        AstNodeUtilsTest.assertFalse((boolean)AstNodeUtils.areLiterals(List.of(booleanLiteral, varNode)));
    }

    @Test
    public void test_isLiteral_complex() throws Exception {
        this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "    int var = 1;", "    System.out.println(-123);", "    System.out.println(+123);", "    System.out.println(1 + 2 + 3);", "  }", "}"));
        Expression negativeExpression = (Expression)this.m_lastEditor.getEnclosingNode("-123");
        Expression positiveExpression = (Expression)this.m_lastEditor.getEnclosingNode("+123");
        Expression sumExpression = (Expression)this.m_lastEditor.getEnclosingNode("+ 2");
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)negativeExpression));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)positiveExpression));
        AstNodeUtilsTest.assertTrue((boolean)AstNodeUtils.isLiteral((Expression)sumExpression));
    }

    @Test
    public void test_getPackageName_defaultPackage() throws Exception {
        CompilationUnit unit = this.createASTCompilationUnit("", "Test.java", AstNodeUtilsTest.getSourceDQ("public class Test {", "  // filler filler filler", "}"));
        AstNodeUtilsTest.assertEquals((Object)"", (Object)AstNodeUtils.getPackageName((CompilationUnit)unit));
    }

    @Test
    public void test_getPackageName_qualifiedPackage() throws Exception {
        CompilationUnit unit = this.createASTCompilationUnit("test", "Test.java", AstNodeUtilsTest.getSourceDQ("package com.foo.bar;", "public class Test {", "  // filler filler filler", "}"));
        AstNodeUtilsTest.assertEquals((Object)"com.foo.bar", (Object)AstNodeUtils.getPackageName((CompilationUnit)unit));
    }
}

