/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.util.ObjectsTreeContentProvider;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class ObjectsTreeContentProviderTest
extends DesignerTestCase {
    @Test
    public void test() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        parent.addChild(child_1);
        parent.addChild(child_2);
        Predicate<ObjectInfo> predicate = t -> t != child_2;
        ObjectsTreeContentProvider contentProvider = new ObjectsTreeContentProvider(predicate);
        Assertions.assertThat((Object[])contentProvider.getElements((Object)new Object[]{parent})).containsOnly(new Object[]{parent});
        Assertions.assertThat((Object[])contentProvider.getElements((Object)parent)).containsOnly(new Object[]{child_1});
        ObjectsTreeContentProviderTest.assertTrue((boolean)contentProvider.hasChildren((Object)parent));
        ObjectsTreeContentProviderTest.assertFalse((boolean)contentProvider.hasChildren((Object)child_1));
        Assertions.assertThat((Object[])contentProvider.getChildren((Object)parent)).containsOnly(new Object[]{child_1});
        ObjectsTreeContentProviderTest.assertSame((Object)((Object)parent), (Object)contentProvider.getParent((Object)child_1));
        contentProvider.inputChanged(null, null, (Object)parent);
        contentProvider.dispose();
    }
}

