/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class IntegerPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        IntegerPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)IntegerPropertyEditor.INSTANCE, Property.UNKNOWN_VALUE);
        IntegerPropertyEditorTest.assert_getText("123", (TextDisplayPropertyEditor)IntegerPropertyEditor.INSTANCE, 123);
    }

    @Test
    public void test_getEditorText() throws Exception {
        IntegerPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)IntegerPropertyEditor.INSTANCE, Property.UNKNOWN_VALUE);
        IntegerPropertyEditorTest.assert_getEditorText("123", (TextDisplayPropertyEditor)IntegerPropertyEditor.INSTANCE, 123);
    }

    @Test
    public void test_setEditorText_setValue() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerPropertyEditorTest.setTextEditorText(property, "123");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123);", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        IntegerPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareIntegerPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                IntegerPropertyEditorTest.setTextEditorText(property, "notInteger");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("foo").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareIntegerPanel() throws Exception {
        IntegerPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(int foo) {", "  }", "}"));
        IntegerPropertyEditorTest.waitForAutoBuild();
    }
}

