/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.awt.Container;
import java.awt.Frame;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.RootAssociation;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.util.PlaceholderUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.annotations.WaitForAutoBuildAfter;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class SwingParserTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noToolkit() throws Exception {
        try {
            this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    Object justSomeCreation = new Object();", "  }", "}");
            SwingParserTest.fail();
        }
        catch (DesignerException e) {
            SwingParserTest.assertEquals((long)103L, (long)e.getCode());
        }
    }

    @Test
    public void test_bad_DataBean() throws Exception {
        try {
            this.parseContainer("public class Test {", "  private String m_name;", "  public String getName() {", "    return m_name;", "  }", "  public void setName(String name) {", "    m_name = name;", "  }", "}");
            SwingParserTest.fail();
        }
        catch (DesignerException e) {
            SwingParserTest.assertEquals((long)111L, (long)e.getCode());
            SwingParserTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
    }

    @Test
    public void test_emptyMain() throws Exception {
        try {
            this.parseContainer("class Test {", "  JButton button; // just to have reference on Swing", "  public static void main(String[] args) {", "  }", "}");
            SwingParserTest.fail();
        }
        catch (Throwable e_) {
            NoEntryPointError e = (NoEntryPointError)DesignerExceptionUtils.getRootCause((Throwable)e_);
            SwingParserTest.assertNotNull((Object)e.getEditor());
            SwingParserTest.assertNotNull((Object)e.getTypeDeclaration());
        }
    }

    @Test
    public void test_noMain() throws Exception {
        try {
            this.parseContainer("// filler filler filler", "public class Test {", "  JButton button; // just to have reference on Swing", "}");
            SwingParserTest.fail();
        }
        catch (NoEntryPointError e) {
            SwingParserTest.assertNotNull((Object)e.getEditor());
            SwingParserTest.assertNotNull((Object)e.getTypeDeclaration());
        }
    }

    @Test
    public void test_noRootComponent_withCompilationErrors() throws Exception {
        try {
            this.m_ignoreCompilationProblems = true;
            this.parseContainer("// filler filler filler", "public class Test {", "  JPanel panel; // just to have reference on Swing", "  public static void main(String[] args) {", "    JButton button = new JButton() // note, no ';' at the end", "  }", "}");
            SwingParserTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            SwingParserTest.assertEquals((long)101L, (long)de.getCode());
        }
    }

    @Test
    public void test_goodSuperClass_useConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public void Test() {", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_parse_unknownSuperClassForAnonymous() throws Exception {
        this.m_ignoreCompilationProblems = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public void Test() {", "    new UnknownType() {};", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_severalConstructors_useDefault() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  public Test(int a) {", "  }", "}");
    }

    @Test
    public void test_severalConstructors_noDefault() throws Exception {
        try {
            this.parseContainer("public class Test extends JPanel {", "  public Test(double a) {", "  }", "  public Test(int a) {", "  }", "}");
            SwingParserTest.fail();
        }
        catch (MultipleConstructorsError e) {
            SwingParserTest.assertNotNull((Object)e.getEditor());
            SwingParserTest.assertNotNull((Object)e.getTypeDeclaration());
        }
    }

    @Test
    public void test_EventQueue_invokeLater() throws Exception {
        this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    EventQueue.invokeLater(new Runnable() {", "      public void run() {", "        new Test();", "      }", "    });", "  }", "  public Test() {", "    JFrame frame = new JFrame();", "  }", "}");
    }

    @Test
    public void test_SwingUtilities_invokeLater() throws Exception {
        this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    SwingUtilities.invokeLater(new Runnable() {", "      public void run() {", "        new Test();", "      }", "    });", "  }", "  public Test() {", "    JFrame frame = new JFrame();", "  }", "}");
    }

    @Test
    public void test_EventQueue_invokeAndWait() throws Exception {
        this.parseContainer("public class Test {", "  public static void main(String[] args) throws Exception {", "    EventQueue.invokeAndWait(new Runnable() {", "      public void run() {", "        new Test();", "      }", "    });", "  }", "  public Test() {", "    JFrame frame = new JFrame();", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JFrame} {local-unique: frame} {/new JFrame()/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_SwingUtilities_invokeAndWait() throws Exception {
        this.parseContainer("public class Test {", "  public static void main(String[] args) throws Exception {", "    SwingUtilities.invokeAndWait(new Runnable() {", "      public void run() {", "        new Test();", "      }", "    });", "  }", "  public Test() {", "    JFrame frame = new JFrame();", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JFrame} {local-unique: frame} {/new JFrame()/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_entryPointTag_forConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public Test() {", "    JPanel panel = new JPanel();", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_entryPointTag_forMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public void foo() {", "    JPanel panel = new JPanel();", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
        panel.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public void foo() {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_alwaysTryConstructor_success() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public Test() {", "    JPanel panel = new JPanel();", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_alwaysTryConstructor_fail() throws Exception {
        try {
            this.parseContainer("public class Test {", "  JButton button; // just to have reference on Swing", "  public Test() {", "  }", "}");
            SwingParserTest.fail();
        }
        catch (Throwable e_) {
            Throwable e = DesignerExceptionUtils.getRootCause((Throwable)e_);
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(NoEntryPointError.class);
        }
    }

    @Test
    public void test_panelButton_1a() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    {", "      JButton button = new JButton();", "      button.setText(\"New button\");", "      panel.add(button);", "    }", "  }", "}");
        SwingParserTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)panel.getCreationSupport());
        SwingParserTest.assertInstanceOf(RootAssociation.class, (Object)panel.getAssociation());
        SwingParserTest.assertSame(JPanel.class, (Object)panel.getDescription().getComponentClass());
        SwingParserTest.assertEquals((Object)"org.eclipse.wb.swing", (Object)panel.getDescription().getToolkit().getId());
        SwingParserTest.assertEquals((Object)"Swing toolkit", (Object)panel.getDescription().getToolkit().getName());
        SwingParserTest.assertTrue((panel.getDescription().toString().length() != 0 ? 1 : 0) != 0);
        SwingParserTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "panel.add(button)"});
        SwingParserTest.assertEquals((long)2L, (long)panel.getChildrenJava().size());
        SwingParserTest.assertTrue((boolean)(panel.getChildrenJava().get(0) instanceof FlowLayoutInfo));
        ContainerInfo button = (ContainerInfo)panel.getChildrenJava().get(1);
        CreationSupport creationSupport = button.getCreationSupport();
        SwingParserTest.assertTrue((boolean)(creationSupport instanceof ConstructorCreationSupport));
        SwingParserTest.assertSame(JButton.class, (Object)button.getDescription().getComponentClass());
        SwingParserTest.assertRelatedNodes((JavaInfo)button, new String[]{"new JButton()", "button.setText(\"New button\")", "panel.add(button)"});
    }

    @Test
    public void test_panelButton_1b() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    createButton(panel);", "  }", "  private static void createButton(Container parent) {", "    JButton button = new JButton();", "    button.setText(\"New button\");", "    parent.add(button);", "  }", "}");
        SwingParserTest.assertRelatedNodes((JavaInfo)panel, new String[]{"new JPanel()", "parent.add(button)", "createButton(panel)"});
        SwingParserTest.assertEquals((long)2L, (long)panel.getChildrenJava().size());
        SwingParserTest.assertTrue((boolean)(panel.getChildrenJava().get(0) instanceof FlowLayoutInfo));
        ContainerInfo button = (ContainerInfo)panel.getChildrenJava().get(1);
        SwingParserTest.assertRelatedNodes((JavaInfo)button, new String[]{"new JButton()", "button.setText(\"New button\")", "parent.add(button)"});
        SwingParserTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_panelButton_2() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      button.setText(\"New button\");", "      panel.add(button, BorderLayout.WEST);", "    }", "  }", "}");
        SwingParserTest.assertEquals((long)2L, (long)panel.getChildrenJava().size());
        SwingParserTest.assertTrue((boolean)(panel.getChildrenJava().get(0) instanceof BorderLayoutInfo));
        SwingParserTest.assertTrue((boolean)(panel.getLayout() instanceof BorderLayoutInfo));
        SwingParserTest.assertTrue((boolean)(panel.getChildrenJava().get(1) instanceof ContainerInfo));
        final boolean[] objectWasSet = new boolean[1];
        panel.addBroadcastListener((Object)new JavaInfoSetObjectAfter(){

            public void invoke(JavaInfo target, Object o) throws Exception {
                if (target == panel) {
                    objectWasSet[0] = true;
                }
            }
        });
        SwingParserTest.assertFalse((boolean)objectWasSet[0]);
        SwingParserTest.assert_creation((JavaInfo)panel);
        panel.refresh();
        SwingParserTest.assertTrue((boolean)objectWasSet[0]);
    }

    @Test
    public void test_parse_defaultPackage() throws Exception {
        SwingParserTest.setFileContentSrc("MyButton.java", SwingParserTest.getSource("// filler filler filler", "// filler filler filler", "public class MyButton extends javax.swing.JButton {", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = (ContainerInfo)this.parseSource("", "Test.java", SwingParserTest.getSource("public class Test extends javax.swing.JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}"));
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: MyButton} {empty} {/add(new MyButton())/}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_canBeRoot() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  public Test() {", "    setBackground(Color.green);", "    Button button = new Button(\"My button\");", "  }", "}");
        SwingParserTest.assertTrue((boolean)(frame.getCreationSupport() instanceof ThisCreationSupport));
    }

    @Test
    public void test_severalRoots() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  public Test() {", "    setBackground(Color.green);", "    JButton button = new JButton(\"My button\");", "  }", "}");
        SwingParserTest.assertTrue((boolean)(frame.getCreationSupport() instanceof ThisCreationSupport));
    }

    @Test
    public void test_localConstructor() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("class Test {", "  private JFrame frame;", "  public static void main(String[] args) {", "    Test window = new Test();", "    window.frame.setVisible(true);", "  }", "  public Test() {", "    initialize();", "  }", "  private void initialize() {", "    frame = new JFrame();", "    frame.setEnabled(false);", "  }", "}");
        frame.refresh();
        SwingParserTest.assertFalse((boolean)((JFrame)frame.getObject()).isEnabled());
    }

    @Test
    public void test_constructorEvaluation_goodActual_success() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "    setText('A');", "  }", "  public MyButton(int value) {", "    setText('B');", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton(0));", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton(0))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/add(new MyButton(0))/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        SwingParserTest.assertEquals((Object)"B", (Object)((JButton)button.getObject()).getText());
        SwingParserTest.assertNoErrors((JavaInfo)panel);
        SwingParserTest.assertFalse((boolean)button.isPlaceholder());
        Assertions.assertThat((List)PlaceholderUtils.getExceptions((JavaInfo)button)).isEmpty();
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_goodDefault_success() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "    setText('A');", "  }", "  public MyButton(int value) {", "    setText('B');", "    throw new IllegalStateException('actual');", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton(0));", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton(0))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/add(new MyButton(0))/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        SwingParserTest.assertEquals((Object)"A", (Object)((JButton)button.getObject()).getText());
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        ASTNode node = badNode.getNode();
        Throwable e = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        SwingParserTest.assertEquals((Object)"new MyButton(0)", (Object)this.m_lastEditor.getSource(node));
        Assertions.assertThat((Throwable)e).isExactlyInstanceOf(IllegalStateException.class);
        SwingParserTest.assertEquals((Object)e.getMessage(), (Object)"actual");
        SwingParserTest.assertFalse((boolean)button.isPlaceholder());
        Assertions.assertThat((List)PlaceholderUtils.getExceptions((JavaInfo)button)).hasSize(1);
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_sameDefault() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "    throw new IllegalStateException('actual');", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        SwingParserTest.assertInstanceOf(JPanel.class, button.getObject());
        SwingParserTest.assertTrue((boolean)button.isPlaceholder());
        Assertions.assertThat((List)PlaceholderUtils.getExceptions((JavaInfo)button)).hasSize(1);
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        ASTNode node = badNode.getNode();
        Throwable e = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        SwingParserTest.assertEquals((Object)"new MyButton()", (Object)this.m_lastEditor.getSource(node));
        Assertions.assertThat((Throwable)e).isExactlyInstanceOf(IllegalStateException.class);
        SwingParserTest.assertEquals((Object)e.getMessage(), (Object)"actual");
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_exceptionDefault() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "    throw new IllegalStateException('default');", "  }", "  public MyButton(int value) {", "    throw new IllegalStateException('actual');", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton(0));", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton(0))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/add(new MyButton(0))/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        SwingParserTest.assertInstanceOf(JPanel.class, button.getObject());
        SwingParserTest.assertTrue((boolean)button.isPlaceholder());
        Assertions.assertThat((List)PlaceholderUtils.getExceptions((JavaInfo)button)).hasSize(2);
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(2);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        ASTNode node = badNode.getNode();
        Throwable e = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        SwingParserTest.assertEquals((Object)"new MyButton(0)", (Object)this.m_lastEditor.getSource(node));
        Assertions.assertThat((Throwable)e).isExactlyInstanceOf(IllegalStateException.class);
        SwingParserTest.assertEquals((Object)e.getMessage(), (Object)"actual");
        badNode = (EditorState.BadNodeInformation)badNodes.get(1);
        node = badNode.getNode();
        e = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        SwingParserTest.assertEquals((Object)"new MyButton(0)", (Object)this.m_lastEditor.getSource(node));
        Assertions.assertThat((Throwable)e).isExactlyInstanceOf(IllegalStateException.class);
        SwingParserTest.assertEquals((Object)e.getMessage(), (Object)"default");
    }

    @Test
    public void test_constructorEvaluation_standardComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('abc'));", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton('abc'))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton('abc'))/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        SwingParserTest.assertEquals((Object)"abc", (Object)((JButton)button.getObject()).getText());
    }

    @Test
    public void test_windowsDisposing() throws Exception {
        this.parseContainer("// filler filler filler", "class Test extends JFrame {", "  Test() {", "    setVisible(true);", "  }", "}");
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            Frame frame = frames[i];
            SwingParserTest.assertFalse((boolean)frame.isVisible());
            ++i;
        }
    }

    @Test
    public void test_compilationErrors_undefinedMethod() throws Exception {
        this.m_ignoreCompilationProblems = true;
        try {
            ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    initData();", "  }", "}");
            SwingParserTest.assertNotNull((Object)panel);
        }
        finally {
            this.m_ignoreCompilationProblems = false;
            SwingParserTest.do_projectDispose();
        }
    }

    @Test
    public void test_unknownClass() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    Integer integer = new Integer(0);", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).isEmpty();
    }

    @WaitForAutoBuildAfter
    @Test
    public void test_nonStaticInnerClass() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyPanel());", "  }", "  public class MyPanel extends JPanel {", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).isEmpty();
    }

    @Test
    public void test_abstractStandardSwingClass() throws Exception {
        ContainerInfo component = this.parseContainer("public class Test extends JComponent {", "  public Test() {", "    // filler filler filler", "  }", "}");
        SwingParserTest.assertSame((Object)component.getDescription().getComponentClass(), Container.class);
        component.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)component);
    }

    @WaitForAutoBuildAfter
    @Test
    public void test_ignoreInterfaces() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    Border border = BorderFactory.createEtchedBorder();", "    setBorder(border);", "  }", "  public class MyPanel extends JPanel {", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_newAnonymousClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton() {};", "    add(button);", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_execute_addMethod() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add(Container container) {", "    super.add(container);", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        SwingParserTest.assertHierarchy("{this: test.MyPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_execute_addMethod_withConstraints() throws Exception {
        SwingParserTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add(Component component, String title) {", "    super.add(component);", "  }", "}"));
        SwingParserTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add(new JButton(), 'title');", "  }", "}");
        SwingParserTest.assertHierarchy("{this: test.MyPanel} {this} {/add(new JButton(), 'title')/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton(), 'title')/}");
    }

    @Test
    public void test_SuperMethodInvocation_association() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    super.setLayout(new GridBagLayout());", "  }", "}");
        SwingParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/}", "  {new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}");
        this.refresh();
        SwingParserTest.assertInstanceOf("java.awt.GridBagLayout", (Object)panel.getContainer().getLayout());
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
    }

    @Test
    public void test_JList_new_ObjectArray() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList((Object[]) null);", "    add(list);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JList_new_Vector() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList((java.util.Vector) null);", "    add(list);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JList_setListData_ObjectArray() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    list.setListData((Object[]) null);", "    add(list);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JList_setListData_Vector() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    list.setListData((java.util.Vector) null);", "    add(list);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_setModel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox();", "    combo.setModel(null);", "    add(combo);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_constructor_ComboBoxModel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox((javax.swing.ComboBoxModel) null);", "    add(combo);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_constructor_Objects() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox((Object[]) null);", "    add(combo);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_constructor_Generic() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox<String> combo = new JComboBox<>((String[]) null);", "    add(combo);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_constructor_Vector() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox((java.util.Vector) null);", "    add(combo);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_JComboBox_setRenderer_anonymous() throws Exception {
        SwingParserTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox();", "    add(combo);", "    combo.setRenderer(new ListCellRenderer() {", "      public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {", "        return null;", "      }", "    });", "  }", "}");
        panel.refresh();
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        Throwable rootException = DesignerExceptionUtils.getRootCause((Throwable)badNode.getException());
        Assertions.assertThat((Throwable)rootException).isExactlyInstanceOf(AnonymousEvaluationError.class);
        Assertions.assertThat((String)this.m_lastEditor.getSource(badNode.getNode())).startsWith((CharSequence)"new ListCellRenderer() {");
        JComboBox combo = (JComboBox)((ComponentInfo)panel.getChildrenComponents().get(0)).getComponent();
        SwingParserTest.assertNotNull(combo.getRenderer());
    }

    @Test
    public void test_JComboBox_setRenderer_null() throws Exception {
        SwingParserTest.useStrictEvaluationMode(false);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JComboBox combo = new JComboBox();", "    add(combo);", "    combo.setRenderer(null);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
        JComboBox combo = (JComboBox)((ComponentInfo)panel.getChildrenComponents().get(0)).getComponent();
        SwingParserTest.assertNotNull(combo.getRenderer());
    }

    @Test
    public void test_AbstractButton_setModel_null() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    button.setModel(null);", "  }", "}");
        panel.refresh();
        SwingParserTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_preferredRoot_singlePreferred() throws Exception {
        this.setJavaContentSrc("test", "MyPanel", new String[]{"public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parser.preferredRoot'>true</parameter>", "  </parameters>", "</component>"});
        this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    MyPanel myPanel = new MyPanel();", "    //", "    JPanel panel = new JPanel();", "    panel.add(new JButton());", "    panel.add(new JButton());", "    panel.add(new JButton());", "  }", "}");
        SwingParserTest.assertHierarchy("{new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_preferredRoot_twoPreferred() throws Exception {
        this.setJavaContentSrc("test", "MyPanel", new String[]{"public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parser.preferredRoot'>true</parameter>", "  </parameters>", "</component>"});
        this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    MyPanel panel_1 = new MyPanel();", "    //", "    MyPanel panel_2 = new MyPanel();", "    panel_2.add(new JButton());", "  }", "}");
        SwingParserTest.assertHierarchy("{new: test.MyPanel} {local-unique: panel_2} {/new MyPanel()/ /panel_2.add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/panel_2.add(new JButton())/}");
    }

    @Test
    public void test_preferredRoot_useEndOfLineComment() throws Exception {
        this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel myPanel = new JPanel(); // @wbp.parser.preferredRoot", "    //", "    JPanel panel = new JPanel();", "    panel.add(new JButton());", "    panel.add(new JButton());", "    panel.add(new JButton());", "  }", "}");
        SwingParserTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: myPanel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_eventListeners() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    addKeyListener(new KeyAdapter() {});", "  }", "}");
        SwingParserTest.assertEquals((long)1L, (long)panel.getRelatedNodes().size());
        ASTNode relatedNode = (ASTNode)panel.getRelatedNodes().get(0);
        SwingParserTest.assertTrue((boolean)this.m_lastEditor.getSource(relatedNode).contains("addKeyListener"));
    }
}

