/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public abstract class SimpleContainerAbstractGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE_filled() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton existingButton = new JButton();\n\t\t\t\tpanel.setContent(existingButton);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_canvas_CREATE_empty() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        Object newButton = this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"New button\");\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        this.canvas.assertPrimarySelected(newButton);
    }

    @Ignore
    @Test
    public void test_canvas_PASTE() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton rootButton = new JButton(\"A\");\n\t\t\tadd(rootButton, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.select(rootButton);
        IAction copyAction = this.getCopyAction();
        SimpleContainerAbstractGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        SimpleContainerAbstractGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.moveTo((Object)panel, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"A\");\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton rootButton = new JButton(\"A\");\n\t\t\tadd(rootButton, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ComponentInfo newButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(newButton);
    }

    @Test
    public void test_canvas_ADD_1() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton rootButton = new JButton();\n\t\t\tadd(rootButton, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.beginDrag(rootButton).dragTo(panel);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNotNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton rootButton = new JButton();\n\t\t\t\tpanel.setContent(rootButton);\n\t\t\t}\n\t\t}\n\t}\n}");
        this.canvas.assertPrimarySelected(rootButton);
    }

    @Test
    public void test_canvas_ADD_2() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        ComponentInfo button_2 = (ComponentInfo)mainPanel.getChildrenComponents().get(2);
        this.canvas.select(button_2, button_1);
        this.canvas.beginDrag(button_1, 100, 5).dragTo((Object)panel, 10, 10);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_filled_1() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton existingButton = new JButton();\n\t\t\t\tpanel.setContent(existingButton);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveBefore(existingButton);
        this.tree.assertFeedback_before(existingButton);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_filled_2() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton existingButton = new JButton();\n\t\t\t\tpanel.setContent(existingButton);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_empty() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        Object newButton = this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"New button\");\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        this.tree.assertPrimarySelected(newButton);
    }

    @Ignore
    @Test
    public void test_tree_PASTE() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton rootButton = new JButton(\"A\");\n\t\t\tadd(rootButton, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.select(rootButton);
        IAction copyAction = this.getCopyAction();
        SimpleContainerAbstractGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        SimpleContainerAbstractGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"A\");\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton rootButton = new JButton(\"A\");\n\t\t\tadd(rootButton, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ComponentInfo newButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(newButton);
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.tree.startDrag(button);
        this.tree.dragOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_ADD() throws Exception {
        this.prepareSimplePanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.tree.startDrag(button);
        this.tree.dragOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tSimplePanel panel = new SimplePanel();\n\t\t\tadd(panel);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel.setContent(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        this.tree.assertPrimarySelected(button);
    }

    protected abstract void prepareSimplePanel() throws Exception;
}

