/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;
import org.mockito.Mockito;

public class CreationDescriptionTest
extends DesignerTestCase {
    private static final ImageDescriptor TYPE_ICON = ImageDescriptor.createFromImageDataProvider(zoom -> new ImageData(1, 1, 32, new PaletteData(0, 0, 0)));
    private static final ImageDescriptor CREATION_ICON = ImageDescriptor.createFromImageDataProvider(zoom -> new ImageData(1, 1, 32, new PaletteData(0, 0, 0)));

    @Test
    public void test_defaultComponentDescription() throws Exception {
        ComponentDescriptionKey key = new ComponentDescriptionKey(JButton.class);
        ComponentDescription component = new ComponentDescription(key);
        CreationDescriptionTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getDescription());
        ComponentDescription component2 = new ComponentDescription(null);
        CreationDescriptionTest.assertNull((Object)component2.getDescription());
    }

    @Test
    public void test_newExplicitName() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        CreationDescriptionTest.assertEquals((Object)"myId", (Object)creation.getId());
        CreationDescriptionTest.assertEquals((Object)"myName", (Object)creation.getName());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_newImplicitName() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", null);
        CreationDescriptionTest.assertEquals((Object)"myId", (Object)creation.getId());
        CreationDescriptionTest.assertEquals((Object)"JButton", (Object)creation.getName());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_fromComponentDescription() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        Mockito.when((Object)component.getIcon()).thenReturn((Object)TYPE_ICON);
        Mockito.when((Object)component.getDescription()).thenReturn((Object)"type description");
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        CreationDescriptionTest.assertSame((Object)TYPE_ICON, (Object)creation.getIcon());
        CreationDescriptionTest.assertEquals((Object)"type description", (Object)creation.getDescription());
        CreationDescriptionTest.assertNull((Object)creation.getSource());
        CreationDescriptionTest.assertEquals((long)0L, (long)creation.getInvocations().size());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        ((ComponentDescription)Mockito.verify((Object)component)).getIcon();
        ((ComponentDescription)Mockito.verify((Object)component)).getDescription();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_specificIconDescription() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        creation.setIcon(CREATION_ICON);
        CreationDescriptionTest.assertSame((Object)CREATION_ICON, (Object)creation.getIcon());
        creation.setDescription("creation description");
        CreationDescriptionTest.assertEquals((Object)"creation description", (Object)creation.getDescription());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_normalizeDescription() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        creation.setDescription("creation \r\n     \t  description");
        CreationDescriptionTest.assertEquals((Object)"creation description", (Object)creation.getDescription());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_source() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        creation.setSource("new javax.swing.JButton()");
        CreationDescriptionTest.assertEquals((Object)"new javax.swing.JButton()", (Object)creation.getSource());
        creation.setSource("new %component.class%()");
        CreationDescriptionTest.assertEquals((Object)"new javax.swing.JButton()", (Object)creation.getSource());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_getSource_innerClass() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        class MyInnerClass {
            MyInnerClass() {
            }
        }
        Mockito.when((Object)component.getComponentClass()).thenReturn(MyInnerClass.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        creation.setSource("new %component.class%()");
        CreationDescriptionTest.assertEquals((Object)("new " + ReflectionUtils.getCanonicalName(MyInnerClass.class) + "()"), (Object)creation.getSource());
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_invocations() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        CreationDescriptionTest.assertEquals((long)0L, (long)creation.getInvocations().size());
        CreationInvocationDescription invocation = new CreationInvocationDescription();
        invocation.setSignature("setText(java.lang.String)");
        invocation.setArguments("\"my text\"");
        creation.addInvocation(invocation);
        List invocations = creation.getInvocations();
        CreationDescriptionTest.assertEquals((long)1L, (long)invocations.size());
        CreationDescriptionTest.assertTrue((boolean)invocations.contains(invocation));
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }

    @Test
    public void test_specificParameters() throws Exception {
        ComponentDescription component = (ComponentDescription)Mockito.mock(ComponentDescription.class);
        Mockito.when((Object)component.getComponentClass()).thenReturn(JButton.class);
        CreationDescription creation = new CreationDescription(component, "myId", "myName");
        CreationDescriptionTest.assertTrue((boolean)creation.getParameters().isEmpty());
        creation.addParameter("name_1", "value_1");
        creation.addParameter("name_2", "value_2");
        Assertions.assertThat((Map)creation.getParameters()).contains(new Map.Entry[]{MapEntry.entry((Object)"name_1", (Object)"value_1"), MapEntry.entry((Object)"name_2", (Object)"value_2")});
        ((ComponentDescription)Mockito.verify((Object)component)).getComponentClass();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{component});
    }
}

