/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.preference.IPreferenceStore;

public final class PreferencesRepairer {
    private final IPreferenceStore m_preferences;
    private final Map<String, Object> m_nameToValue = new TreeMap<String, Object>();

    public PreferencesRepairer(IPreferenceStore preferences) {
        this.m_preferences = preferences;
    }

    public void setValue(String name, boolean value) {
        this.save(name, this.m_preferences.getBoolean(name));
        this.m_preferences.setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.save(name, this.m_preferences.getInt(name));
        this.m_preferences.setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.save(name, this.m_preferences.getString(name));
        this.m_preferences.setValue(name, value);
    }

    private void save(String name, Object value) {
        if (!this.m_nameToValue.containsKey(name)) {
            this.m_nameToValue.put(name, value);
        }
    }

    public void restore() {
        for (Map.Entry<String, Object> entry : this.m_nameToValue.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                this.m_preferences.setValue(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                this.m_preferences.setValue(name, ((Integer)value).intValue());
                continue;
            }
            if (!(value instanceof String)) continue;
            this.m_preferences.setValue(name, (String)value);
        }
    }
}

