/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.IAdaptableFactory;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;
import org.mockito.Mockito;

public class MenuObjectInfoUtilsTest
extends DesignerTestCase {
    private static IMenuItemInfo m_tmpItemInfo;

    @Test
    public void test_setSelectingObject_menuObject() throws Exception {
        IMenuObjectInfo object = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        MenuObjectInfoUtils.setSelectingObject((IMenuObjectInfo)object);
        MenuObjectInfoUtilsTest.assertSame((Object)object, (Object)MenuObjectInfoUtils.m_selectingObject);
    }

    @Test
    public void test_setSelectingObject_pureObject() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuItemInfo itemInfo = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        Mockito.when((Object)((IMenuObjectInfo)object.getAdapter(IMenuObjectInfo.class))).thenReturn((Object)itemInfo);
        MenuObjectInfoUtils.setSelectingObject((Object)object);
        MenuObjectInfoUtilsTest.assertSame((Object)itemInfo, (Object)MenuObjectInfoUtils.m_selectingObject);
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuObjectInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{itemInfo});
    }

    @Test
    public void test_getMenuObjectInfo_1() throws Exception {
        Object object = Mockito.mock(Object.class);
        MenuObjectInfoUtilsTest.assertNull((Object)MenuObjectInfoUtils.getMenuObjectInfo((Object)object));
        Mockito.verifyNoInteractions((Object[])new Object[]{object});
    }

    @Test
    public void test_getMenuObjectInfo_2() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuItemInfo itemInfo = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        Mockito.when((Object)((IMenuObjectInfo)object.getAdapter(IMenuObjectInfo.class))).thenReturn((Object)itemInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)itemInfo, (Object)MenuObjectInfoUtils.getMenuObjectInfo((Object)object));
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuObjectInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{itemInfo});
    }

    @Test
    public void test_getMenuObjectInfo_3() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuInfo menuInfo = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)((IMenuObjectInfo)object.getAdapter(IMenuObjectInfo.class))).thenReturn((Object)menuInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)menuInfo, (Object)MenuObjectInfoUtils.getMenuObjectInfo((Object)object));
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuObjectInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{menuInfo});
    }

    @Test
    public void test_getMenuItemInfo_1() throws Exception {
        Object object = Mockito.mock(Object.class);
        MenuObjectInfoUtilsTest.assertNull((Object)MenuObjectInfoUtils.getMenuItemInfo((Object)object));
        Mockito.verifyNoInteractions((Object[])new Object[]{object});
    }

    @Test
    public void test_getMenuItemInfo_2() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuItemInfo itemInfo = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        Mockito.when((Object)((IMenuItemInfo)object.getAdapter(IMenuItemInfo.class))).thenReturn((Object)itemInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)itemInfo, (Object)MenuObjectInfoUtils.getMenuItemInfo((Object)object));
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuItemInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{itemInfo});
    }

    @Test
    public void test_getMenuItemInfo_3() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        m_tmpItemInfo = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        String pointId = "org.eclipse.wb.core.adaptableFactories";
        String contribution = "  <factory class='" + MyAdaptableFactory.class.getName() + "'/>";
        TestUtils.addDynamicExtension(pointId, contribution);
        try {
            MenuObjectInfoUtilsTest.assertSame((Object)m_tmpItemInfo, (Object)MenuObjectInfoUtils.getMenuItemInfo((Object)object));
            ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuItemInfo.class);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
            Mockito.verifyNoInteractions((Object[])new Object[]{m_tmpItemInfo});
        }
        finally {
            TestUtils.removeDynamicExtension(pointId);
        }
    }

    @Test
    public void test_getMenuInfo_1() throws Exception {
        Object object = Mockito.mock(Object.class);
        MenuObjectInfoUtilsTest.assertNull((Object)MenuObjectInfoUtils.getMenuInfo((Object)object));
        Mockito.verifyNoInteractions((Object[])new Object[]{object});
    }

    @Test
    public void test_getMenuInfo_2() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuInfo menuInfo = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)((IMenuInfo)object.getAdapter(IMenuInfo.class))).thenReturn((Object)menuInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)menuInfo, (Object)MenuObjectInfoUtils.getMenuInfo((Object)object));
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{menuInfo});
    }

    @Test
    public void test_getMenuPopupInfo_1() throws Exception {
        Object object = Mockito.mock(Object.class);
        MenuObjectInfoUtilsTest.assertNull((Object)MenuObjectInfoUtils.getMenuPopupInfo((Object)object));
        Mockito.verifyNoInteractions((Object[])new Object[]{object});
    }

    @Test
    public void test_getMenuPopupInfo_2() throws Exception {
        IAdaptable object = (IAdaptable)Mockito.mock(IAdaptable.class);
        IMenuPopupInfo popupInfo = (IMenuPopupInfo)Mockito.mock(IMenuPopupInfo.class);
        Mockito.when((Object)((IMenuPopupInfo)object.getAdapter(IMenuPopupInfo.class))).thenReturn((Object)popupInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)popupInfo, (Object)MenuObjectInfoUtils.getMenuPopupInfo((Object)object));
        ((IAdaptable)Mockito.verify((Object)object)).getAdapter(IMenuPopupInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        Mockito.verifyNoInteractions((Object[])new Object[]{popupInfo});
    }

    @Test
    public void test_getSubMenu_1() throws Exception {
        IMenuInfo menuInfo = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        MenuObjectInfoUtilsTest.assertNull((Object)MenuObjectInfoUtils.getSubMenu((IMenuObjectInfo)menuInfo));
        Mockito.verifyNoInteractions((Object[])new Object[]{menuInfo});
    }

    @Test
    public void test_getSubMenu_2() throws Exception {
        IMenuPopupInfo popupInfo = (IMenuPopupInfo)Mockito.mock(IMenuPopupInfo.class);
        IMenuInfo menuInfo = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)popupInfo.getMenu()).thenReturn((Object)menuInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)menuInfo, (Object)MenuObjectInfoUtils.getSubMenu((IMenuObjectInfo)popupInfo));
        ((IMenuPopupInfo)Mockito.verify((Object)popupInfo)).getMenu();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{popupInfo});
        Mockito.verifyNoInteractions((Object[])new Object[]{menuInfo});
    }

    @Test
    public void test_getSubMenu_3() throws Exception {
        IMenuItemInfo itemInfo = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        IMenuInfo menuInfo = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)itemInfo.getMenu()).thenReturn((Object)menuInfo);
        MenuObjectInfoUtilsTest.assertSame((Object)menuInfo, (Object)MenuObjectInfoUtils.getSubMenu((IMenuObjectInfo)itemInfo));
        ((IMenuItemInfo)Mockito.verify((Object)itemInfo)).getMenu();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{itemInfo});
        Mockito.verifyNoInteractions((Object[])new Object[]{menuInfo});
    }

    @Test
    public void test_isParentChild_null() throws Exception {
        IMenuObjectInfo parent = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        IMenuObjectInfo child = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        MenuObjectInfoUtilsTest.assertFalse((boolean)MenuObjectInfoUtils.isParentChild(null, null));
        Mockito.verifyNoInteractions((Object[])new Object[]{parent});
        Mockito.verifyNoInteractions((Object[])new Object[]{child});
        MenuObjectInfoUtilsTest.assertFalse((boolean)MenuObjectInfoUtils.isParentChild(null, (IMenuObjectInfo)child));
        Mockito.verifyNoInteractions((Object[])new Object[]{parent});
        Mockito.verifyNoInteractions((Object[])new Object[]{child});
        MenuObjectInfoUtilsTest.assertFalse((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)parent, null));
        Mockito.verifyNoInteractions((Object[])new Object[]{parent});
        Mockito.verifyNoInteractions((Object[])new Object[]{child});
    }

    @Test
    public void test_isParentChild_genericObjects() throws Exception {
        IMenuObjectInfo parent = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        IMenuObjectInfo child = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        MenuObjectInfoUtilsTest.assertFalse((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)parent, (IMenuObjectInfo)child));
        Mockito.verifyNoInteractions((Object[])new Object[]{parent});
        Mockito.verifyNoInteractions((Object[])new Object[]{child});
    }

    @Test
    public void test_isParentChild_hit() throws Exception {
        IMenuObjectInfo object = (IMenuObjectInfo)Mockito.mock(IMenuObjectInfo.class);
        MenuObjectInfoUtilsTest.assertTrue((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)object, (IMenuObjectInfo)object));
        Mockito.verifyNoInteractions((Object[])new Object[]{object});
    }

    @Test
    public void test_isParentChild_popupWithMenu() throws Exception {
        IMenuPopupInfo popup = (IMenuPopupInfo)Mockito.mock(IMenuPopupInfo.class);
        IMenuInfo menu = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)popup.getMenu()).thenReturn((Object)menu);
        MenuObjectInfoUtilsTest.assertTrue((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)popup, (IMenuObjectInfo)menu));
        ((IMenuPopupInfo)Mockito.verify((Object)popup)).getMenu();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{popup});
        Mockito.verifyNoInteractions((Object[])new Object[]{menu});
    }

    @Test
    public void test_isParentChild_itemWithMenu() throws Exception {
        IMenuItemInfo item = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        IMenuInfo menu = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        Mockito.when((Object)item.getMenu()).thenReturn((Object)menu);
        MenuObjectInfoUtilsTest.assertTrue((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)item, (IMenuObjectInfo)menu));
        ((IMenuItemInfo)Mockito.verify((Object)item)).getMenu();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{item});
        Mockito.verifyNoInteractions((Object[])new Object[]{menu});
    }

    @Test
    public void test_isParentChild_menuWithItems() throws Exception {
        IMenuInfo menu = (IMenuInfo)Mockito.mock(IMenuInfo.class);
        IMenuItemInfo item_1 = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        IMenuItemInfo item_2 = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        IMenuItemInfo item_3 = (IMenuItemInfo)Mockito.mock(IMenuItemInfo.class);
        List<IMenuItemInfo> items = List.of(item_1, item_2, item_3);
        Mockito.when((Object)menu.getItems()).thenReturn(items);
        Mockito.when((Object)item_1.getMenu()).thenReturn(null);
        MenuObjectInfoUtilsTest.assertTrue((boolean)MenuObjectInfoUtils.isParentChild((IMenuObjectInfo)menu, (IMenuObjectInfo)item_2));
        ((IMenuInfo)Mockito.verify((Object)menu)).getItems();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{menu});
        ((IMenuItemInfo)Mockito.verify((Object)item_1)).getMenu();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{item_1});
        Mockito.verifyNoInteractions((Object[])new Object[]{item_2});
        Mockito.verifyNoInteractions((Object[])new Object[]{item_3});
    }

    public static final class MyAdaptableFactory
    implements IAdaptableFactory {
        public <T> T getAdapter(Object object, Class<T> adapter) {
            MenuObjectInfoUtilsTest.assertSame(IMenuItemInfo.class, adapter);
            return adapter.cast(m_tmpItemInfo);
        }
    }
}

