/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.spring;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SpringLayoutGefTest
extends SwingGefTest {
    private ContainerInfo panel;
    private ComponentInfo box;
    private ComponentInfo anchor;
    private ComponentInfo boxA;
    private ComponentInfo boxB;
    private ComponentInfo boxC;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            SpringLayoutGefTest.do_projectCreate();
        }
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        preferenceStore.setValue("P_COMPONENT_GAP_LEFT", 5);
        preferenceStore.setValue("P_COMPONENT_GAP_RIGHT", 5);
        preferenceStore.setValue("P_COMPONENT_GAP_TOP", 5);
        preferenceStore.setValue("P_COMPONENT_GAP_BOTTOM", 5);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Field[] fieldArray = ((Object)((Object)this)).getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.set((Object)this, null);
            ++n2;
        }
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        preferenceStore.setToDefault("P_COMPONENT_GAP_LEFT");
        preferenceStore.setToDefault("P_COMPONENT_GAP_RIGHT");
        preferenceStore.setToDefault("P_COMPONENT_GAP_TOP");
        preferenceStore.setToDefault("P_COMPONENT_GAP_BOTTOM");
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_absoluteNoSnap_topLeft() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).inY(50).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteNoSnap_bottomRight() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(250).inY(200).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.SOUTH, box, -50, SpringLayout.SOUTH, this);", "      layout.putConstraint(SpringLayout.EAST, box, -100, SpringLayout.EAST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_leftOffset() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(2).inY(50).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_leftZero() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).outX(-2).inY(50).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 0, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_rightOffset() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).rightSide().inX(-2).inY(50).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.EAST, box, -10, SpringLayout.EAST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_rightZero() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).rightSide().outX(2).inY(50).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.EAST, box, 0, SpringLayout.EAST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_topOffset() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).inY(2).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_topZero() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).outY(-2).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 0, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_bottomOffset() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).bottomSide().inY(-2).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, -10, SpringLayout.SOUTH, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_absoluteSnap_bottomZero() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).bottomSide().outY(2).move().click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, 0, SpringLayout.SOUTH, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_ansoluteNoSnap_andResize_absoluteNoSnap() throws Exception {
        this.prepare_CREATE_emptyPanel();
        this.canvas.target(this.panel).inX(30).inY(50).move();
        this.canvas.beginDrag().dragOn(100, 50).endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 30, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, 125, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.EAST, box, 180, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    private void prepare_CREATE_emptyPanel() throws Exception {
        this.prepareBox();
        this.parse_forCREATE("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "  }", "}");
        this.loadCreationBox();
    }

    private void parse_forCREATE(String ... lines) throws Exception {
        this.panel = this.openContainer(lines);
        this.canvas.create(100, 50).sideMode();
    }

    @Test
    public void test_CREATE_anchor_TL2TR() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(-1).inY(-1).move();
        this.canvas.sideMode().target(this.anchor).outX(2).inY(2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.NORTH, box, 0, SpringLayout.NORTH, anchor);", "      layout.putConstraint(SpringLayout.WEST, box, 5, SpringLayout.EAST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_TL2BL() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(-1).inY(-1).move();
        this.canvas.sideMode().target(this.anchor).outX(-2).outY(2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.NORTH, box, 5, SpringLayout.SOUTH, anchor);", "      layout.putConstraint(SpringLayout.WEST, box, 0, SpringLayout.WEST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_TL2BL_indent() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(-1).inY(-1).move();
        this.canvas.sideMode().target(this.anchor).inX(10).outY(2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.NORTH, box, 5, SpringLayout.SOUTH, anchor);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_TL2BL_indent2() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.target(this.anchor).outX(50).outY(50).move();
        this.canvas.target(this.anchor).inX(12).outY(2).move();
        this.canvas.click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.NORTH, box, 5, SpringLayout.SOUTH, anchor);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_TR2TL() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(1).inY(-1).move();
        this.canvas.sideMode().target(this.anchor).rightSide().outX(-2).inY(2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.NORTH, box, 0, SpringLayout.NORTH, anchor);", "      layout.putConstraint(SpringLayout.EAST, box, -5, SpringLayout.WEST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_BL2BR() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(-1).inY(1).move();
        this.canvas.sideMode().target(this.anchor).outX(2).bottomSide().inY(-2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.WEST, box, 5, SpringLayout.EAST, anchor);", "      layout.putConstraint(SpringLayout.SOUTH, box, 0, SpringLayout.SOUTH, anchor);");
    }

    @Test
    public void test_CREATE_anchor_BL2TL() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(-1).inY(1).move();
        this.canvas.sideMode().target(this.anchor).inX(2).bottomSide().outY(-2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.WEST, box, 0, SpringLayout.WEST, anchor);", "      layout.putConstraint(SpringLayout.SOUTH, box, -5, SpringLayout.NORTH, anchor);");
    }

    @Test
    public void test_CREATE_anchor_BR2BL() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.mouseMode().target(this.panel).inX(1).inY(1).move();
        this.canvas.sideMode().target(this.anchor).rightSide().outX(-2).bottomSide().inY(-2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.SOUTH, box, 0, SpringLayout.SOUTH, anchor);", "      layout.putConstraint(SpringLayout.EAST, box, -5, SpringLayout.WEST, anchor);");
    }

    @Test
    public void test_CREATE_anchor_BR2TR() throws Exception {
        this.prepare_CREATE_singlePanel();
        this.canvas.target(this.panel).inX(10).inY(10).move();
        this.canvas.target(this.anchor).rightSide().inX(-2).bottomSide().outY(-2).move().click();
        this.assert_CREATE_singlePanel("      layout.putConstraint(SpringLayout.SOUTH, box, -5, SpringLayout.NORTH, anchor);", "      layout.putConstraint(SpringLayout.EAST, box, 0, SpringLayout.EAST, anchor);");
    }

    private void prepare_CREATE_singlePanel() throws Exception {
        this.prepareBox();
        this.parse_forCREATE("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    //", "    Box anchor = new Box();", "    layout.putConstraint(SpringLayout.NORTH, anchor, 120, SpringLayout.NORTH, this);", "    layout.putConstraint(SpringLayout.WEST, anchor, 170, SpringLayout.WEST, this);", "    add(anchor);", "  }", "}");
        this.anchor = (ComponentInfo)this.panel.getChildrenComponents().get(0);
        this.loadCreationBox();
    }

    private void assert_CREATE_singlePanel(String ... constraints) throws Exception {
        String[] lines = CodeUtils.join((String[])new String[]{"public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    //", "    Box anchor = new Box();", "    layout.putConstraint(SpringLayout.NORTH, anchor, 120, SpringLayout.NORTH, this);", "    layout.putConstraint(SpringLayout.WEST, anchor, 170, SpringLayout.WEST, this);", "    add(anchor);", "    {", "      Box box = new Box();"}, (String[])constraints);
        lines = CodeUtils.join((String[])lines, (String[])new String[]{"      add(box);", "    }", "  }", "}"});
        this.assertEditor(lines);
    }

    @Test
    public void test_CREATE_withBorder() throws Exception {
        this.prepareBox();
        this.parse_forCREATE("public class Test extends JPanel {", "  public Test() {", "    setBorder(new EmptyBorder(20, 30, 5, 5));", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "  }", "}");
        this.loadCreationBox();
        this.canvas.create(100, 50).sideMode();
        this.canvas.target(this.panel).inX(80).inY(80).move().click();
        int expectedNorth = Expectations.get(Integer.valueOf(60), new Expectations.IntValue("sablin-aa", 60), new Expectations.IntValue("flanker-windows", 60));
        int expectedWest = Expectations.get(Integer.valueOf(50), new Expectations.IntValue("sablin-aa", 50), new Expectations.IntValue("flanker-windows", 50));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setBorder(new EmptyBorder(20, 30, 5, 5));", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, " + expectedNorth + ", SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, " + expectedWest + ", SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_topLeft() throws Exception {
        this.prepare_MOVE("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 20, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
        ComponentInfo source = (ComponentInfo)this.panel.getChildrenComponents().get(0);
        this.canvas.beginMove(source);
        this.canvas.target(this.panel).inX(20).inY(40).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 40, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 20, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_topRight() throws Exception {
        this.prepare_MOVE("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 20, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
        ComponentInfo source = (ComponentInfo)this.panel.getChildrenComponents().get(0);
        this.canvas.beginMove(source);
        this.canvas.target(this.panel).rightSide().inX(-30).inY(40).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 40, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.EAST, box, -30, SpringLayout.EAST, this);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_bottomLeft() throws Exception {
        this.prepare_MOVE("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 20, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
        ComponentInfo source = (ComponentInfo)this.panel.getChildrenComponents().get(0);
        this.canvas.beginMove(source);
        this.canvas.target(this.panel).inX(20).bottomSide().inY(-40).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.WEST, box, 20, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, -40, SpringLayout.SOUTH, this);", "      add(box);", "    }", "  }", "}");
    }

    private void prepare_MOVE(String ... lines) throws Exception {
        this.prepareBox();
        this.panel = this.openContainer(lines);
        this.canvas.sideMode();
    }

    @Test
    public void test_MOVE_andCycles_A() throws Exception {
        this.prepare_MOVE_andCycles();
        this.canvas.beginMove(this.boxA);
        this.canvas.target(this.boxC).outX(30).inY(30).drag();
        this.canvas.target(this.boxC).outX(3).inY(3).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    ", "    Box boxA = new Box();", "    add(boxA);", "    ", "    Box boxB = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxB, 75, SpringLayout.WEST, this);", "    layout.putConstraint(SpringLayout.NORTH, boxA, 0, SpringLayout.NORTH, boxB);", "    add(boxB);", "    ", "    Box boxC = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxA, 5, SpringLayout.EAST, boxC);", "    layout.putConstraint(SpringLayout.WEST, boxC, 5, SpringLayout.EAST, boxB);", "    add(boxC);", "  }", "}");
    }

    @Test
    public void test_MOVE_andCycles_B() throws Exception {
        this.prepare_MOVE_andCycles();
        this.canvas.beginMove(this.boxB);
        this.canvas.rightSide().bottomSide().target(this.panel).inX(-5).inY(-5).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    ", "    Box boxA = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxA, 20, SpringLayout.WEST, this);", "    add(boxA);", "    ", "    Box boxB = new Box();", "    layout.putConstraint(SpringLayout.SOUTH, boxB, -10, SpringLayout.SOUTH, this);", "    layout.putConstraint(SpringLayout.EAST, boxB, -10, SpringLayout.EAST, this);", "    add(boxB);", "    ", "    Box boxC = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxC, 60, SpringLayout.EAST, boxA);", "    add(boxC);", "  }", "}");
    }

    private void prepare_MOVE_andCycles() throws Exception {
        this.prepareBox(50, 20);
        this.panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    ", "    Box boxA = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxA, 20, SpringLayout.WEST, this);", "    add(boxA);", "    ", "    Box boxB = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxB, 5, SpringLayout.EAST, boxA);", "    add(boxB);", "    ", "    Box boxC = new Box();", "    layout.putConstraint(SpringLayout.WEST, boxC, 5, SpringLayout.EAST, boxB);", "    add(boxC);", "  }", "}");
        List components = this.panel.getChildrenComponents();
        this.boxA = (ComponentInfo)components.get(0);
        this.boxB = (ComponentInfo)components.get(1);
        this.boxC = (ComponentInfo)components.get(2);
        this.canvas.sideMode();
    }

    @Test
    public void test_RESIZE_singleTL_absoluteLeft() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 8).dragOn(-50, 0).endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 50, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, box, 200, SpringLayout.WEST, this);");
    }

    @Test
    public void test_RESIZE_singleTL_snapLeftOffset() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 8);
        this.canvas.target(this.panel).inX(12).drag().endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 10, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, box, 200, SpringLayout.WEST, this);");
    }

    @Test
    public void test_RESIZE_singleTL_absoluteRight() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 16).dragOn(50, 0).endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, box, 250, SpringLayout.WEST, this);");
    }

    @Test
    public void test_RESIZE_singleTL_snapRightOffset() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 16);
        this.canvas.target(this.panel).rightSide().inX(-12).drag().endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, box, -10, SpringLayout.EAST, this);");
    }

    @Test
    public void test_RESIZE_singleTL_absoluteTop() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 1).dragOn(0, -50).endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, 150, SpringLayout.NORTH, this);");
    }

    @Test
    public void test_RESIZE_singleTL_snapTopOffset() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 1);
        this.canvas.target(this.panel).inY(12).drag().endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, 150, SpringLayout.NORTH, this);");
    }

    @Test
    public void test_RESIZE_singleTL_absoluteBottom() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 4).dragOn(0, 50).endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, 200, SpringLayout.NORTH, this);");
    }

    @Test
    public void test_RESIZE_singleTL_snapBottomOffset() throws Exception {
        this.prepare_RESIZE_singleTL();
        this.canvas.beginResize(this.box, 4);
        this.canvas.target(this.panel).bottomSide().inY(-12).drag().endDrag();
        this.assert_RESIZE_singleTL("      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, box, -10, SpringLayout.SOUTH, this);");
    }

    private void prepare_RESIZE_singleTL() throws Exception {
        this.prepareBox();
        this.panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();", "      layout.putConstraint(SpringLayout.NORTH, box, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, box, 100, SpringLayout.WEST, this);", "      add(box);", "    }", "  }", "}");
        this.box = (ComponentInfo)this.panel.getChildrenComponents().get(0);
    }

    private void assert_RESIZE_singleTL(String ... constraints) throws Exception {
        String[] lines = CodeUtils.join((String[])new String[]{"public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      Box box = new Box();"}, (String[])constraints);
        lines = CodeUtils.join((String[])lines, (String[])new String[]{"      add(box);", "    }", "  }", "}"});
        this.assertEditor(lines);
    }
}

