/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import org.eclipse.wb.core.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryEditCommand;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryRemoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.ElementVisibilityCommand;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.Test;

public class CategoryCommandsTest
extends AbstractPaletteTest {
    @Test
    public void test_add_last() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("new id", "new name", "new description", true, true, null));
        manager.commands_write();
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryInfo category = palette.getCategory("new id");
        CategoryCommandsTest.assertEquals((Object)"new name", (Object)category.getName());
        CategoryCommandsTest.assertEquals((Object)"new description", (Object)category.getDescription());
        CategoryCommandsTest.assertTrue((boolean)category.isVisible());
        CategoryCommandsTest.assertTrue((boolean)category.isOpen());
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        category = palette.getCategory("new id");
        CategoryCommandsTest.assertNotNull((Object)category);
        CategoryCommandsTest.assertEquals((Object)"new name", (Object)category.getName());
        CategoryCommandsTest.assertEquals((Object)"new description", (Object)category.getDescription());
        CategoryCommandsTest.assertTrue((boolean)category.isVisible());
        CategoryCommandsTest.assertTrue((boolean)category.isOpen());
    }

    @Test
    public void test_add_before() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        manager.commands_add((Command)new CategoryAddCommand("1", "1", "1", true, true, "0"));
        manager.commands_write();
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
    }

    @Test
    public void test_add_specialCharacters() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("id", "name\nsecond line", "description", true, true, null));
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryInfo category = palette.getCategory("id");
        CategoryCommandsTest.assertEquals((Object)"name\nsecond line", (Object)category.getName());
    }

    @Test
    public void test_edit() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryInfo category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category.getName());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category.getDescription());
        CategoryCommandsTest.assertTrue((boolean)category.isVisible());
        CategoryCommandsTest.assertTrue((boolean)category.isOpen());
        manager.commands_add((Command)new CategoryEditCommand("0", "name", "description", false, false));
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"name", (Object)category.getName());
        CategoryCommandsTest.assertEquals((Object)"description", (Object)category.getDescription());
        CategoryCommandsTest.assertFalse((boolean)category.isVisible());
        CategoryCommandsTest.assertFalse((boolean)category.isOpen());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"name", (Object)category.getName());
        CategoryCommandsTest.assertEquals((Object)"description", (Object)category.getDescription());
        CategoryCommandsTest.assertFalse((boolean)category.isVisible());
        CategoryCommandsTest.assertFalse((boolean)category.isOpen());
    }

    @Test
    public void test_edit_twoTimes() throws Exception {
        PaletteManager manager = this.loadManager();
        List commands = (List)ReflectionUtils.getFieldObject((Object)manager, (String)"m_commands");
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        CategoryCommandsTest.assertEquals((long)1L, (long)commands.size());
        CategoryInfo category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category.getName());
        manager.commands_add((Command)new CategoryEditCommand("0", "1", "1", false, false));
        CategoryCommandsTest.assertEquals((long)2L, (long)commands.size());
        category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"1", (Object)category.getName());
        manager.commands_add((Command)new CategoryEditCommand("0", "2", "2", false, false));
        CategoryCommandsTest.assertEquals((long)2L, (long)commands.size());
        category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"2", (Object)category.getName());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        category = palette.getCategory("0");
        CategoryCommandsTest.assertEquals((Object)"2", (Object)category.getName());
    }

    @Test
    public void test_move_before() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        manager.commands_add((Command)new CategoryAddCommand("1", "1", "1", true, true, null));
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryInfo category_0 = (CategoryInfo)palette.getCategories().get(0);
        CategoryInfo category_1 = (CategoryInfo)palette.getCategories().get(1);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category_0.getId());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)category_1.getId());
        manager.commands_add((Command)new CategoryMoveCommand(category_1, category_0));
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
    }

    @Test
    public void test_move_last() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        manager.commands_add((Command)new CategoryAddCommand("1", "1", "1", true, true, null));
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryInfo category_0 = (CategoryInfo)palette.getCategories().get(0);
        CategoryInfo category_1 = (CategoryInfo)palette.getCategories().get(1);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category_0.getId());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)category_1.getId());
        manager.commands_add((Command)new CategoryMoveCommand(category_0, null));
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
    }

    @Test
    public void test_move_noop() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryInfo category_0 = (CategoryInfo)palette.getCategories().get(0);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category_0.getId());
        manager.commands_add((Command)new CategoryMoveCommand(category_0, category_0));
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
    }

    @Test
    public void test_move_noSource() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        manager.commands_add((Command)new CategoryAddCommand("1", "1", "1", true, true, null));
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryInfo category_0 = (CategoryInfo)palette.getCategories().get(0);
        CategoryInfo category_1 = (CategoryInfo)palette.getCategories().get(1);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category_0.getId());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)category_1.getId());
        CategoryMoveCommand moveCommand = new CategoryMoveCommand(category_0, null);
        ReflectionUtils.getFieldByName(CategoryMoveCommand.class, (String)"m_id").set(moveCommand, "no-such-category");
        manager.commands_add((Command)moveCommand);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)2L, (long)palette.getCategories().size());
        CategoryCommandsTest.assertEquals((Object)"0", (Object)((CategoryInfo)palette.getCategories().get(0)).getId());
        CategoryCommandsTest.assertEquals((Object)"1", (Object)((CategoryInfo)palette.getCategories().get(1)).getId());
    }

    @Test
    public void test_remove() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        CategoryCommandsTest.assertEquals((long)1L, (long)palette.getCategories().size());
        CategoryInfo category_0 = (CategoryInfo)palette.getCategories().get(0);
        CategoryCommandsTest.assertEquals((Object)"0", (Object)category_0.getId());
        manager.commands_add((Command)new CategoryRemoveCommand(category_0));
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        CategoryCommandsTest.assertEquals((long)0L, (long)palette.getCategories().size());
    }

    @Test
    public void test_visibility() throws Exception {
        PaletteManager manager = this.loadManager();
        manager.commands_add((Command)new CategoryAddCommand("0", "0", "0", true, true, null));
        CategoryInfo category = manager.getPalette().getCategory("0");
        CategoryCommandsTest.assertTrue((boolean)category.isVisible());
        manager.commands_add((Command)new ElementVisibilityCommand((AbstractElementInfo)category, false));
        CategoryCommandsTest.assertFalse((boolean)category.isVisible());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryCommandsTest.assertFalse((boolean)palette.getCategory("0").isVisible());
    }
}

