/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.StaticFieldPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.variable.EmptyInvocationVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class InvocationChildAssociationTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_invalid_noParentAccess() throws Exception {
        try {
            new InvocationChildAssociation("invalidSource");
            InvocationChildAssociationTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"add(button)", (Object)association.getSource());
        InvocationChildAssociationTest.assertEquals((Object)"add(button)", (Object)this.m_lastEditor.getSource((ASTNode)association.getInvocation()));
        InvocationChildAssociationTest.assertEquals((Object)"add(button);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        MethodDescription methodDescription = association.getDescription();
        InvocationChildAssociationTest.assertNotNull((Object)methodDescription);
        InvocationChildAssociationTest.assertEquals((Object)"add(java.awt.Component)", (Object)methodDescription.getSignature());
    }

    @Test
    public void test_parse_associateOnlyFirstTime() throws Exception {
        InvocationChildAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setButton(JButton button) {", "  }", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", InvocationChildAssociationTest.getSource("<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CONSTRUCTORS -->", "  <methods>", "    <method name='setButton'>", "      <parameter type='javax.swing.JButton' child='true'>", "        <tag name='associateOnlyFirstTime' value='true'/>", "      </parameter>", "    </method>", "  </methods>", "  <!-- PARAMETERS -->", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        InvocationChildAssociationTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel panel_1 = new MyPanel();", "    MyPanel panel_2 = new MyPanel();", "    add(panel_1);", "    add(panel_2);", "    //", "    JButton button = new JButton();", "    panel_1.setButton(button);", "    panel_2.setButton(button);", "  }", "}");
        InvocationChildAssociationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(panel_1)/ /add(panel_2)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: panel_1} {/new MyPanel()/ /add(panel_1)/ /panel_1.setButton(button)/}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /panel_1.setButton(button)/ /panel_2.setButton(button)/}", "  {new: test.MyPanel} {local-unique: panel_2} {/new MyPanel()/ /add(panel_2)/ /panel_2.setButton(button)/}");
    }

    @Test
    public void test_addProperties_noProperty() throws Exception {
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void addChild(Component component, Object constraints) {", "    add(component);", "  }", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.wbp-component.xml", InvocationChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='java.awt.Component' child='true'/>", "      <parameter type='java.lang.Object'/>", "    </method>", "  </methods>", "</component>"));
        InvocationChildAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild(new JButton(), new Object());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property associationProperty = button.getPropertyByTitle("Association");
        InvocationChildAssociationTest.assertNull((Object)associationProperty);
    }

    @Test
    public void test_addProperties_hasProperty_1() throws Exception {
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void addChild(String sourceParameterName, Component component) {", "    add(component);", "  }", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.wbp-component.xml", InvocationChildAssociationTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='java.lang.String' name='text' defaultSource='\"default text\"'/>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationChildAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('my text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property associationProperty = button.getPropertyByTitle("Association");
        InvocationChildAssociationTest.assertNotNull((Object)associationProperty);
        InvocationChildAssociationTest.assertTrue((boolean)associationProperty.isModified());
        InvocationChildAssociationTest.assertTrue((boolean)associationProperty.getCategory().isSystem());
        InvocationChildAssociationTest.assertInstanceOf(IComplexPropertyEditor.class, (Object)associationProperty.getEditor());
        InvocationChildAssociationTest.assertSame((Object)associationProperty, (Object)button.getPropertyByTitle("Association"));
        Property[] subProperties = InvocationChildAssociationTest.getSubProperties(associationProperty);
        Property associationSubProperty = InvocationChildAssociationTest.getPropertyByTitle(subProperties, "text");
        InvocationChildAssociationTest.assertNotNull((Object)associationSubProperty);
        InvocationChildAssociationTest.assertInstanceOf(StringPropertyEditor.class, (Object)associationSubProperty.getEditor());
        InvocationChildAssociationTest.assertTrue((boolean)associationSubProperty.isModified());
        InvocationChildAssociationTest.assertEquals((Object)"my text", (Object)associationSubProperty.getValue());
        associationSubProperty.setValue((Object)"new text");
        this.assertEditor("public class Test extends MyContainer {", "  public Test() {", "    addChild('new text', new JButton());", "  }", "}");
        associationSubProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends MyContainer {", "  public Test() {", "    addChild('default text', new JButton());", "  }", "}");
    }

    @Test
    public void test_addProperties_hasProperty_2() throws Exception {
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void addChild(String mySecretName, Component component) {", "    add(component);", "  }", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.wbp-component.xml", InvocationChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationChildAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('my text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property associationSubProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Association/mySecretName");
        InvocationChildAssociationTest.assertNotNull((Object)associationSubProperty);
        InvocationChildAssociationTest.assertInstanceOf(StringPropertyEditor.class, (Object)associationSubProperty.getEditor());
    }

    @Test
    public void test_addProperties_hasProperty_3() throws Exception {
        InvocationChildAssociationTest.setFileContentSrc("test/MyEnum.java", InvocationChildAssociationTest.getSourceDQ("package test;", "public class MyEnum {", "  public static final int A = 1;", "  public static final int B = 2;", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void addChild(int position, Component component) {", "    add(component);", "  }", "}"));
        InvocationChildAssociationTest.setFileContentSrc("test/MyContainer.wbp-component.xml", InvocationChildAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='int'>", "        <editor id='staticField'>", "          <parameter name='class'>test.MyEnum</parameter>", "          <parameter name='fields'>A B</parameter>", "        </editor>", "      </parameter>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationChildAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild(MyEnum.A, new JButton());", "  }", "}");
        panel.refresh();
        InvocationChildAssociationTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property associationSubProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Association/position");
        InvocationChildAssociationTest.assertNotNull((Object)associationSubProperty);
        InvocationChildAssociationTest.assertInstanceOf(StaticFieldPropertyEditor.class, (Object)associationSubProperty.getEditor());
        InvocationChildAssociationTest.assertEquals((Object)1, (Object)associationSubProperty.getValue());
        InvocationChildAssociationTest.assertEquals((Object)"A", (Object)InvocationChildAssociationTest.getPropertyText(associationSubProperty));
    }

    @Test
    public void test_remove() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociationTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_remove_whenNoParentVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JButton button = new JButton();", "    new JPanel().add(button);", "  }", "}");
        InvocationChildAssociationTest.assertHierarchy("{new: javax.swing.JPanel} {empty} {/new JPanel().add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /new JPanel().add(button)/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        InvocationChildAssociationTest.assertHierarchy("{new: javax.swing.JPanel} {local-unique: panel} {/new JPanel()/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_morph() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo oldButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociation oldAssociation = (InvocationChildAssociation)oldButton.getAssociation();
        InvocationChildAssociation newAssociation = (InvocationChildAssociation)oldAssociation.getCopy();
        InvocationChildAssociationTest.assertSame((Object)oldAssociation.getInvocation(), (Object)newAssociation.getInvocation());
    }

    @Test
    public void test_add() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("javax.swing.JButton"), (CreationSupport)new ConstructorCreationSupport());
        flowLayout.add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"add(button)", (Object)association.getSource());
    }

    @Test
    public void test_add_emptyVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = InvocationChildAssociationTest.createJButton();
        JavaInfoUtils.add((JavaInfo)button, (VariableSupport)new EmptyInvocationVariableSupport((JavaInfo)button, "%parent%.add(%child%)", 0), (StatementGenerator)PureFlatStatementGenerator.INSTANCE, (AssociationObject)AssociationObjects.invocationChildNull(), (JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
    }

    @Test
    public void test_moveInner() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        FlowLayoutInfo panelLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panelLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"add(button)", (Object)association.getSource());
    }

    @Test
    public void test_moveInner_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        FlowLayoutInfo panelLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panelLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"add(getButton())", (Object)association.getSource());
    }

    @Test
    public void test_moveInner_lazy_withConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "    JLabel constraints = new JLabel();", "    add(getButton(), constraints);", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        panel.refresh();
        FlowLayoutInfo panelLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)InvocationChildAssociationTest.getJavaInfoByName("button");
        ComponentInfo reference = (ComponentInfo)InvocationChildAssociationTest.getJavaInfoByName("container");
        panelLayout.move(button, reference);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    JLabel constraints = new JLabel();", "    add(getButton(), constraints);", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"add(getButton(), constraints)", (Object)association.getSource());
    }

    @Test
    public void test_moveReparent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JPanel container = new JPanel();", "      add(container);", "    }", "  }", "}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo containerLayout = (FlowLayoutInfo)container.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        containerLayout.move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel container = new JPanel();", "      add(container);", "      {", "        JButton button = new JButton();", "        container.add(button);", "      }", "    }", "  }", "}");
        InvocationChildAssociation association = (InvocationChildAssociation)button.getAssociation();
        InvocationChildAssociationTest.assertSame((Object)button, (Object)association.getJavaInfo());
        InvocationChildAssociationTest.assertEquals((Object)"container.add(button)", (Object)association.getSource());
    }
}

