/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.layout.FormData;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.ComponentClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.layout.absolute.OrderingSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImpl;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.actions.PredefinedAnchorsActions;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class FormLayoutInfo
extends LayoutInfo
implements IFormLayoutInfo<ControlInfo> {
    private final FormLayoutInfoImpl<ControlInfo> impl;
    private final FormLayoutPreferences<ControlInfo> preferences;

    public FormLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.preferences = new FormLayoutPreferences<ControlInfo>(this, (ToolkitDescription)description.getToolkit());
        this.addBroadcastListeners();
        this.impl = this.getPreferences().useClassic() ? new FormLayoutInfoImplClassic<ControlInfo>(this) : new FormLayoutInfoImplAutomatic<ControlInfo>(this);
    }

    private void addBroadcastListeners() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (FormLayoutInfo.this.isManagedObject(object)) {
                    ControlInfo control = (ControlInfo)object;
                    FormLayoutInfo.this.contributeControlContextMenu(manager, control);
                }
            }
        });
    }

    public static FormDataInfo getFormData(ControlInfo control) {
        return (FormDataInfo)FormLayoutInfo.getLayoutData(control);
    }

    protected FormData getDefaultVirtualDataObject() throws Exception {
        return new FormData();
    }

    private void contributeControlContextMenu(IMenuManager manager, final ControlInfo control) {
        List<ControlInfo> controls = this.getComposite().getChildrenControls();
        new OrderingSupport(controls, (IAbstractComponentInfo)control).contributeActions(manager);
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)control, ModelMessages.FormLayoutInfo_autoSize, Activator.getImageDescriptor("info/layout/FormLayout/fit_to_size.png")){

            protected void runEx() throws Exception {
                FormLayoutInfo.this.doAutoSize(control);
            }
        };
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IAction)action);
        MenuManager predefinedMenuManager = new MenuManager(ModelMessages.FormLayoutInfo_quickConstraints);
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IContributionItem)predefinedMenuManager);
        new PredefinedAnchorsActions<ControlInfo>(this).contributeActions(control, (IContributionManager)predefinedMenuManager);
    }

    private void doAutoSize(ControlInfo control) throws Exception {
        this.doAutoSize(this.getAttachment(control, 1), this.getAttachment(control, 4));
        this.doAutoSize(this.getAttachment(control, 8), this.getAttachment(control, 32));
        FormDataInfo formData = FormLayoutInfo.getFormData(control);
        formData.getPropertyByTitle("width").setValue(Property.UNKNOWN_VALUE);
        formData.getPropertyByTitle("height").setValue(Property.UNKNOWN_VALUE);
    }

    private void doAutoSize(FormAttachmentInfo leading, FormAttachmentInfo trailing) throws Exception {
        if (!leading.isVirtual() && !trailing.isVirtual()) {
            if (leading.isParentTrailing() || trailing.getControl() != null && trailing.getOffset() <= 0) {
                leading.delete();
            } else {
                trailing.delete();
            }
        }
    }

    @Override
    public void commandMove(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_MOVE(control, nextControl);
    }

    @Override
    public void commandCreate(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_CREATE(control, nextControl);
    }

    @Override
    protected void clipboardCopy_addCompositeCommands(List<ClipboardCommand> commands) throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            if (JavaInfoUtils.isImplicitlyCreated((JavaInfo)control)) continue;
            commands.add((ClipboardCommand)new LayoutClipboardCommand<FormLayoutInfo>(control){
                private static final long serialVersionUID = 0L;

                @Override
                protected void add(FormLayoutInfo layout, ControlInfo control) throws Exception {
                    layout.command_CREATE(control, null);
                }
            });
        }
        List<ControlInfo> childrenControls = this.getComposite().getChildrenControls();
        int i = 0;
        while (i < childrenControls.size()) {
            ControlInfo control = childrenControls.get(i);
            if (!JavaInfoUtils.isImplicitlyCreated((JavaInfo)control)) {
                FormDataInfo formData = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
                final FormAttachmentInfo.FormAttachmentClipboardInfo left = formData.getAttachment(1).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo right = formData.getAttachment(4).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo top = formData.getAttachment(8).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo bottom = formData.getAttachment(32).getClipboardInfo();
                final int index = i;
                commands.add((ClipboardCommand)new ComponentClipboardCommand<CompositeInfo>(){
                    private static final long serialVersionUID = 0L;

                    public void execute(CompositeInfo _thisComposite) throws Exception {
                        ControlInfo control = _thisComposite.getChildrenControls().get(index);
                        FormDataInfo _thisFormData = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
                        _thisFormData.getAttachment(1).applyClipboardInfo(control, left);
                        _thisFormData.getAttachment(4).applyClipboardInfo(control, right);
                        _thisFormData.getAttachment(8).applyClipboardInfo(control, top);
                        _thisFormData.getAttachment(32).applyClipboardInfo(control, bottom);
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public void onSet() throws Exception {
        List<ControlInfo> controls = this.getControls();
        Rectangle parentArea = this.getComposite().getClientArea();
        for (ControlInfo control : controls) {
            Rectangle controlBounds = control.getModelBounds();
            Dimension preferredSize = control.getPreferredSize();
            int x = controlBounds.x - parentArea.x;
            int y = controlBounds.y - parentArea.y;
            int width = controlBounds.width;
            int height = controlBounds.height;
            this.setAttachmentOffset(control, 1, x);
            this.setAttachmentOffset(control, 8, y);
            if (width != preferredSize.width) {
                this.setAttachmentOffset(control, 4, x + width);
            }
            if (height == preferredSize.height) continue;
            this.setAttachmentOffset(control, 32, y + height);
        }
        this.preferences.addPropertyChangeListener();
    }

    @Override
    public void setAttachmentOffset(ControlInfo control, int side, int offset) throws Exception {
        FormDataInfo dataInfo = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
        FormAttachmentInfo attachment = dataInfo.getAttachment(side);
        attachment.setNumerator(0);
        attachment.setDenominator(100);
        attachment.setOffset(offset);
        attachment.write();
    }

    @Override
    public FormLayoutInfoImpl<ControlInfo> getImpl() {
        return this.impl;
    }

    private FormAttachmentInfo getAttachment(ControlInfo widget, int side) throws Exception {
        FormDataInfo layoutData = FormLayoutInfo.getFormData(widget);
        return layoutData.getAttachment(side);
    }

    @Override
    public final Dimension getContainerSize() {
        CompositeInfo composite = this.getComposite();
        Rectangle compositeBounds = composite.getModelBounds().getCopy();
        Insets clientAreaInsets = composite.getClientAreaInsets();
        compositeBounds.crop(clientAreaInsets);
        Insets marginInsets = FormUtils.getLayoutMargins(this);
        return compositeBounds.crop(marginInsets).getSize();
    }

    @Override
    public void setQuickAnchors(ControlInfo widget, int sides, boolean relative) throws Exception {
        this.setQuickAnchor(widget, 1, relative, (sides & 1) != 0);
        this.setQuickAnchor(widget, 4, relative, (sides & 4) != 0);
        this.setQuickAnchor(widget, 8, relative, (sides & 8) != 0);
        this.setQuickAnchor(widget, 32, relative, (sides & 0x20) != 0);
    }

    private void setQuickAnchor(ControlInfo widget, int side, boolean relative, boolean hasSide) throws Exception {
        if (hasSide) {
            this.anchorToParent(widget, side, side);
        } else if (relative) {
            this.anchorToParentAsPercent(widget, side);
        } else {
            FormAttachmentInfo attachment = this.getAttachment(widget, side);
            if (!attachment.isVirtual()) {
                attachment.delete();
            }
        }
    }

    @Override
    public void anchorToParent(ControlInfo control, int controlSide, int parentSide) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(control, controlSide);
        attachment.setControl((ControlInfo)null);
        attachment.setDenominator(100);
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)controlSide);
        Transposer t = new Transposer(!isHorizontal);
        int margin = isHorizontal ? FormUtils.getLayoutMarginLeft(this) : FormUtils.getLayoutMarginTop(this);
        Rectangle controlBounds = t.t(control.getModelBounds());
        Dimension containerSize = t.t(this.getContainerSize());
        int offset = 0;
        if (!PlacementUtils.isTrailingSide((int)controlSide)) {
            if (PlacementUtils.isTrailingSide((int)parentSide)) {
                attachment.setNumerator(100);
                offset = -(containerSize.width - controlBounds.x) - margin;
            } else {
                attachment.setNumerator(0);
                offset = controlBounds.x - margin;
            }
        } else if (PlacementUtils.isTrailingSide((int)parentSide)) {
            attachment.setNumerator(100);
            offset = -(containerSize.width - controlBounds.right()) - margin;
        } else {
            attachment.setNumerator(0);
            offset = controlBounds.right() - margin;
        }
        attachment.setOffset(offset);
        attachment.write();
    }

    @Override
    public void anchorToParentAsPercent(ControlInfo control, int controlSide) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(control, controlSide);
        attachment.setControl((ControlInfo)null);
        attachment.setDenominator(100);
        attachment.setOffset(0);
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)controlSide);
        Transposer t = new Transposer(!isHorizontal);
        int margin = isHorizontal ? FormUtils.getLayoutMarginLeft(this) : FormUtils.getLayoutMarginTop(this);
        Rectangle controlBounds = t.t(control.getModelBounds());
        Dimension containerSize = t.t(this.getContainerSize());
        if (!PlacementUtils.isTrailingSide((int)controlSide)) {
            attachment.setNumerator((int)(100.0 * (double)(controlBounds.x - margin) / (double)containerSize.width));
        } else {
            attachment.setNumerator((int)(100.0 * (double)(controlBounds.right() - margin) / (double)containerSize.width));
        }
        attachment.write();
    }

    @Override
    public FormLayoutPreferences<ControlInfo> getPreferences() {
        return this.preferences;
    }

    @Override
    public IResource getUnderlyingResource() throws Exception {
        return this.getEditor().getModelUnit().getUnderlyingResource();
    }
}

