/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IASTObjectInfo2;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.BindingContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.SeparatorUiContentProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingModelSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.BindingNameUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ColumnBindingUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ColumnClassUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ColumnNameUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ConverterUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.EditableUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.IEditableProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ValidatorUiContentProvider;

public class ColumnBindingInfo
extends BindingInfo
implements IEditableProvider {
    private static final String SET_EDITABLE = "org.jdesktop.swingbinding.JTableBinding.ColumnBinding.setEditable(boolean)";
    private static final String SET_COLUMN_NAME = "org.jdesktop.swingbinding.JTableBinding.ColumnBinding.setColumnName(java.lang.String)";
    private static final String SET_COLUMN_CLASS = "org.jdesktop.swingbinding.JTableBinding.ColumnBinding.setColumnClass(java.lang.Class)";
    private static ChooseClassConfiguration m_columnClassConfiguration;
    private final JTableBindingInfo m_binding;
    private PropertyInfo m_detailProperty;
    private boolean m_editable = true;
    private int m_column = -1;
    private String m_columnName;
    private IGenericType m_columnType;

    public ColumnBindingInfo(ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty, JTableBindingInfo binding) {
        super(target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty);
        this.m_binding = binding;
    }

    @Override
    public IGenericType getModelPropertyType() {
        if (this.m_detailProperty != null) {
            return this.m_detailProperty.getValueType();
        }
        return super.getModelPropertyType();
    }

    @Override
    public IGenericType getTargetPropertyType() {
        return this.m_columnType == null ? ClassGenericType.OBJECT_CLASS : this.m_columnType;
    }

    @Override
    public boolean isEditable() {
        return this.m_editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void setColumn(int column) {
        this.m_column = column;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setColumnName(String columnName) {
        this.m_columnName = columnName;
    }

    public IGenericType getColumnType() {
        return this.m_columnType;
    }

    public void setColumnType(IGenericType columnType) {
        this.m_columnType = columnType;
    }

    public PropertyInfo getDetailProperty() {
        return this.m_detailProperty;
    }

    public void setDetailProperty(PropertyInfo detailProperty) {
        Assert.isNotNull((Object)((Object)detailProperty));
        this.m_detailProperty = detailProperty;
    }

    public JTableBindingInfo getJTableBinding() {
        return this.m_binding;
    }

    @Override
    public boolean delete(List<BindingInfo> bindings) throws Exception {
        this.m_binding.getColumns().remove(this);
        return true;
    }

    @Override
    public void move(List<BindingInfo> bindings) {
        this.m_binding.getColumns().remove(this);
        int index = bindings.indexOf(this) - bindings.indexOf(this.m_binding) - 1;
        this.m_binding.getColumns().add(index, this);
    }

    @Override
    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        listener.setTitle(Messages.ColumnBindingInfo_listenerTitle);
        listener.setMessage(Messages.ColumnBindingInfo_listenerMessage);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.ColumnBindingInfo_componentLabel, this.m_target.getPresentation().getTextForBinding()));
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.ColumnBindingInfo_modelLabel, this.getModelPresentationText(false)));
        providers.add(new ColumnBindingUiContentProvider(this));
        providers.add((IUiContentProvider)new SeparatorUiContentProvider());
        providers.add((IUiContentProvider)new ColumnNameUiContentProvider(this));
        providers.add((IUiContentProvider)new EditableUiContentProvider(this));
        providers.add((IUiContentProvider)new ColumnClassUiContentProvider(ColumnBindingInfo.createColumnConfiguration(), this));
        providers.add((IUiContentProvider)new ConverterUiContentProvider(this.createConverterConfiguration(), this));
        providers.add((IUiContentProvider)new ValidatorUiContentProvider(this.createValidatorConfiguration(), this));
        providers.add((IUiContentProvider)new BindingNameUiContentProvider(this));
        providers.add((IUiContentProvider)new BindingContentProvider((IASTObjectInfo2)this, provider.getJavaInfoRoot()));
    }

    private static ChooseClassConfiguration createColumnConfiguration() {
        if (m_columnClassConfiguration == null) {
            m_columnClassConfiguration = new ChooseClassConfiguration();
            m_columnClassConfiguration.setDialogFieldLabel(Messages.ColumnBindingInfo_chooseTitle);
            m_columnClassConfiguration.setValueScope("beans");
            m_columnClassConfiguration.setClearValue("N/S");
            m_columnClassConfiguration.setChooseInterfaces(true);
            m_columnClassConfiguration.setEmptyClassErrorMessage(Messages.ColumnBindingInfo_chooseError);
            m_columnClassConfiguration.setErrorMessagePrefix(Messages.ColumnBindingInfo_chooseErrorPrefix);
        }
        return m_columnClassConfiguration;
    }

    @Override
    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        if (SET_EDITABLE.equals(signature)) {
            this.m_editable = (Boolean)CoreUtils.evaluate(Boolean.class, (AstEditor)editor, (Expression)arguments[0]);
            this.configureModelSupport(invocation, resolver);
            return null;
        }
        if (SET_COLUMN_NAME.equals(signature)) {
            this.m_columnName = StringEscapeUtils.unescapeJava((String)((String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[0])));
            this.configureModelSupport(invocation, resolver);
            return null;
        }
        if (SET_COLUMN_CLASS.equals(signature)) {
            Expression expression = arguments[0];
            if (expression instanceof TypeLiteral) {
                TypeLiteral typeLiteral = (TypeLiteral)expression;
                ITypeBinding binding = AstNodeUtils.getTypeBinding((Type)typeLiteral.getType());
                if (binding != null) {
                    this.m_columnType = GenericUtils.getObjectType(editor, binding);
                }
            } else {
                this.m_columnType = new ClassGenericType((Class)CoreUtils.evaluate(Class.class, (AstEditor)editor, (Expression)arguments[0]), null, null);
            }
            this.configureModelSupport(invocation, resolver);
            return null;
        }
        return super.parseExpression(editor, signature, invocation, arguments, resolver, provider);
    }

    private void configureModelSupport(MethodInvocation invocation, IModelResolver resolver) throws Exception {
        ColumnBindingModelSupport modelSupport = (ColumnBindingModelSupport)resolver.getModelSupport(invocation.getExpression());
        Assert.isNotNull((Object)((Object)modelSupport));
        Assert.isTrue((this == modelSupport.getModel() ? 1 : 0) != 0);
        modelSupport.addInvocation(invocation);
    }

    public boolean addSourceCodeSeparator() {
        return false;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
    }

    public void addColumnSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        generationSupport.addSourceCode((AstObjectInfo)this.m_detailProperty, lines);
        if (this.getVariableIdentifier() == null) {
            if (this.m_converter == null && this.m_validator == null) {
                StringBuffer line = new StringBuffer();
                line.append(this.m_binding.getVariableIdentifier() + ".addColumnBinding(" + this.m_detailProperty.getVariableIdentifier() + this.getCreateMethodHeaderEnd());
                if (!StringUtils.isEmpty((CharSequence)this.m_columnName)) {
                    line.append(".setColumnName(\"" + StringUtilities.escapeJava((String)this.m_columnName) + "\")");
                }
                if (!this.m_editable) {
                    line.append(".setEditable(false)");
                }
                if (this.m_columnType != null) {
                    line.append(".setColumnClass(" + this.m_columnType.getFullTypeName() + ".class)");
                }
                line.append(";");
                lines.add(line.toString());
                return;
            }
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{"columnBinding"}));
        }
        if (!this.isField()) {
            lines.add(this.m_binding.getTypeSourceCode(generationSupport) + ".ColumnBinding ");
        }
        lines.add(this.getVariableIdentifier() + " = " + this.m_binding.getVariableIdentifier() + ".addColumnBinding(" + this.m_detailProperty.getVariableIdentifier() + this.getCreateMethodHeaderEnd() + ";");
        if (!StringUtils.isEmpty((CharSequence)this.m_columnName)) {
            lines.add(this.getVariableIdentifier() + ".setColumnName(\"" + StringUtilities.escapeJava((String)this.m_columnName) + "\");");
        }
        if (!this.m_editable) {
            lines.add(this.getVariableIdentifier() + ".setEditable(false);");
        }
        if (this.m_columnType != null) {
            lines.add(this.getVariableIdentifier() + ".setColumnClass(" + this.m_columnType.getFullTypeName() + ".class);");
        }
        this.addFinishSourceCode(lines, generationSupport, false);
    }

    public void setVariableIdentifier(JavaInfo javaInfoRoot, String variable, boolean field) {
        boolean useGenerics = CoreUtils.useGenerics((IJavaProject)javaInfoRoot.getEditor().getJavaProject());
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(useGenerics);
        String type = this.m_binding.getTypeSourceCode(generationSupport) + ".ColumnBinding";
        this.setVariableIdentifier(javaInfoRoot, type, variable, field);
    }

    @Override
    public String getTargetPresentationText(boolean full) throws Exception {
        return this.m_target.getPresentation().getTextForBinding() + ".column" + CoreUtils.getDefaultString((String)this.m_columnName, (String)" - ", (String)"");
    }

    @Override
    public String getModelPresentationText(boolean full) throws Exception {
        if (this.m_detailProperty != null) {
            return this.m_detailProperty.getPresentationText(this.m_model, this.m_modelProperty, full);
        }
        return super.getModelPresentationText(full);
    }

    @Override
    public void accept(AstObjectInfoVisitor visitor) throws Exception {
        super.accept(visitor);
        if (this.m_detailProperty != null) {
            this.m_detailProperty.accept(visitor);
        }
    }
}

