/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.RequestProcessor;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.internal.gef.core.EditPartVisitor;

public abstract class EditPart
extends AbstractEditPart {
    private final List<RequestProcessor> m_requestProcessors = new ArrayList<RequestProcessor>();

    public List<EditPart> getChildren() {
        return super.getChildren();
    }

    public EditPart getParent() {
        return (EditPart)super.getParent();
    }

    protected void updateModel() {
    }

    protected List<?> getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public final void accept(EditPartVisitor visitor) {
        if (visitor.visit(this)) {
            for (EditPart childPart : this.getChildren()) {
                childPart.accept(visitor);
            }
            visitor.endVisit(this);
        }
    }

    public void refresh() {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
    }

    protected void refreshChildren() {
        EditPart childPart;
        HashMap<Object, EditPart> modelToPart = new HashMap<Object, EditPart>();
        List<EditPart> children = this.getChildren();
        for (EditPart editPart : children) {
            modelToPart.put(editPart.getModel(), editPart);
        }
        List<?> modelChildren = this.getModelChildren();
        int modelCount = modelChildren.size();
        int partCount = children.size();
        int index = 0;
        int modelIndex = 0;
        while (modelIndex < modelCount) {
            EditPart part;
            Object model = modelChildren.get(modelIndex);
            if (index < partCount && (part = children.get(index)).getModel() == model) {
                this.updateChildVisual(part, index);
            } else {
                childPart = (EditPart)((Object)modelToPart.get(model));
                if (childPart == null) {
                    org.eclipse.gef.EditPart createEditPart = this.createChild(model);
                    if (createEditPart != null) {
                        this.addChild(createEditPart, index);
                    } else {
                        --index;
                    }
                } else {
                    if (model != childPart.getModel()) {
                        childPart.unregister();
                        childPart.setModel(model);
                        childPart.register();
                        childPart.updateModel();
                    }
                    this.removeChildVisual((org.eclipse.gef.EditPart)childPart);
                    children.remove((Object)childPart);
                    children.add(index, childPart);
                    this.addChildVisual((org.eclipse.gef.EditPart)childPart, index);
                }
            }
            ++index;
            ++modelIndex;
        }
        int newPartCount = children.size();
        if (newPartCount - index > 1) {
            ArrayList deselectList = new ArrayList();
            children.listIterator(index).forEachRemaining(deselectList::add);
            this.getViewer().deselect(deselectList);
        }
        int i = index;
        while (i < newPartCount) {
            childPart = children.get(index);
            this.removeChild(childPart);
            ++i;
        }
        for (EditPart child : this.getChildren()) {
            child.refresh();
        }
    }

    protected final void removeChild(EditPart childPart) {
        int index = this.getChildren().indexOf((Object)childPart);
        if (index == -1) {
            return;
        }
        this.fireRemovingChild((org.eclipse.gef.EditPart)childPart, index);
        if (this.isActive()) {
            childPart.deactivate();
        }
        childPart.removeNotify();
        this.removeChildVisual((org.eclipse.gef.EditPart)childPart);
        this.getChildren().remove((Object)childPart);
        childPart.setParent(null);
    }

    public IEditPartViewer getViewer() {
        return this.getParent().getViewer();
    }

    protected void updateChildVisual(EditPart childPart, int index) {
    }

    @Deprecated
    public List<org.eclipse.gef.EditPolicy> getEditPolicies() {
        ArrayList<org.eclipse.gef.EditPolicy> policies = new ArrayList<org.eclipse.gef.EditPolicy>();
        this.getEditPolicyIterable().forEach(policies::add);
        return policies;
    }

    public void installEditPolicy(org.eclipse.gef.EditPolicy policy) {
        this.installEditPolicy(policy.getClass(), policy);
    }

    protected void createEditPolicies() {
    }

    private List<org.eclipse.gef.EditPolicy> getUnderstandingPolicies(Request request) {
        ArrayList<org.eclipse.gef.EditPolicy> policies = new ArrayList<org.eclipse.gef.EditPolicy>();
        for (org.eclipse.gef.EditPolicy editPolicy : this.getEditPolicyIterable()) {
            if (!editPolicy.understandsRequest(request)) continue;
            policies.add(editPolicy);
        }
        return policies;
    }

    public final void addRequestProcessor(RequestProcessor processor) {
        if (!this.m_requestProcessors.contains(processor)) {
            this.m_requestProcessors.add(processor);
        }
    }

    public final void removeRequestProcessor(RequestProcessor processor) {
        this.m_requestProcessors.remove(processor);
    }

    protected final Request processRequestProcessors(Request request) {
        try {
            for (RequestProcessor processor : this.m_requestProcessors) {
                request = processor.process(this, request);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return request;
    }

    public Command getCommand(Request request) {
        request = this.processRequestProcessors(request);
        for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
            Command command = editPolicy.getCommand(request);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        request = this.processRequestProcessors(request);
        EditPart target = null;
        for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
            EditPart newTarget = ((EditPolicy)editPolicy).getTargetEditPart(request);
            if (newTarget == null) continue;
            target = newTarget;
        }
        return target;
    }

    public void performRequest(Request request) {
        request = this.processRequestProcessors(request);
        for (org.eclipse.gef.EditPolicy editPolicy : this.getEditPolicyIterable()) {
            ((EditPolicy)editPolicy).performRequest(request);
        }
    }

    public void showSourceFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.showSourceFeedback(request);
            }
        }
    }

    public void eraseSourceFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.eraseSourceFeedback(request);
            }
        }
    }

    public void showTargetFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.showTargetFeedback(request);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (org.eclipse.gef.EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.eraseTargetFeedback(request);
            }
        }
    }
}

