/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.dev.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wb.internal.dev.builder.BuilderHandler;
import org.eclipse.wb.internal.dev.builder.ComponentDescriptionValidatorHandler;
import org.eclipse.wb.internal.dev.builder.MetaDataModificationHandler;

public final class WbBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.wb.dev.wbBuilder";
    private final List<BuilderHandler> m_handlers = new ArrayList<BuilderHandler>();

    public WbBuilder() {
        this.m_handlers.add(new ComponentDescriptionValidatorHandler());
        this.m_handlers.add(new MetaDataModificationHandler());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        for (BuilderHandler handler : this.m_handlers) {
            handler.fullBuild(project, monitor);
        }
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        for (BuilderHandler handler : this.m_handlers) {
            handler.incrementalBuild(delta, monitor);
        }
    }
}

