/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.tools.MarqueeSelectionTool;
import org.eclipse.wb.tests.gef.RequestTestCase;
import org.eclipse.wb.tests.gef.RequestTestCaseEditPart;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.Before;
import org.junit.Test;

public class MarqueeSelectionToolTest
extends RequestTestCase {
    private MarqueeSelectionTool m_tool;
    private Request m_request;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_tool = new MarqueeSelectionTool();
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_request = new Request((Object)"selection");
    }

    @Test
    public void test_Selection() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = MarqueeSelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = MarqueeSelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = MarqueeSelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart2", actualLogger, 250, 25, 100, 155);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(95, 95, 1);
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        actualLogger.assertEmpty();
        this.m_sender.dragTo(175, 175);
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"getTargetEditPart", "showTargetFeedback"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(177, 177);
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"eraseTargetFeedback", "getTargetEditPart", "showTargetFeedback"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart1.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"eraseTargetFeedback", "getTargetEditPart"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_sender.setStateMask(131072);
        this.m_sender.startDrag(295, 60, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(405, 235);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"getTargetEditPart", "showTargetFeedback"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        this.m_sender.setStateMask(0);
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart2), this.m_viewer.getSelectedEditParts().get(1));
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart2.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"eraseTargetFeedback", "getTargetEditPart"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_sender.startDrag(10, 10, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(460, 360);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "showTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "showTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        MarqueeSelectionToolTest.assertEquals((long)3L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)editPart), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(1));
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart2), this.m_viewer.getSelectedEditParts().get(2));
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)editPart.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart2.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_sender.setStateMask(262144);
        this.m_sender.startDrag(95, 60, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(405, 235);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "showTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "showTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        this.m_sender.setStateMask(0);
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)editPart), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)editPart.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)childEditPart2.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart2);
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart2.getSelected());
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_sender.setStateMask(262144);
        this.m_sender.startDrag(95, 60, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(405, 235);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "showTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "showTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        this.m_sender.setStateMask(0);
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)editPart), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(1));
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)editPart.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)childEditPart2.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.startDrag(10, 10, 1);
        this.m_sender.dragTo(100, 100);
        this.m_sender.endDrag();
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)editPart), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(1));
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)editPart.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)childEditPart2.getSelected());
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Selection_isSelectable() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = MarqueeSelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = MarqueeSelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = new RequestTestCaseEditPart("ChildEditPart2", actualLogger){

            public boolean isSelectable() {
                return false;
            }
        };
        childEditPart2.getFigure().setBounds(new Rectangle(250, 25, 100, 155));
        MarqueeSelectionToolTest.addChildEditPart((org.eclipse.gef.EditPart)editPart, (org.eclipse.gef.EditPart)childEditPart2);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.startDrag(95, 60, 1);
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        actualLogger.assertEmpty();
        this.m_sender.dragTo(405, 235);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "showTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        MarqueeSelectionToolTest.assertEquals((long)1L, (long)this.m_viewer.getSelectedEditParts().size());
        MarqueeSelectionToolTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(0));
        MarqueeSelectionToolTest.assertEquals((long)2L, (long)childEditPart1.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)editPart.getSelected());
        MarqueeSelectionToolTest.assertEquals((long)0L, (long)childEditPart2.getSelected());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Selection_InvalidInput() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = MarqueeSelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart = MarqueeSelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart", actualLogger, 50, 50, 70, 50);
        RequestsLogger expectedLogger = new RequestsLogger();
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        this.m_sender.startDrag(95, 95, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(175, 175);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, new String[]{"getTargetEditPart", "showTargetFeedback"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.click(175, 175, 3);
        MarqueeSelectionToolTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "eraseTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_domain.setActiveTool((Tool)this.m_tool);
        expectedLogger.assertEmpty();
        this.m_sender.startDrag(95, 95, 1);
        this.m_sender.dragTo(175, 175);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, new String[]{"getTargetEditPart", "showTargetFeedback"}, this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_domain.loadDefaultTool();
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "eraseTargetFeedback", this.m_request);
        MarqueeSelectionToolTest.assertLoggers(expectedLogger, actualLogger);
    }
}

