/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.tools.MarqueeSelectionTool;
import org.eclipse.wb.tests.gef.CursorLogger;
import org.eclipse.wb.tests.gef.GefCursorTestCase;
import org.junit.Before;
import org.junit.Test;

public class MarqueeSelectionToolCursorTest
extends GefCursorTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_domain.setActiveTool((Tool)new MarqueeSelectionTool());
    }

    @Test
    public void test_Move_Click_InvalidInput() throws Exception {
        GraphicalEditPart shellEditPart = MarqueeSelectionToolCursorTest.createEditPart((EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, null, null);
        this.m_viewer.select((EditPart)shellEditPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        expectedLogger.setCursor(Cursors.CROSS);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(20, 20);
        this.m_actualLogger.assertEmpty();
        this.m_sender.click(30, 30, 1);
        this.m_actualLogger.assertEmpty();
        this.m_viewer.select((EditPart)shellEditPart);
        this.m_defaultToolProvider = new GefCursorTestCase.IDefaultToolProvider(){

            @Override
            public org.eclipse.wb.gef.core.tools.Tool getDefaultTool() {
                return new MarqueeSelectionTool();
            }
        };
        this.m_domain.setActiveTool((Tool)new MarqueeSelectionTool());
        this.m_sender.moveTo(40, 20);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(40, 20, 1);
        this.m_sender.dragTo(45, 30);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(45, 30, 2);
        expectedLogger.setCursor(Cursors.NO);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.dragTo(50, 35);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }
}

