/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class EventSender {
    private final Control m_control;
    private int m_stateMask;
    private int m_dragButton;
    private int m_lastDragX;
    private int m_lastDragY;

    public EventSender(Control control) {
        this.m_control = control;
    }

    public void setStateMask(int stateMask) {
        this.m_stateMask = stateMask;
    }

    public void ctrlDown() {
        this.setStateMask(262144);
    }

    public void ctrlUp() {
        this.setStateMask(0);
    }

    public void mouseEnter(int x, int y) {
        Event event = this.createEvent(x, y, 0);
        this.m_control.notifyListeners(6, event);
    }

    public void click(org.eclipse.swt.graphics.Point location, int button) {
        this.click(location.x, location.y, button);
    }

    public void click(int x, int y, int button) {
        Event event = this.createEvent(x, y, button);
        this.m_control.notifyListeners(3, event);
        EventSender.updateStateMask(event, button);
        this.m_control.notifyListeners(4, event);
    }

    public void click(int button) {
        this.click(this.m_lastDragX, this.m_lastDragY, button);
    }

    public void click() {
        this.click(1);
    }

    public void doubleClick(int x, int y, int button) {
        Event event = this.createEvent(x, y, button);
        this.m_control.notifyListeners(3, event);
        EventSender.updateStateMask(event, button);
        this.m_control.notifyListeners(4, event);
        event.stateMask = this.m_stateMask;
        this.m_control.notifyListeners(3, event);
        this.m_control.notifyListeners(8, event);
        EventSender.updateStateMask(event, button);
        this.m_control.notifyListeners(4, event);
    }

    public EventSender moveTo(int x, int y) {
        this.saveLastMouseLocation(x, y);
        Event event = this.createEvent(x, y, 0);
        this.m_control.notifyListeners(5, event);
        EventSender.waitEventLoop(0);
        return this;
    }

    public void startDrag(int x, int y, int button) {
        this.saveLastMouseLocation(x, y);
        this.m_dragButton = button;
        Event event = this.createEvent(x, y, button);
        this.m_control.notifyListeners(3, event);
    }

    public void dragTo(Point location) {
        this.dragTo(location.x, location.y);
    }

    public void dragTo(int x, int y) {
        this.saveLastMouseLocation(x, y);
        Event event = this.createEvent(x, y, this.m_dragButton);
        EventSender.updateStateMask(event, this.m_dragButton);
        this.m_control.notifyListeners(5, event);
        EventSender.waitEventLoop(0);
    }

    public void endDrag() {
        Event event = this.createEvent(this.m_lastDragX, this.m_lastDragY, this.m_dragButton);
        EventSender.updateStateMask(event, this.m_dragButton);
        this.m_control.notifyListeners(4, event);
        this.m_dragButton = 0;
        this.m_lastDragX = 0;
        this.m_lastDragY = 0;
    }

    public void keyDown(int key) {
        this.keyDown(key, '\u0000');
    }

    public void keyUp(int key) {
        this.keyUp(key, '\u0000');
    }

    public void keyDown(int key, char c) {
        Event event = this.createKeyEvent(key, c);
        this.m_control.notifyListeners(1, event);
    }

    public void keyUp(int key, char c) {
        Event event = this.createKeyEvent(key, c);
        this.m_control.notifyListeners(2, event);
    }

    public Event createKeyEvent(int key, char c) {
        Event event = new Event();
        event.widget = this.m_control;
        event.stateMask = this.m_stateMask;
        event.keyCode = key;
        event.character = c;
        return event;
    }

    public static void waitEventLoop(int time) {
        try {
            long start = System.currentTimeMillis();
            do {
                Thread.sleep(0L);
                while (Display.getCurrent().readAndDispatch()) {
                }
            } while (System.currentTimeMillis() - start < (long)time);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    public void setVerticalBarSelection(int selection) {
        ScrollBar verticalBar = ((Scrollable)this.m_control).getVerticalBar();
        verticalBar.setSelection(selection);
        verticalBar.notifyListeners(13, new Event());
    }

    public void mouseHover(org.eclipse.swt.graphics.Point location) {
        this.mouseEnter(location.x, location.y);
    }

    public void mouseHover(int x, int y) {
        Event event = this.createEvent(x, y, 0);
        this.m_control.notifyListeners(32, event);
    }

    public static void sendText(String text) {
        char[] charArray = text.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            EventSender.sendCharacter(c);
            ++i;
        }
    }

    public static void sendCharacter(char character) {
        EventSender.sendCharacter(Character.isUpperCase(character), character);
    }

    public static void sendKey(int key) {
        EventSender.postKeyEvent(1, key, '\u0000');
        EventSender.postKeyEvent(2, key, '\u0000');
    }

    public static void sendKey(int modifiers, int key) {
        EventSender.postModifiers(1, modifiers);
        try {
            EventSender.postKeyEvent(1, key, '\u0000');
            EventSender.postKeyEvent(2, key, '\u0000');
        }
        finally {
            EventSender.postModifiers(2, modifiers);
        }
    }

    public static void sendCharacter(boolean shift, char character) {
        if (shift) {
            EventSender.postKeyEvent(1, 131072, '\u0000');
        }
        EventSender.postKeyEvent(1, 0, character);
        EventSender.postKeyEvent(2, 0, character);
        if (shift) {
            EventSender.postKeyEvent(2, 131072, '\u0000');
        }
    }

    private void saveLastMouseLocation(int x, int y) {
        this.m_lastDragX = x;
        this.m_lastDragY = y;
    }

    private Event createEvent(int x, int y, int button) {
        Event event = new Event();
        event.widget = this.m_control;
        event.stateMask = this.m_stateMask;
        event.button = button;
        event.x = x;
        event.y = y;
        return event;
    }

    private static final void updateStateMask(Event event, int button) {
        switch (button) {
            case 1: {
                event.stateMask |= 0x80000;
                break;
            }
            case 2: {
                event.stateMask |= 0x100000;
                break;
            }
            case 3: {
                event.stateMask |= 0x200000;
                break;
            }
            case 4: {
                event.stateMask |= 0x800000;
                break;
            }
            case 5: {
                event.stateMask |= 0x2000000;
            }
        }
    }

    public void postMouseMove(org.eclipse.swt.graphics.Point p) {
        this.postMouseMove(p.x, p.y);
    }

    public void postMouseMove(int x, int y) {
        Display display = Display.getCurrent();
        org.eclipse.swt.graphics.Point p = display.map(this.m_control, null, x, y);
        EventSender.postMouseMoveAbs(p.x, p.y);
    }

    public void postMouseMove(int x, int y, int button) {
        Display display = Display.getCurrent();
        org.eclipse.swt.graphics.Point p = display.map(this.m_control, null, x, y);
        Event event = new Event();
        event.type = 5;
        event.x = p.x;
        event.y = p.y;
        event.button = button;
        Display.getCurrent().post(event);
    }

    public static void postMouseMoveAbs(org.eclipse.swt.graphics.Point p) {
        EventSender.postMouseMoveAbs(p.x, p.y);
    }

    public static void postMouseMoveAbs(int x, int y) {
        Event event = new Event();
        event.type = 5;
        event.x = x;
        event.y = y;
        Display.getCurrent().post(event);
    }

    public static void postMouseDown(int button) {
        EventSender.postMouseDownUp(3, button);
    }

    public static void postMouseUp(int button) {
        EventSender.postMouseDownUp(4, button);
    }

    private static void postMouseDownUp(int type, int button) {
        Event event = new Event();
        event.type = type;
        event.button = button;
        Display.getCurrent().post(event);
    }

    private static void postKeyEvent(int type, int keyCode, char character) {
        Event event = new Event();
        event.type = type;
        event.keyCode = keyCode;
        event.character = character;
        Display.getCurrent().post(event);
    }

    private static void postModifiers(int event, int modifiers) {
        if ((modifiers & 0x20000) != 0) {
            EventSender.postKeyEvent(event, 131072, '\u0000');
        }
        if ((modifiers & 0x40000) != 0) {
            EventSender.postKeyEvent(event, 262144, '\u0000');
        }
        if ((modifiers & 0x10000) != 0) {
            EventSender.postKeyEvent(event, 262144, '\u0000');
        }
    }
}

