/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableColumnInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class TableTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_TableItem() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "      tableColumn.setWidth(100);", "    }", "    TableItem item_1 = new TableItem(table, SWT.NONE);", "    TableItem item_2 = new TableItem(table, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        List items = table.getItems();
        TableTest.assertEquals((long)2L, (long)items.size());
        TableItemInfo item_1 = (TableItemInfo)items.get(0);
        TableItemInfo item_2 = (TableItemInfo)items.get(1);
        Insets tableInsets = table.getClientAreaInsets();
        Rectangle modelBounds = item_1.getModelBounds();
        TableTest.assertNotNull((Object)modelBounds);
        TableTest.assertEquals((long)0L, (long)modelBounds.x);
        TableTest.assertEquals((long)0L, (long)modelBounds.y);
        TableTest.assertEquals((long)table.getClientArea().width, (long)modelBounds.width);
        Rectangle bounds = item_1.getBounds();
        TableTest.assertEquals((long)tableInsets.left, (long)bounds.x);
        TableTest.assertEquals((long)tableInsets.top, (long)bounds.y);
        TableTest.assertEquals((long)modelBounds.width, (long)bounds.width);
        TableTest.assertEquals((long)modelBounds.height, (long)bounds.height);
        modelBounds = item_2.getModelBounds();
        TableTest.assertEquals((long)0L, (long)modelBounds.x);
        TableTest.assertEquals((long)item_1.getModelBounds().bottom(), (long)modelBounds.y);
    }

    @Test
    public void test_TableItem_whenNoColumns() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    TableItem item = new TableItem(table, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)TableTest.getJavaInfoByName("table");
        TableItemInfo item = (TableItemInfo)TableTest.getJavaInfoByName("item");
        Insets tableInsets = table.getClientAreaInsets();
        Rectangle modelBounds = item.getModelBounds();
        TableTest.assertNotNull((Object)modelBounds);
        TableTest.assertEquals((long)0L, (long)modelBounds.x);
        TableTest.assertEquals((long)0L, (long)modelBounds.y);
        TableTest.assertEquals((long)table.getClientArea().width, (long)modelBounds.width);
        Rectangle bounds = item.getBounds();
        TableTest.assertEquals((long)tableInsets.left, (long)bounds.x);
        TableTest.assertEquals((long)tableInsets.top, (long)bounds.y);
        TableTest.assertEquals((long)modelBounds.width, (long)bounds.width);
        TableTest.assertEquals((long)modelBounds.height, (long)bounds.height);
    }

    @Test
    public void test_add_TableItem() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableTest.assertTrue((boolean)table.getItems().isEmpty());
        TableItemInfo newItem = (TableItemInfo)TableTest.createJavaInfo("org.eclipse.swt.widgets.TableItem");
        TableTest.flowContainer_CREATE((JavaInfo)table, newItem, null);
        List items = table.getItems();
        TableTest.assertEquals((long)1L, (long)items.size());
        TableTest.assertTrue((boolean)items.contains(newItem));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableItem tableItem = new TableItem(table, SWT.NONE);", "      tableItem.setText('New TableItem');", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_TableColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Table table = new Table(this, SWT.BORDER);", "    table.setHeaderVisible(true);", "    {", "      TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);", "      tableColumn_1.setWidth(50);", "    }", "    {", "      TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);", "      tableColumn_2.setWidth(100);", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        List columns = table.getColumns();
        TableTest.assertEquals((long)2L, (long)columns.size());
        TableColumnInfo column_1 = (TableColumnInfo)columns.get(0);
        TableColumnInfo column_2 = (TableColumnInfo)columns.get(1);
        Insets tableInsets = table.getClientAreaInsets();
        Rectangle modelBounds = column_1.getModelBounds();
        if (!EnvironmentUtils.IS_WINDOWS) {
            modelBounds.y += table.getWidget().getHeaderHeight();
        }
        TableTest.assertNotNull((Object)modelBounds);
        TableTest.assertEquals((long)0L, (long)modelBounds.x);
        TableTest.assertEquals((long)0L, (long)modelBounds.y);
        TableTest.assertEquals((long)50L, (long)modelBounds.width);
        TableTest.assertTrue((modelBounds.height > 15 && modelBounds.height < 50 ? 1 : 0) != 0);
        Rectangle bounds = column_1.getBounds();
        if (!EnvironmentUtils.IS_WINDOWS) {
            bounds.y += table.getWidget().getHeaderHeight();
        }
        TableTest.assertEquals((long)tableInsets.left, (long)bounds.x);
        TableTest.assertEquals((long)tableInsets.top, (long)bounds.y);
        TableTest.assertEquals((long)modelBounds.width, (long)bounds.width);
        TableTest.assertEquals((long)modelBounds.height, (long)bounds.height);
        modelBounds = column_2.getModelBounds();
        if (!EnvironmentUtils.IS_WINDOWS) {
            modelBounds.y += table.getWidget().getHeaderHeight();
        }
        TableTest.assertNotNull((Object)modelBounds);
        TableTest.assertEquals((long)50L, (long)modelBounds.x);
        TableTest.assertEquals((long)0L, (long)modelBounds.y);
    }

    @Test
    public void test_TableColumn_setWidth() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "      tableColumn.setWidth(100);", "    }", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        Property widthProperty = column.getPropertyByTitle("width");
        TableTest.assertEquals((Object)100, (Object)widthProperty.getValue());
        column.setWidth(120);
        TableTest.assertEquals((Object)120, (Object)widthProperty.getValue());
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "      tableColumn.setWidth(120);", "    }", "  }", "}");
    }

    @Test
    public void test_add_TableColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableTest.assertTrue((boolean)table.getColumns().isEmpty());
        TableColumnInfo newColumn = (TableColumnInfo)TableTest.createJavaInfo("org.eclipse.swt.widgets.TableColumn");
        TableTest.flowContainer_CREATE((JavaInfo)table, newColumn, null);
        List columns = table.getColumns();
        TableTest.assertEquals((long)1L, (long)columns.size());
        TableTest.assertTrue((boolean)columns.contains(newColumn));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "      tableColumn.setWidth(100);", "      tableColumn.setText('New Column');", "    }", "  }", "}");
    }

    @Test
    public void test_move_TableColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);", "      tableColumn_1.setText('Column 1');", "    }", "    {", "      TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);", "      tableColumn_2.setText('Column 2');", "    }", "  }", "}");
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        List columns = table.getColumns();
        TableTest.assertEquals((long)2L, (long)columns.size());
        TableColumnInfo column_1 = (TableColumnInfo)columns.get(0);
        TableColumnInfo column_2 = (TableColumnInfo)columns.get(1);
        TableTest.flowContainer_MOVE((JavaInfo)table, column_2, column_1);
        TableTest.assertSame((Object)column_2, table.getColumns().get(0));
        TableTest.assertSame((Object)column_1, table.getColumns().get(1));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Table table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);", "      tableColumn_2.setText('Column 2');", "    }", "    {", "      TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);", "      tableColumn_1.setText('Column 1');", "    }", "  }", "}");
    }

    @Test
    public void test_reparent_TableColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Table table_1 = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn_1 = new TableColumn(table_1, SWT.NONE);", "      tableColumn_1.setText('Column 1');", "    }", "    //", "    Table table_2 = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn_2 = new TableColumn(table_2, SWT.NONE);", "      tableColumn_2.setText('Column 2');", "    }", "  }", "}");
        TableInfo table_1 = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column_1 = (TableColumnInfo)table_1.getColumns().get(0);
        TableInfo table_2 = (TableInfo)shell.getChildrenControls().get(1);
        TableColumnInfo column_2 = (TableColumnInfo)table_2.getColumns().get(0);
        TableTest.flowContainer_MOVE((JavaInfo)table_2, column_1, column_2);
        List columns = table_2.getColumns();
        TableTest.assertEquals((long)2L, (long)columns.size());
        TableTest.assertSame((Object)column_1, columns.get(0));
        TableTest.assertSame((Object)column_2, columns.get(1));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Table table_1 = new Table(this, SWT.BORDER);", "    //", "    Table table_2 = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn_1 = new TableColumn(table_2, SWT.NONE);", "      tableColumn_1.setText('Column 1');", "    }", "    {", "      TableColumn tableColumn_2 = new TableColumn(table_2, SWT.NONE);", "      tableColumn_2.setText('Column 2');", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_clipboard() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);", "        tableColumn_1.setText('Column 1');", "      }", "      {", "        TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);", "        tableColumn_2.setText('Column 2');", "      }", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)TableTest.getJavaInfoByName("table");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)table);
        TableInfo newTable = (TableInfo)memento.create((JavaInfo)shell);
        shell.getLayout().command_CREATE((ControlInfo)newTable, null);
        JavaInfoMemento.apply((JavaInfo)newTable);
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);", "        tableColumn_1.setText('Column 1');", "      }", "      {", "        TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);", "        tableColumn_2.setText('Column 2');", "      }", "    }", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setText('Column 1');", "      }", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setText('Column 2');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_column_exposed() throws Exception {
        TableTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private TableColumn m_tableColumn;", "  private Table m_table;", "  //", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    m_table = new Table(this, SWT.BORDER);", "    {", "      m_tableColumn = new TableColumn(m_table, SWT.NONE);", "      m_tableColumn.setWidth(100);", "      m_tableColumn.setText('New Column');", "    }", "  }", "  public TableColumn getColumn() {", "    return m_tableColumn;", "  }", "  public Table getTable() {", "    return m_table;", "  }", "}"));
        TableTest.waitForAutoBuild();
        CompositeInfo mainComposite = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExposedComposite composite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        TableTest.assertEquals((long)1L, (long)mainComposite.getChildrenControls().size());
        CompositeInfo composite = (CompositeInfo)mainComposite.getChildrenControls().get(0);
        TableTest.assertEquals((long)1L, (long)composite.getChildren(WidgetInfo.class).size());
        TableInfo exposedTable = (TableInfo)composite.getChildren(TableInfo.class).get(0);
        TableTest.assertNotNull((Object)exposedTable);
        WidgetInfo exposedColumn = (WidgetInfo)exposedTable.getChildren(WidgetInfo.class).get(0);
        TableTest.assertNotNull((Object)exposedColumn);
        TableTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)exposedColumn.getCreationSupport());
        TableTest.assertInstanceOf(ExposedPropertyVariableSupport.class, (Object)exposedColumn.getVariableSupport());
    }

    @Test
    public void test_item_exposed() throws Exception {
        TableTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private TableItem m_tableItem;", "  private Table m_table;", "  //", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    m_table = new Table(this, SWT.BORDER);", "    {", "      TableColumn tableColumn = new TableColumn(m_table, SWT.NONE);", "      tableColumn.setWidth(100);", "      tableColumn.setText('New Column');", "    }", "    {", "      m_tableItem = new TableItem(m_table, SWT.NONE);", "      m_tableItem.setText('New Item');", "    }", "  }", "  public TableItem getItem() {", "    return m_tableItem;", "  }", "  public Table getTable() {", "    return m_table;", "  }", "}"));
        TableTest.waitForAutoBuild();
        CompositeInfo mainComposite = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExposedComposite composite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        TableTest.assertEquals((long)1L, (long)mainComposite.getChildrenControls().size());
        CompositeInfo composite = (CompositeInfo)mainComposite.getChildrenControls().get(0);
        TableTest.assertEquals((long)1L, (long)composite.getChildren(WidgetInfo.class).size());
        TableInfo exposedTable = (TableInfo)composite.getChildren(TableInfo.class).get(0);
        TableTest.assertNotNull((Object)exposedTable);
        WidgetInfo exposedItem = (WidgetInfo)exposedTable.getChildren(WidgetInfo.class).get(0);
        TableTest.assertNotNull((Object)exposedItem);
        TableTest.assertInstanceOf(ItemInfo.class, (Object)exposedItem);
        TableTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)exposedItem.getCreationSupport());
        TableTest.assertInstanceOf(ExposedPropertyVariableSupport.class, (Object)exposedItem.getVariableSupport());
    }
}

